package com.elitesland.scp.application.service.order;

import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

@RequiredArgsConstructor
@Slf4j
@RestController
@RequestMapping(CallBackPathConstant.SCP_DEMAND_ORDER_ADD)
public class ScpDemandOrderWorkflowCallBackController implements WorkflowCallBack {

    private final ScpDemandOrderService scpDemandOrderService;

    /**
     * 动态指定任务负责人
     *
     * @return 任务处理人USER_ID集合
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("payload:{}", payload);
        return WorkflowResult.success(new ArrayList<>());
    }

    /**
     * 任务创建后回调
     *
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}", payload.toString());
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成后回调
     *
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调:{}", payload.toString());
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     *
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("payload:{}", payload);
        scpDemandOrderService.processStatusChange(payload.getBusinessKey(), payload.getProcInstStatus(), payload.getCommentInfo());
        return WorkflowResult.success(null);
    }

}
