package com.elitesland.scp.application.web.alloc;


import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.*;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingSaveVO;
import com.elitesland.scp.application.service.alloc.ScpAllocSettingService;
import com.elitesland.scp.utils.excel.listener.DchExcelEntityDataListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Slf4j
@Api(tags = "订货强配接口")
@RestController
@RequestMapping(value = "/alloc/setting", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpAllocSettingController {

    private final ScpAllocSettingService scpAllocSettingService;

    @ApiOperation(value = "订货强配-  分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpAllocSettingPageRespVO>> queryAllocSetting(@RequestBody ScpAllocSettingPageParamVO paramVO) {
        log.info("[SCP-ALLOC-SETTING] queryAllocSetting  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpAllocSettingService.page(paramVO));
    }

    @ApiOperation("订货强配 - 根据ID查询订货强配活动信息")
    @GetMapping("/findIdOne/{id}")
    public ApiResult<ScpAllocSettingRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-ALLOC-SETTING] findIdOne, id ={}", id);
        return ApiResult.ok(scpAllocSettingService.findAllocSettingById(id));
    }

    @PostMapping("/save")
    @ApiOperation("订货强配 - 保存")
    public ApiResult<Long> saveAllocSetting(@RequestBody @Validated ScpAllocSettingSaveVO saveVO) {
        log.info("[SCP-ALLOC-SETTING] saveAllocSetting  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpAllocSettingService.saveAllocSetting(saveVO));
    }

    @ApiOperation("订货强配 - 启用/禁用")
    @PostMapping("/change")
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpAllocSettingStatusParamVO paramVO) {
        log.info("[SCP-ALLOC-SETTING] changeStatus paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpAllocSettingService.changeAllocSettingStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation("订货强配门店更新最大强配次数")
    @PostMapping("/storeChangeMaxNum")
    public ApiResult<Object> storeChangeMaxNum(@RequestBody @Validated List<ScpAllocSettingStoreChangeParamVO>  paramVO) {
        log.info("[SCP-ALLOC-SETTING] storeChangeMaxNum paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpAllocSettingService.storeChangeMaxNum(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation("订货强配门店刷新")
    @PostMapping("/storeRefresh")
    public ApiResult<Object> storeRefresh(@RequestBody @Validated ScpAllocSettingStoreRefreshParamVO paramVO) {
        log.info("[SCP-ALLOC-SETTING] storeRefresh paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpAllocSettingService.storeRefresh(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation("订货强配 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-ALLOC-SETTING] delete ids = {}", JSONUtil.toJsonStr(ids));
        scpAllocSettingService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @PostMapping("/imports/store")
    @ApiOperation("明细门店导入")
    public ApiResult<List<ScpAllocSettingStoreRespVO>> importStoreData(MultipartFile file) throws InterruptedException {
        DchExcelEntityDataListener<ScpAllocSettingImportStoreParamVO> dataListener = new DchExcelEntityDataListener<>();
        try {
            EasyExcel.read(file.getInputStream(), ScpAllocSettingImportStoreParamVO.class, dataListener).sheet(0).headRowNumber(2).doRead();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ApiResult.fail("解析excel数据出现异常");
        }
        List<ScpAllocSettingImportStoreParamVO> list = dataListener.getDatas();
        return ApiResult.ok(scpAllocSettingService.importStoreData(list));
    }

}
