package com.elitesland.scp.application.web.minOrder;


import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingImportStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingSaveVO;
import com.elitesland.scp.application.service.minOrder.ScpMinOrderSettingService;
import com.elitesland.scp.utils.excel.listener.DchExcelEntityDataListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Slf4j
@Api(tags = "订货起订接口")
@RestController
@RequestMapping(value = "/minOrder/setting", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpMinOrderSettingController {

    private final ScpMinOrderSettingService scpMinOrderSettingService;

    @ApiOperation(value = "起订活动-分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpMinOrderSettingPageRespVO>> queryMinOrderSetting(@RequestBody ScpMinOrderSettingPageParamVO paramVO) {
        log.info("[SCP-MinOrder-SETTING] queryMinOrderSetting  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpMinOrderSettingService.page(paramVO));
    }

    @ApiOperation("起订活动 - 根据ID查询起订活动信息")
    @GetMapping("/findIdOne/{id}")
    public ApiResult<ScpMinOrderSettingRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-MinOrder-SETTING] findIdOne, id ={}", id);
        return ApiResult.ok(scpMinOrderSettingService.findMinOrderSettingById(id));
    }

    @PostMapping("/save")
    @ApiOperation("起订活动 - 保存")
    public ApiResult<Long> saveMinOrderSetting(@RequestBody @Validated ScpMinOrderSettingSaveVO saveVO) {
        log.info("[SCP-MinOrder-SETTING] saveMinOrderSetting  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpMinOrderSettingService.saveMinOrderSetting(saveVO));
    }

    @ApiOperation("起订活动 - 启用/禁用")
    @PostMapping("/change")
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpMinOrderSettingStatusParamVO paramVO) {
        log.info("[SCP-MinOrder-SETTING] changeStatus paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpMinOrderSettingService.changeMinOrderSettingStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation("起订活动 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-MinOrder-SETTING] delete ids = {}", JSONUtil.toJsonStr(ids));
        scpMinOrderSettingService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @PostMapping("/imports/store")
    @ApiOperation("明细门店导入")
    public ApiResult<List<ScpMinOrderSettingStoreRespVO>> importStoreData(MultipartFile file) throws InterruptedException {
        DchExcelEntityDataListener<ScpMinOrderSettingImportStoreParamVO> dataListener = new DchExcelEntityDataListener<>();
        try {
            EasyExcel.read(file.getInputStream(), ScpMinOrderSettingImportStoreParamVO.class, dataListener).sheet(0).headRowNumber(2).doRead();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ApiResult.fail("解析excel数据出现异常");
        }
        List<ScpMinOrderSettingImportStoreParamVO> list = dataListener.getDatas();
        return ApiResult.ok(scpMinOrderSettingService.importStoreData(list));
    }

}
