package com.elitesland.scp.application.web.stock;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.*;
import com.elitesland.scp.application.service.stock.ScpPredictStStockService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 供应链计划-预测安全库存目标库存 前端控制器
 * </p>
 *
 * @author jeesie.jiang
 * @since 2025-01-21
 */
@RestController
@RequestMapping("/predict-st-stock")
@Slf4j
@Api(tags = "预测安全库存&&目标库存")
@AllArgsConstructor
@Validated
public class ScpPredictStStockController {

    private final ScpPredictStStockService scpPredictStStockService;


    @ApiOperation(value = "预测安全库存&&目标库存-新建")
    @PostMapping(value = "/batchSave")
    public ApiResult<?> saveBatch(@Valid @RequestBody List<ScpPredictStStockSaveVO> createParam) {
        scpPredictStStockService.saveBatch(createParam);
        return ApiResult.ok();
    }


    @ApiOperation(value = "预测安全库存&&目标库存-更新")
    @PostMapping(value = "/update")
    public ApiResult<?> update(@RequestBody List<ScpPredictStStockSaveVO> param) {
        scpPredictStStockService.update(param);
        return ApiResult.ok();
    }

    @ApiOperation(value = "预测安全库存&&目标库存-删除")
    @PostMapping(value = "/delete")
    public ApiResult<?> delete(@RequestBody List<Long> ids) {
        scpPredictStStockService.delete(ids);
        return ApiResult.ok();
    }




}
