package com.elitesland.scp.common;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2024/03/18
 */
public final class ScpConstant {

    private ScpConstant() {
    }


    /**
     * 订货模板编码
     */
    public static final String BKTE = "BKTE";
    /**
     * 门店订货集编码
     */
    public static final String BKST = "BKST";

    /**
     * 仓库订货集编码
     */
    public static final String BKWH = "BKWH";

    public static final String MDDHJ = "门店订货集";

    public static final String CKDHJ = "仓库订货集";

    public static final String ALLOC_COMPUTE_CONFIG = "ALLOC_COMPUTE_CONFIG";

    public static final String ORDER_PRODUCT_STATUS_VALUE = "ORDER_PRODUCT_STATUS_VALUE";

    public static final String ALLOC_COMPUTE_LOCK = "alloc:compute:lock:%s";

    public static final String COMPUTE_DOING = "计算中";

    public static final String COMPUTE_DONE = "计算完毕";

    public static final String NO_COMPUTE = "无需计算";

    //订货单发号器编码
    public static final String OB = "OB";

    public static final String SALE_PRICE_CLS = "SALE_PRICE";

    //内部结算价
    public static final String INTERNAL_SETTLEMENT_PRICE = "INTERNAL_SETTLEMENT_PRICE";

    public static final String CNY = "CNY";
    public static final String CNY_NAME = "人民币";

    public static final String BTB = "BTB";

    public static final String POS = "POS";
    public static final String SO = "SO";

    public static final String RETAIL_PRICE = "RETAIL_PRICE";

    public static final String ORDER_PUSH_LOCK = "order:push:lock:%s";

    public static final String PUSH_DOING = "推送中";

    public static final String PUSH_DONE = "推送完毕";

    //发货
    public static final String DELIVERY = "DELIVERY";

    //收货
    public static final String RECV = "RECV";

    public static final String ZF = "ZF";

    //取消
    public static final String CANCEL = "CANCEL";

    public static final String ENT_PAY_PROPERTIES = "ENT_PAY_PROPERTIES";

    public static final String CART_PREFIX = "SCP:CART:";

    public static final String COLLECT_PREFIX = "SCP:COLLECT:";

    public static final String SPU = "SPU";

    public static final String SKU = "SKU";

    public static final String SCP_ONLINE_PAY = "SCP_ONLINE_PAY:";


    // 第三方 构造网页授权链接
    public final static String THIRD_BUS_WECHAT_AUTHORIZE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=snsapi_privateinfo&state=STATE&agentid=AGENTID#wechat_redirect";

    // 第三方应用id（即ww或wx开头的suite_id）
    public static final String APP_ID = "APPID";

    public static final String REDIRECT_URI = "REDIRECT_URI";

    public static final String AGENTID = "AGENTID";

    /**
     * 获取访问用户身份
     */
    public final static String USER_INFO_URL = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo";


    /**
     * 获取访问用户敏感信息
     */
    public final static String USER_INFO_DETAIL_URL = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail?access_token=ACCESS_TOKEN";


    public static final String ACCESS_TOEKN = "ACCESS_TOKEN";

    public static final String CODE = "CODE";

    /**
     * web组件登录
     */
    public final static String SSO_WECHAT_AUTHORIZE_URL = "https://login.work.weixin.qq.com/wwlogin/sso/login?login_type=LOGIN_TYPE&appid=APPID&redirect_uri=REDIRECT_URI&state=STATE";

    public static final String LOGIN_TYPE = "LOGIN_TYPE";

    /**
     * 小程序登录URL
     */
    public final static String MG_LOGIN_URL = "https://qyapi.weixin.qq.com/cgi-bin/miniprogram/jscode2session";

    public final static String MG_USER_INFO_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/get";

    /**
     * PC端登录
     */
    public final static String WECHAT_LOGIN_TYPE_PC = "PC";

    /**
     * 小程序登录
     */
    public final static String WECHAT_LOGIN_TYPE_MG = "MG";

    /**
     * 强配活动编码
     */
    public static final String FA = "FA";

    public static final String ALLOC_SETTING = "SCP:ALLOC:SETTING:";

    public static final String MIN_ORDER_SETTING = "SCP:MINORDER:SETTING:";
    
    public static final String PUR_LIMIT_SETTING = "SCP:PUR_LIMIT:SETTING:";

    public static final String PUR_SCENE_TYPE_CODE_001 = "001";


    public static final String MRP_STOCK = "F";


    public static final String WQF_APPLY = "WA";

    public static final List<String>  WH_DELIVERY_TYPES = List.of("110","120","160","170");

    public static final List<String>  PUR_TRN_DELIVERY_TYPES = List.of("130");

    public static final List<String>  PUR_DELIVERY_TYPES = List.of("130","140","150");

}
