package com.elitesland.scp.infr.repo.minOrder;

import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingRegionRespVO;
import com.elitesland.scp.domain.entity.minOrder.QScpMinOrderSettingRegionDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpMinOrderSettingRegionRepoProc {
    private static final QScpMinOrderSettingRegionDO scpMinOrderSettingRegionDO = QScpMinOrderSettingRegionDO.scpMinOrderSettingRegionDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<ScpMinOrderSettingRegionRespVO> pageList = Projections.bean(
            ScpMinOrderSettingRegionRespVO.class,
            scpMinOrderSettingRegionDO.id,
            scpMinOrderSettingRegionDO.masId,
            scpMinOrderSettingRegionDO.region,
            scpMinOrderSettingRegionDO.regionName

    );

    public long countMinOrderSettingRegion(ScpMinOrderSettingRegionPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpMinOrderSettingRegionDO.count())
                .from(scpMinOrderSettingRegionDO);
        jpaQuery.where(this.whereMinOrderSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpMinOrderSettingRegionRespVO> queryMinOrderSettingRegion(ScpMinOrderSettingRegionPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpMinOrderSettingRegionDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpMinOrderSettingRegionDO);
        jpaQuery.where(this.whereMinOrderSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereMinOrderSettingPage(ScpMinOrderSettingRegionPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getMasId() != null) {
            predicates.add(scpMinOrderSettingRegionDO.masId.eq(paramVO.getMasId()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<Long> findMasIdByRegionCode(String regionCode) {
        var jpaQuery = jpaQueryFactory.select(scpMinOrderSettingRegionDO.masId).distinct()
                .from(scpMinOrderSettingRegionDO);
        jpaQuery.where(scpMinOrderSettingRegionDO.region.eq(regionCode));
        return jpaQuery.fetch();
    }

}
