package com.elitesland.scp.utils;


import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

/**
 * Created by lance on 2025/8/4.
 */
public class PinyinUtil {

//    public static void main(String[] args) {
//        System.out.println(getFirstLetter("中国-乌龙奶茶"));
//    }

    /**
     * 获取中文首字母
     *
     * @param chinese
     * @return
     */
    public static String getFirstLetter(String chinese) {
        String[] chars = chinese.split("");
        StringBuilder result = new StringBuilder();
        for (String charStr : chars) {
            if (charStr.matches("[\\u4e00-\\u9fa5]+")) {
                try {
                    String[] hanyuPinyinStringArray = PinyinHelper.toHanyuPinyinStringArray(charStr.charAt(0), new HanyuPinyinOutputFormat());
                    String s = hanyuPinyinStringArray[0].charAt(0) + "";
                    result.append(s);
                } catch (BadHanyuPinyinOutputFormatCombination e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result.toString();
    }
}
