/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.scpsman;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanImportSaveVO;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.application.service.scpsman.StandardScpsmanImportEntity;
import com.elitesland.scp.domain.convert.scpsman.SalesmanInfoConvert;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScpsmanImportServiceImpl
implements DataImport<StandardScpsmanImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(ScpsmanImportServiceImpl.class);
    private final ScpsmanInfoService scpsmanInfoService;
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u6821\u9a8c\u5f02\u5e38: {2}; ";

    public Set<Integer> sheetNoList() {
        return Collections.singleton(1);
    }

    public Integer stepSize() {
        return 1000000;
    }

    public String getTmplCode() {
        return "yst_scp_scpsman_import";
    }

    public List<String> executeImport(List<StandardScpsmanImportEntity> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            List<String> errorMsg = this.checkAndSaveData(dataList, startRowIndex);
            log.info("\u8ba1\u5212\u5458\u5bfc\u5165\u5904\u7406\u5b8c\u6210,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b:{},\u9519\u8bef\u4fe1\u606f\u6761\u6570{}", (Object)JSONUtil.toJsonStr(errorMsg), (Object)errorMsg.size());
            return errorMsg;
        }
        catch (Exception e) {
            log.error("\u8ba1\u5212\u5458\u5bfc\u5165\u5f02\u5e38\uff1a", (Throwable)e);
            for (StandardScpsmanImportEntity entity : dataList) {
                errors.add(e.getMessage());
            }
            return errors;
        }
    }

    private List<String> checkAndSaveData(List<StandardScpsmanImportEntity> dataList, int startRowIndex) {
        log.info("startRowIndex\u7684\u503c:{}", (Object)startRowIndex);
        List<SalesmanImportSaveVO> recommendRelateCustVOS = SalesmanInfoConvert.INSTANCE.toSalesmanImportSaveVOS(dataList);
        HashMap<Integer, String> indexScpsmanNoMapping = new HashMap<Integer, String>();
        for (int i = 0; i < dataList.size(); ++i) {
            indexScpsmanNoMapping.put(i + startRowIndex, dataList.get(i).getScpsmanNo());
        }
        log.info("indexScpsmanNoMapping\u7684\u503c:{}", (Object)JSONUtil.toJsonStr(indexScpsmanNoMapping));
        List<String> scpsmanNoList = dataList.stream().map(StandardScpsmanImportEntity::getScpsmanNo).collect(Collectors.toList());
        Map<String, List<Integer>> indexMap = this.processDuplicate(scpsmanNoList, startRowIndex);
        log.info("indexMap\u7684\u503c:{}", (Object)JSONUtil.toJsonStr(indexMap));
        Map<String, String> errorInfoMap = this.scpsmanInfoService.salesmanImport(recommendRelateCustVOS).getErrorInfoMap();
        log.info("errorInfoMap\u7684\u503c:{}", (Object)JSONUtil.toJsonStr(errorInfoMap));
        return this.processErrorList(indexScpsmanNoMapping, indexMap, errorInfoMap, startRowIndex, startRowIndex + dataList.size() - 1);
    }

    private Map<String, List<Integer>> processDuplicate(List<String> scpsmanNoList, int startRowIndex) {
        HashMap<String, List<Integer>> indexMap = new HashMap<String, List<Integer>>();
        for (int i = 0; i < scpsmanNoList.size(); ++i) {
            String element = scpsmanNoList.get(i);
            if (!indexMap.containsKey(element)) {
                indexMap.put(element, new ArrayList());
            }
            ((List)indexMap.get(element)).add(i + startRowIndex);
        }
        return indexMap;
    }

    private List<String> processErrorList(Map<Integer, String> indexScpsmanNoMapping, Map<String, List<Integer>> indexMap, Map<String, String> errorInfoMap, int start, int end) {
        log.info("errorInfoMap\u7684\u503c:{}", (Object)JSONUtil.toJsonStr(errorInfoMap));
        ArrayList<String> errorList = new ArrayList<String>();
        for (int i = start; i <= end; ++i) {
            String scpsmanNo = indexScpsmanNoMapping.get(i);
            if (indexMap.get(scpsmanNo).size() > 1) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i, "\u8ba1\u5212\u5458\u7f16\u53f7", "\u7f16\u53f7\u91cd\u590d"));
                continue;
            }
            if (errorInfoMap.containsKey(scpsmanNo) && StrUtil.isNotBlank((CharSequence)errorInfoMap.get(scpsmanNo))) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i, "", errorInfoMap.get(scpsmanNo)));
                continue;
            }
            errorList.add(null);
        }
        if (CollUtil.isEmpty(errorList)) {
            return new ArrayList<String>();
        }
        return errorList;
    }

    public ScpsmanImportServiceImpl(ScpsmanInfoService scpsmanInfoService) {
        this.scpsmanInfoService = scpsmanInfoService;
    }
}

