/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.job.task;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationRespVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationSaveVO;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.service.whnet.ScpWhNetRelationDomainService;
import com.elitesland.support.provider.org.dto.OrgStoreRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ScpWhNetRelationHandler {
    private static final Logger log = LoggerFactory.getLogger(ScpWhNetRelationHandler.class);
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;
    @Autowired
    private ScpWhNetRelationDomainService scpWhNetRelationDomainService;
    @Autowired
    private ScpWhNetRelationService scpWhNetRelationService;
    @Autowired
    private InvWhProvider invWhProvider;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @XxlJob(value="scpStoreWhNetRelation")
    public ReturnT<String> scpStoreWhNetRelation(String param) {
        log.info("\u95e8\u5e97\u4f9b\u5e94\u5173\u7cfb\u8865\u5145\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
        try {
            ApiResult storeApiResult = this.orgStoreRpcService.queryAllStoreAddr();
            if (storeApiResult.isFailed()) {
                log.info("\u5168\u90e8\u95e8\u5e97\u5730\u5740\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\u6216");
                return ReturnT.FAIL;
            }
            List storeList = (List)storeApiResult.getData();
            if (CollectionUtils.isEmpty((Collection)storeList)) {
                log.info("\u95e8\u5e97\u6570\u636e\u4e3a\u7a7a");
                return ReturnT.SUCCESS;
            }
            List<ScpWhNetRelationRespVO> whNetList = this.scpWhNetRelationDomainService.findAllNotItem();
            Map<String, List<ScpWhNetRelationRespVO>> whNetMap = whNetList.stream().collect(Collectors.groupingBy(ScpWhNetRelationRespVO::getDemandWhStCode));
            for (OrgStoreRpcDTO store : storeList) {
                InvWhRpcDtoParam invWhRpcDtoParam = new InvWhRpcDtoParam();
                invWhRpcDtoParam.setWhCode(store.getStoreCode());
                invWhRpcDtoParam.setDeliveryPCode(store.getProvince());
                invWhRpcDtoParam.setDeliveryCCode(store.getCity());
                invWhRpcDtoParam.setDeliveryACode(store.getCounty());
                log.info("\u4ed3\u5e93\u914d\u9001\u8303\u56f4\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)invWhRpcDtoParam));
                ApiResult deliveryWhResult = this.invWhProvider.findByAllDelivery(invWhRpcDtoParam);
                log.info("\u4ed3\u5e93\u914d\u9001\u8303\u56f4\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)deliveryWhResult));
                if (!deliveryWhResult.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)deliveryWhResult.getData()))) continue;
                List deliveryWhList = (List)deliveryWhResult.getData();
                List<ScpWhNetRelationRespVO> existWhNetList = whNetMap.get(store.getStoreCode());
                log.info("\u5df2\u7ecf\u5b58\u5728\u7684\u4ed3\u7f51\u5173\u7cfb\uff1a{}", (Object)JSONObject.toJSONString((Object)deliveryWhResult));
                ArrayList saveVoList = new ArrayList();
                deliveryWhList.forEach(wh -> {
                    boolean existFlag = existWhNetList.stream().anyMatch(net -> net.getDeliveryType().equals(wh.getDeliveryType()) && net.getSupplyWhCode().equals(wh.getWhCode()));
                    if (!existFlag) {
                        ScpWhNetRelationSaveVO.ScpWhNetRelation saveVO = new ScpWhNetRelationSaveVO.ScpWhNetRelation();
                        saveVO.setType("0");
                        saveVO.setSupplyWhCode(wh.getWhCode());
                        saveVO.setSupplyWhId(wh.getWhId());
                        saveVO.setSupplyWhName(wh.getWhName());
                        saveVO.setSupplyWhOuId(wh.getOuId());
                        saveVO.setSupplyWhOuCode(wh.getOuCode());
                        saveVO.setDemandWhStCode(store.getStoreCode());
                        saveVO.setDemandWhStId(store.getId());
                        saveVO.setDemandWhStName(store.getStoreName());
                        saveVO.setDemandWhStOuId(store.getOuId());
                        saveVO.setDemandWhStOuCode(store.getOuCode());
                        saveVO.setOuCode(wh.getOuCode());
                        saveVO.setDeliveryType(wh.getDeliveryType());
                        saveVO.setSupplyPercentage(BigDecimal.valueOf(100L));
                        saveVO.setStatus(Boolean.TRUE);
                        saveVO.setStartTime(store.getCreateTime());
                        saveVO.setEndTime(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
                        if (ScpConstant.PUR_DELIVERY_TYPES.contains(saveVO.getDeliveryType())) {
                            saveVO.setPurCompanyCode(saveVO.getOuCode());
                            saveVO.setOuCode(null);
                            saveVO.setOuName(null);
                        }
                        saveVoList.add(saveVO);
                    }
                    ScpWhNetRelationSaveVO scpWhNetRelationSaveVO = new ScpWhNetRelationSaveVO();
                    scpWhNetRelationSaveVO.setScpWhNetRelations(saveVoList);
                    scpWhNetRelationSaveVO.setSkipPathFlag(Boolean.TRUE);
                    this.saveWhNetRelation(scpWhNetRelationSaveVO);
                });
            }
            log.info("\u95e8\u5e97\u4f9b\u5e94\u5173\u7cfb\u8865\u5145\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f");
        }
        catch (Exception e) {
            log.error("\u95e8\u5e97\u4f9b\u5e94\u5173\u7cfb\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("\u95e8\u5e97\u4f9b\u5e94\u5173\u7cfb\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25:" + e.getMessage());
        }
        return ReturnT.SUCCESS;
    }

    public void saveWhNetRelation(ScpWhNetRelationSaveVO scpWhNetRelationSaveVO) {
        TransactionTemplate requiresNewTemplate = new TransactionTemplate(Objects.requireNonNull(this.transactionTemplate.getTransactionManager()));
        requiresNewTemplate.setPropagationBehavior(3);
        try {
            log.info("\u4fdd\u5b58\u95e8\u5e97\u4ed3\u7f51\u5173\u7cfb\u5f00\u59cb\uff1a{}", JSONObject.toJSON((Object)scpWhNetRelationSaveVO));
            this.scpWhNetRelationService.saveWhNetRelation(scpWhNetRelationSaveVO);
            log.info("\u4fdd\u5b58\u95e8\u5e97\u4ed3\u7f51\u5173\u7cfb\u7ed3\u675f\uff1a{}", JSONObject.toJSON((Object)scpWhNetRelationSaveVO));
        }
        catch (Exception e) {
            log.info("\u4fdd\u5b58\u95e8\u5e97\u4ed3\u7f51\u5173\u7cfb\u5931\u8d25\uff1a{}", JSONObject.toJSON((Object)scpWhNetRelationSaveVO));
        }
    }
}

