/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.org.dto.OrgRegionDTO;
import com.elitesland.support.provider.org.param.OrgRegionQueryDTO;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RmiOrgRegionRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiOrgRegionRpcService.class);
    private final OrgRegionRpcService orgRegionRpcService;

    public Map<String, OrgRegionDTO> findRegionMapByCodes(List<String> regionCodes) {
        log.info("\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u96c6\u5408\uff1aregionCodes={}", regionCodes);
        try {
            ApiResult apiResult = this.orgRegionRpcService.findSimpleByRegionCodes(regionCodes);
            if (apiResult.isFailed()) {
                throw new BusinessException("\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:" + apiResult.getMsg());
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)apiResult.getData()))) {
                return new HashMap<String, OrgRegionDTO>();
            }
            log.info("\u67e5\u8be2\u533a\u57df\u5217\u8868\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)apiResult.getData()));
            return ((List)apiResult.getData()).stream().collect(Collectors.toMap(OrgRegionDTO::getRegionCode, Function.identity(), (k1, k2) -> k1));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u96c6\u5408\u5931\u8d25:{}", (Object)e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u96c6\u5408\u63a5\u53e3\u5f02\u5e38:" + e);
        }
    }

    public Map<String, OrgRegionDTO> findDetailRegionMapByCodes(List<String> regionCodes) {
        log.info("\u67e5\u8be2\u533a\u57df\u8be6\u7ec6\u4fe1\u606f\u96c6\u5408\uff1aregionCodes={}", regionCodes);
        try {
            OrgRegionQueryDTO param = new OrgRegionQueryDTO();
            param.setRegionCodes(new HashSet<String>(regionCodes));
            param.setEnabled(Boolean.valueOf(true));
            ApiResult apiResult = this.orgRegionRpcService.queryList(param);
            if (apiResult.isFailed()) {
                throw new BusinessException("\u67e5\u8be2\u533a\u57df\u8be6\u7ec6\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:" + apiResult.getMsg());
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)apiResult.getData()))) {
                return new HashMap<String, OrgRegionDTO>();
            }
            log.info("\u67e5\u8be2\u533a\u57df\u8be6\u7ec6\u4fe1\u606f\u5217\u8868\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)apiResult.getData()));
            return ((List)apiResult.getData()).stream().collect(Collectors.toMap(OrgRegionDTO::getRegionCode, Function.identity(), (k1, k2) -> k1));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u533a\u57df\u8be6\u7ec6\u4fe1\u606f\u96c6\u5408\u5931\u8d25:{}", (Object)e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u533a\u57df\u8be6\u7ec6\u4fe1\u606f\u96c6\u5408\u63a5\u53e3\u5f02\u5e38:" + e);
        }
    }

    public RmiOrgRegionRpcService(OrgRegionRpcService orgRegionRpcService) {
        this.orgRegionRpcService = orgRegionRpcService;
    }
}

