package com.elitesland.scp.application.facade.vo.boh;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class StoreReceiveDDetailVO implements Serializable {
    @ApiModelProperty("明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品url")
    private String imageUrl;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("单位")
    private String uom;
    private String uomName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("订货数")
    private BigDecimal orderQty;

    @ApiModelProperty("已发数")
    private BigDecimal deliveryQty;

    @ApiModelProperty("实收数")
    private BigDecimal receiveQty;

    @ApiModelProperty("退货数量")
    private BigDecimal returnQty;

    @ApiModelProperty("赔付数量")
    private BigDecimal compensateQty;

    @ApiModelProperty("可供量")
    private BigDecimal stkQty;

    @ApiModelProperty("可退数量")
    private BigDecimal canRtnQty;

    @ApiModelProperty("库存状态")
    private String limit1;
    private String limit1Name;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("生产日期")
    private LocalDateTime expireDate;

    private String manuFactory;

    private String manuFactoryName;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("订货单明细id")
    private Long orderDid;

    @ApiModelProperty("是否管理批次")
    private Boolean lotFlag;

    @ApiModelProperty("厂家")
    private String lotFlagName;

    private Boolean giftFlag;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty("保留小数位")
    private Integer decimalPlaces;

    @ApiModelProperty("子件")
    private List<StoreReceiveDDetailVO> subItemList;

    @ApiModelProperty(name = "商品单位信息")
    private List<StoreReceiveItemUomDetail> itemUomList;
}