package com.elitesland.scp.application.facade.vo.param.minOrder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
@ApiModel(value = "订货强配活动查询参数")
public class ScpMinOrderSettingParamVO implements Serializable {
    private static final long serialVersionUID = 1106421717241032854L;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("业务类型")
    @NotBlank(message = "业务类型不能为空")
    private String businessType;

    @ApiModelProperty("类型")
    @NotBlank(message = "类型不能为空")
    private String type;

    @ApiModelProperty("门店编码")
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;
}
