package com.elitesland.scp.application.facade.vo.whnet;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 22日 16:51
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpWhNetRelationImportVO", description = "仓网关系导入")
public class ScpWhNetRelationImportVO implements Serializable {

    @ApiModelProperty(value = "配送类型")
    private String deliveryType;

    @ApiModelProperty(value = "配送类型名称")
    private String deliveryTypeName;

    @ApiModelProperty(value = "供应仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long supplyWhId;

    @ApiModelProperty(value = "供应仓库编码")
    private String supplyWhCode;

    @ApiModelProperty(value = "供应仓库名称")
    private String supplyWhName;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "类型名")
    private String typeName;

    @ApiModelProperty(value = "需求门店id/门店仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandWhStId;

    @ApiModelProperty(value = "门店编码")
    private String demandWhStCode;

    @ApiModelProperty(value = "门店名称")
    private String demandWhStName;

    @ApiModelProperty(value = "销售公司编码")
    private String saleOuCode;

    @ApiModelProperty(value = "销售公司名称")
    private String saleOuName;

    @ApiModelProperty(value = "采购公司编码")
    private String purOuCode;

    @ApiModelProperty(value = "采购公司名称")
    private String purOuName;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "有效日期从 字符串")
    private String startTimeStr;

    @ApiModelProperty(value = "有效日期至 字符串")
    private String endTimeStr;

    @ApiModelProperty(value = "有效日期从")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "有效日期至")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "行号")
    private Integer lineNo;
//
//    @ApiModelProperty("分组编号")
//    private String importBillNum;

    @ApiModelProperty(value = "状态")
    private Boolean status;
}
