package com.elitesland.scp.application.service.calendar;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarExportRespVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;


@Component
@RequiredArgsConstructor
public class ScpStoreCalendarSetExportImpl implements DataExport<ScpStoreCalendarExportRespVO, ScpStoreDemandCalendarPageParamVO> {

    private final ScpStoreDemandCalendarService scpStoreDemandCalendarService;

    @Override
    public String getTmplCode() {
        return "scp_store_calendar_set_export";
    }

    // 门店订货日历导出模板
    @Override
    public PagingVO<ScpStoreCalendarExportRespVO> executeExport(ScpStoreDemandCalendarPageParamVO queryParam) {
        return scpStoreDemandCalendarService.export(queryParam);
    }

}
