package com.elitesland.scp.application.web.app;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.app.AppLoginAccountStoreProtocolRespVO;
import com.elitesland.scp.application.facade.vo.param.app.AppStoreProtocolAgreeParamVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoRespVO;
import com.elitesland.scp.application.service.app.AppStoreProtocolService;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.application.web.app.enums.LoginAccountType;
import com.elitesland.scp.application.web.app.util.AccountIdentifierUtil;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.provider.authority.ScpmansAuthorityRpcServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.units.qual.A;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 09月 16日 15:12
 * @version: 1.0
 */
@RestController
@RequestMapping("/app/store/protocol")
@RequiredArgsConstructor
@Api(value = "app-门店登陆协议管理", tags = {"app-门店登陆协议管理"})
@Slf4j
public class AppStoreProtocolContorller {

    private final AppStoreProtocolService appStoreProtocolService;


    @PostMapping("/agree")
    @ApiOperation("门店协议同意状态更新")
    public ApiResult<?> setStoreProtocolAgreeStatus(@RequestBody AppStoreProtocolAgreeParamVO param) {
        appStoreProtocolService.setProtocolAgreeStatus(param);
        return ApiResult.ok();
    }

    @GetMapping("/search/{account}")
    @ApiOperation("查询协议状态")
    public ApiResult<AppLoginAccountStoreProtocolRespVO> search(@PathVariable("account") String account) {
        return ApiResult.ok(appStoreProtocolService.queryStoreProtocolByAccount(account));
    }

    @GetMapping("/query")
    @ApiOperation("门店协议查询")
    public ApiResult<?> serchStoreProtocol() {
        return ApiResult.ok(appStoreProtocolService.serchStoreProtocol());
    }





}
