package com.elitesland.scp.application.web.demo;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateEmployeeSendParamDTO;
import com.elitescloud.cloudt.system.service.SysMsgTemplateSendRpcService;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Api(tags = "demo")
@RestController
@RequestMapping(value = "/demo", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class DemoController {

    private final SysMsgTemplateSendRpcService sysMsgTemplateSendRpcService;

    @ApiOperation("企微消息")
    @GetMapping("/wechat")
    public ApiResult<ScpDemandOrderRespVO> findIdOne() {
        try {
            log.info("企微消息发送开始：" + LocalDateTime.now());
            TemplateEmployeeSendParamDTO dto = new TemplateEmployeeSendParamDTO();
            dto.setTemplateCode("INTERFACE_SEND_RECV_ERROR");
            //处理内容文本占位传参 start
            Map<String, String> contentTemplateParams = new HashMap<>();
            contentTemplateParams.put("business_key", "DOSIOOOS90111");
            contentTemplateParams.put("req_time", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss")));
            contentTemplateParams.put("resp_time", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss")));
            contentTemplateParams.put("sys_from", "WMS");
            contentTemplateParams.put("sys_to", "云时通");
            contentTemplateParams.put("interface_url", "www.baidu.com");
            contentTemplateParams.put("error_msg", "请求失败请检查");
            dto.setContentReplaceMap(contentTemplateParams);
            Map<String, String> titleParams = new HashMap<>();
            titleParams.put("msg_title", "测试推送WMS消息");
            dto.setTitleReplaceMap(titleParams);
            sysMsgTemplateSendRpcService.msgTemplateSend(dto);
            log.info("企微消息发送成功：" + LocalDateTime.now());
        } catch (Exception e) {
            log.error("企微消息发送成功，" + ExceptionUtils.getStackTrace(e));
        }
        return ApiResult.ok();
    }

}
