package com.elitesland.scp.domain.convert.order;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderReplySaveVO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderReplyDO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderReplyDTO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

/**
 * @Author: ryan.xu
 * @since 2024/03/18
 */
@Mapper(config = BaseMapperConfig.class)
public interface ScpDemandOrderReplyConvert {
    ScpDemandOrderReplyConvert INSTANCE = Mappers.getMapper(ScpDemandOrderReplyConvert.class);

    ScpDemandOrderReplyRespVO dtoToRespVO(ScpDemandOrderReplyDTO replyDTO);

    ScpDemandOrderReplyDO saveVoToDO(ScpDemandOrderReplySaveVO saveVO);

    ScpDemandOrderReplyDTO doToDto(ScpDemandOrderReplyDO invCkDO);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDo(ScpDemandOrderReplySaveVO saveVO, @MappingTarget ScpDemandOrderReplyDO replyDO);

}
