package com.elitesland.scp.infr.repo.alloc;

import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingDO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingItemDO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingStoreDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpAllocSettingItemRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpAllocSettingStoreDO scpAllocSettingStoreDO = QScpAllocSettingStoreDO.scpAllocSettingStoreDO;
    private static final QScpAllocSettingDO scpAllocSettingDO = QScpAllocSettingDO.scpAllocSettingDO;
    private static final QScpAllocSettingItemDO scpAllocSettingItemDO = QScpAllocSettingItemDO.scpAllocSettingItemDO;

    public List<ScpAllocSettingItemRespVO> getAllocSettingItemByStoreCode(String storeCode, String docType, List<String> itemType2s) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpAllocSettingItemRespVO.class,
                        scpAllocSettingItemDO.id,
                        scpAllocSettingItemDO.masId,
                        scpAllocSettingItemDO.itemId,
                        scpAllocSettingItemDO.itemCode,
                        scpAllocSettingItemDO.itemName,
                        scpAllocSettingItemDO.minNum,
                        scpAllocSettingItemDO.itemType2,
                        scpAllocSettingDO.activityCode
                )).from(scpAllocSettingDO)
                .leftJoin(scpAllocSettingItemDO).on(scpAllocSettingDO.id.eq(scpAllocSettingItemDO.masId))
                .leftJoin(scpAllocSettingStoreDO).on(scpAllocSettingStoreDO.masId.eq(scpAllocSettingDO.id));
        jpaQuery.where(scpAllocSettingStoreDO.storeCode.eq(storeCode));
        jpaQuery.where(scpAllocSettingItemDO.itemType2.in(itemType2s));
        jpaQuery.where(scpAllocSettingStoreDO.maxNum.gt(scpAllocSettingStoreDO.allocNum));
        jpaQuery.where(scpAllocSettingDO.docType.like("%" + docType + "%"));
        jpaQuery.where(scpAllocSettingDO.status.eq(Boolean.TRUE));
        LocalDateTime now = LocalDateTime.now();
        jpaQuery.where(scpAllocSettingDO.validFrom.loe(now).and(scpAllocSettingDO.validTo.goe(now)));
        return jpaQuery.fetch();
    }

    public List<Long> findMasIdByItemId(Long itemId) {
        var jpaQuery = jpaQueryFactory.select(scpAllocSettingItemDO.masId).distinct()
                .from(scpAllocSettingItemDO);
        jpaQuery.where(scpAllocSettingItemDO.itemId.eq(itemId));
        return jpaQuery.fetch();
    }

}
