/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.item;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemOperationAddParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemOperationParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemOperationVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemOperationVisibleParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPreSaleParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpItemSaleScopeImportParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpItemSaleScopeStoreImportVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpItemVisibleScopeImportParam;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.application.service.item.ScpCateItemService;
import com.elitesland.scp.domain.entity.item.ScpCateItemDO;
import com.elitesland.scp.domain.entity.item.ScpCateItemSaleScopeRegionDO;
import com.elitesland.scp.domain.entity.item.ScpCateItemSaleScopeStoreDO;
import com.elitesland.scp.domain.service.item.ScpCateItemDomainService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepo;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.infr.repo.item.ScpCateItemSaleScopeRegionRepo;
import com.elitesland.scp.infr.repo.item.ScpCateItemSaleScopeStoreRepo;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.PinyinUtil;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpCateItemServiceImpl
implements ScpCateItemService {
    private static final Logger log = LoggerFactory.getLogger(ScpCateItemServiceImpl.class);
    private final ScpCateItemDomainService scpCateItemDomainService;
    private final ScpCateItemRepo scpCateItemRepo;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final RmiItemService rmiItemService;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpCateItemSaleScopeStoreRepo scpCateItemSaleScopeStoreRepo;
    private final ScpCateItemSaleScopeRegionRepo scpCateItemSaleScopeRegionRepo;
    private final OrgStoreRpcService orgStoreRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindItem(ScpCateItemParam cateStoreParam) {
        Map<Long, List<String>> rootBrandMap = this.rmiItemService.findRootBrandByCateId(cateStoreParam.getCateId());
        List<String> brands = rootBrandMap.values().stream().findAny().get();
        if (CollUtil.isEmpty(brands)) {
            throw new BusinessException("\u54c1\u7c7b\u4e0b\u65e0\u54c1\u724c\u4fe1\u606f");
        }
        Long rootId = (Long)rootBrandMap.keySet().stream().findAny().get();
        String brand = String.join((CharSequence)";", brands);
        List<ScpCateItemParam.CateItem> items = cateStoreParam.getItems();
        List itemIds = items.stream().map(ScpCateItemParam.CateItem::getItemId).distinct().collect(Collectors.toList());
        ItmItemBaseRpcParam rpcParam = new ItmItemBaseRpcParam();
        rpcParam.setItemIds(itemIds);
        Map itmMap = this.rmiItemService.findItemBaseRpcDtoByParam(rpcParam).stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getId, Function.identity()));
        this.scpCateItemDomainService.saveBatch(items.stream().map(item -> {
            ScpCateItemDO scpCateItemDO = (ScpCateItemDO)BeanUtils.toBean((Object)item, ScpCateItemDO.class);
            if (ObjectUtils.isNotEmpty((Object)item.getItemId()) && MapUtils.isNotEmpty((Map)itmMap)) {
                ItmItemBaseRpcDTO itmItemRpcDTO = (ItmItemBaseRpcDTO)itmMap.get(item.getItemId());
                scpCateItemDO.setSpuId(itmItemRpcDTO.getSpuId());
                scpCateItemDO.setSpuCode(itmItemRpcDTO.getSpuCode());
                scpCateItemDO.setSpuName(itmItemRpcDTO.getSpuName());
                scpCateItemDO.setItemType(itmItemRpcDTO.getItemType());
                scpCateItemDO.setAnotherName(itmItemRpcDTO.getAnotherName());
                scpCateItemDO.setItemType2(itmItemRpcDTO.getItemType2());
                scpCateItemDO.setCombineItemFlag(ScpUdcEnum.ITM_ITM_TYPE_70.getValueCode().equals(itmItemRpcDTO.getItemType()));
            }
            try {
                String firstLetter = PinyinUtil.getFirstLetter(scpCateItemDO.getSpuName());
                scpCateItemDO.setFirstLetter(firstLetter);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u9996\u5b57\u6bcd\u5931\u8d25", (Throwable)e);
            }
            scpCateItemDO.setCateCode(cateStoreParam.getCateCode());
            scpCateItemDO.setCateId(cateStoreParam.getCateId());
            scpCateItemDO.setBrand(brand);
            scpCateItemDO.setRootCateId(rootId);
            return scpCateItemDO;
        }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(List<Long> ids) {
        this.scpCateItemDomainService.delete(ids);
    }

    @Override
    public ApiResult<List<ScpCateItemDTO>> query(CateItemRpcParam cateItemRpcParam) {
        return this.scpCateItemDomainService.query(cateItemRpcParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeHotFlag(ScpCateItemHotParamVO paramVO) {
        this.scpCateItemDomainService.changeHotFlag(paramVO);
    }

    @Override
    public PagingVO<ScpCateItemRespVO> page(ScpCateItemPageParamVO paramVO) {
        return this.scpCateItemDomainService.page(paramVO);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO paramVO) {
        if (CollUtil.isNotEmpty(paramVO.getItemStatus2List())) {
            ItmItemBaseRpcParam itemParam = new ItmItemBaseRpcParam();
            itemParam.setItemStatus2List(paramVO.getItemStatus2List());
            List<ItmItemBaseRpcDTO> itemList = this.rmiItemService.findItemBaseRpcDtoByParam(itemParam);
            if (CollectionUtils.isEmpty(itemList)) {
                return PagingVO.empty();
            }
            paramVO.setItemIds(itemList.stream().map(ItmItemBaseRpcDTO::getId).filter(Objects::nonNull).distinct().toList());
        }
        PagingVO<ScpCateItemPageVO> scpCateItemPage = this.scpCateItemDomainService.skuPage(paramVO);
        List<Long> itemIds = scpCateItemPage.getRecords().stream().map(ScpCateItemPageVO::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemSimpleRpcDTO> baseItemMap = this.rmiItemService.findBaseItemMap(itemIds);
        for (ScpCateItemPageVO record : scpCateItemPage.getRecords()) {
            ItmItemSimpleRpcDTO itmItemSimpleRpcDTO = baseItemMap.get(record.getItemId());
            if (ObjectUtils.isEmpty((Object)itmItemSimpleRpcDTO)) continue;
            record.setItemName(itmItemSimpleRpcDTO.getItemName());
            record.setSpec(itmItemSimpleRpcDTO.getSpec());
            record.setItemCateFullName(itmItemSimpleRpcDTO.getItemCateFullName());
            record.setBrandName(itmItemSimpleRpcDTO.getBrandName());
            record.setTaxRate(itmItemSimpleRpcDTO.getTaxRate());
            record.setTaxRate2(itmItemSimpleRpcDTO.getTaxRate2());
            record.setItemType(itmItemSimpleRpcDTO.getItemType());
            record.setItemSupplySource(itmItemSimpleRpcDTO.getItemSupplySource());
            record.setLotFlag(itmItemSimpleRpcDTO.getLotFlag());
            record.setAllocType(itmItemSimpleRpcDTO.getAllocType());
            record.setGuaranteePeriod(itmItemSimpleRpcDTO.getGuaranteePeriod());
            record.setGuaranteePeriodUnit(itmItemSimpleRpcDTO.getGuaranteePeriodUnit());
            record.setSuppCode(itmItemSimpleRpcDTO.getSuppCode());
            record.setSuppName(itmItemSimpleRpcDTO.getSuppName());
            record.setItemStatus2(itmItemSimpleRpcDTO.getItemStatus2());
            record.setItemStatus2Name(itmItemSimpleRpcDTO.getItemStatus2Name());
        }
        return scpCateItemPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setSaleScope(ScpCateItemOperationParam param) {
        List collect;
        List scpCateItemDOList = this.scpCateItemRepo.findAllById(param.getIdList());
        if (CollUtil.isEmpty((Collection)scpCateItemDOList)) {
            throw new BusinessException("\u8bbe\u7f6e\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        HashMap scpCateItemSaleScopeRegionDOSMap = new HashMap();
        HashMap scpCateItemSaleScopeStoreDOListMap = new HashMap();
        for (ScpCateItemDO scpCateItemDO : scpCateItemDOList) {
            scpCateItemDO.setSaleStatus(true);
            scpCateItemDO.setSaleDateStart(param.getDateStart());
            scpCateItemDO.setSaleDateEnd(param.getDateEnd());
            if (CollUtil.isNotEmpty(param.getRegionCodes())) {
                List scpCateItemSaleScopeRegionDOS = param.getRegionCodes().stream().map(regionCode -> {
                    ScpCateItemSaleScopeRegionDO scpCateItemSaleScopeRegionDO = new ScpCateItemSaleScopeRegionDO();
                    scpCateItemSaleScopeRegionDO.setMasId(scpCateItemDO.getId());
                    scpCateItemSaleScopeRegionDO.setRegionCode((String)regionCode);
                    return scpCateItemSaleScopeRegionDO;
                }).collect(Collectors.toList());
                scpCateItemSaleScopeRegionDOSMap.put(scpCateItemDO.getId(), scpCateItemSaleScopeRegionDOS);
            }
            if (!CollUtil.isNotEmpty(param.getStoreCodes())) continue;
            List scpCateItemSaleScopeStoreDOList = param.getStoreCodes().stream().map(storeCode -> {
                ScpCateItemSaleScopeStoreDO scpCateItemSaleScopeStoreDO = new ScpCateItemSaleScopeStoreDO();
                scpCateItemSaleScopeStoreDO.setMasId(scpCateItemDO.getId());
                scpCateItemSaleScopeStoreDO.setStoreCode((String)storeCode);
                return scpCateItemSaleScopeStoreDO;
            }).collect(Collectors.toList());
            scpCateItemSaleScopeStoreDOListMap.put(scpCateItemDO.getId(), scpCateItemSaleScopeStoreDOList);
        }
        this.scpCateItemRepo.saveAll(scpCateItemDOList);
        if (CollUtil.isNotEmpty(scpCateItemSaleScopeRegionDOSMap)) {
            this.scpCateItemSaleScopeRegionRepo.deleteByMasIdIn(scpCateItemSaleScopeRegionDOSMap.keySet());
            collect = scpCateItemSaleScopeRegionDOSMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).peek(v -> v.setId(null)).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(collect)) {
                this.scpCateItemSaleScopeRegionRepo.saveAll(collect);
            }
        }
        if (CollUtil.isNotEmpty(scpCateItemSaleScopeStoreDOListMap)) {
            this.scpCateItemSaleScopeStoreRepo.deleteByMasIdIn(scpCateItemSaleScopeStoreDOListMap.keySet());
            collect = scpCateItemSaleScopeStoreDOListMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).peek(v -> v.setId(null)).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(collect)) {
                this.scpCateItemSaleScopeStoreRepo.saveAll(collect);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSaleScope(ScpCateItemOperationAddParam param) {
        List scpCateItemDOList = this.scpCateItemRepo.findAllById(param.getIdList());
        if (CollUtil.isEmpty((Collection)scpCateItemDOList)) {
            throw new BusinessException("\u8bbe\u7f6e\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        List<Long> idList = param.getIdList();
        List<String> storeCodes = param.getStoreCodes();
        for (Long masId : idList) {
            this.scpCateItemSaleScopeStoreRepo.deleteByMasIdAndStoreCodeList(masId, storeCodes);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSaleScope(ScpCateItemOperationAddParam param) {
        List<ScpCateItemSaleScopeStoreDO> collect;
        List scpCateItemDOList = this.scpCateItemRepo.findAllById(param.getIdList());
        if (CollUtil.isEmpty((Collection)scpCateItemDOList)) {
            throw new BusinessException("\u8bbe\u7f6e\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        HashMap scpCateItemSaleScopeStoreDOListMap = new HashMap();
        List<Long> masIds = scpCateItemDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        Map existingStoreCodeMap = this.scpCateItemSaleScopeStoreRepo.findAllByMasIdInAndStoreCodeIn(masIds, param.getStoreCodes()).stream().collect(Collectors.groupingBy(ScpCateItemSaleScopeStoreDO::getMasId, Collectors.mapping(ScpCateItemSaleScopeStoreDO::getStoreCode, Collectors.toList())));
        scpCateItemDOList.forEach(scpCateItemDO -> {
            scpCateItemDO.setSaleStatus(true);
            if (CollUtil.isNotEmpty(param.getStoreCodes())) {
                List storeCodeList = (List)existingStoreCodeMap.get(scpCateItemDO.getId());
                List<ScpCateItemSaleScopeStoreDO> scpCateItemSaleScopeStoreDOList = param.getStoreCodes().parallelStream().filter(v -> {
                    if (CollUtil.isNotEmpty((Collection)storeCodeList)) {
                        return !storeCodeList.contains(v);
                    }
                    return true;
                }).map(storeCode -> {
                    ScpCateItemSaleScopeStoreDO scpCateItemSaleScopeStoreDO = new ScpCateItemSaleScopeStoreDO();
                    scpCateItemSaleScopeStoreDO.setMasId(scpCateItemDO.getId());
                    scpCateItemSaleScopeStoreDO.setStoreCode((String)storeCode);
                    scpCateItemSaleScopeStoreDO.setId(null);
                    return scpCateItemSaleScopeStoreDO;
                }).toList();
                scpCateItemSaleScopeStoreDOListMap.put(scpCateItemDO.getId(), scpCateItemSaleScopeStoreDOList);
            }
        });
        if (CollUtil.isNotEmpty(scpCateItemSaleScopeStoreDOListMap) && CollUtil.isNotEmpty(collect = scpCateItemSaleScopeStoreDOListMap.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).toList())) {
            this.scpCateItemRepo.saveAll(scpCateItemDOList);
            this.scpCateItemSaleScopeStoreRepo.saveAll(collect);
        }
    }

    @Override
    public ScpCateItemOperationVO getSaleScope(Long id) {
        ScpCateItemDO scpCateItemDO = (ScpCateItemDO)this.scpCateItemRepo.findById(id).orElseThrow(() -> new BusinessException("\u8bbe\u7f6e\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        ScpCateItemOperationVO result = new ScpCateItemOperationVO();
        result.setId(scpCateItemDO.getId());
        result.setDateStart(scpCateItemDO.getSaleDateStart());
        result.setDateEnd(scpCateItemDO.getSaleDateEnd());
        List<ScpCateItemSaleScopeStoreDO> storeDOList = this.scpCateItemSaleScopeStoreRepo.findAllByMasId(id);
        ArrayList<ScpCateItemOperationVO.StoreInfo> storeInfos = new ArrayList<ScpCateItemOperationVO.StoreInfo>();
        ArrayList<String> storeCodes = new ArrayList<String>();
        if (CollUtil.isNotEmpty(storeDOList)) {
            for (ScpCateItemSaleScopeStoreDO scpCateItemSaleScopeStoreDO : storeDOList) {
                ScpCateItemOperationVO.StoreInfo storeInfo = new ScpCateItemOperationVO.StoreInfo();
                storeCodes.add(scpCateItemSaleScopeStoreDO.getStoreCode());
                storeInfo.setStoreCode(scpCateItemSaleScopeStoreDO.getStoreCode());
                storeInfo.setVisibleStatus(scpCateItemSaleScopeStoreDO.getVisibleStatus());
                storeInfo.setVisibleDateStart(scpCateItemSaleScopeStoreDO.getVisibleDateStart());
                storeInfo.setVisibleDateEnd(scpCateItemSaleScopeStoreDO.getVisibleDateEnd());
                storeInfos.add(storeInfo);
            }
            result.setStoreCodes(storeCodes);
            result.setStoreList(storeInfos);
        }
        return result;
    }

    @Override
    public void setVisibleScope(ScpCateItemOperationVisibleParam param) {
        if (CollUtil.isEmpty(param.getStoreCodes())) {
            throw new BusinessException("\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<ScpCateItemSaleScopeStoreDO> scpCateItemSaleScopeStoreDOList = new ArrayList<ScpCateItemSaleScopeStoreDO>();
        List<ScpCateItemSaleScopeStoreDO> masIdIn = this.scpCateItemSaleScopeStoreRepo.findAllByMasIdIn(param.getIdList());
        Map<Long, List<ScpCateItemSaleScopeStoreDO>> masIdMap = masIdIn.stream().collect(Collectors.groupingBy(ScpCateItemSaleScopeStoreDO::getMasId));
        for (List<ScpCateItemSaleScopeStoreDO> list : masIdMap.values()) {
            Map storeCodeMap = list.stream().collect(Collectors.toMap(ScpCateItemSaleScopeStoreDO::getStoreCode, Function.identity()));
            for (String storeCode : param.getStoreCodes()) {
                ScpCateItemSaleScopeStoreDO scpCateItemSaleScopeStoreDO = (ScpCateItemSaleScopeStoreDO)storeCodeMap.get(storeCode);
                if (scpCateItemSaleScopeStoreDO == null) {
                    throw new BusinessException("\u5b58\u5728\u5546\u54c1\u53ef\u89c1\u8303\u56f4\u4e0d\u5c5e\u4e8e\u53ef\u552e\u8303\u56f4\uff0c\u53ef\u89c1\u72b6\u6001\u8bbe\u7f6e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
                }
                scpCateItemSaleScopeStoreDO.setVisibleStatus(param.getLimitFlag());
                if (param.getLimitFlag().booleanValue()) {
                    if (param.getDateStart() == null || param.getDateEnd() == null) {
                        throw new BusinessException("\u8bf7\u9009\u62e9\u5546\u54c1\u53ef\u89c1\u8303\u56f4\u751f\u6548\u65f6\u95f4\uff01");
                    }
                    scpCateItemSaleScopeStoreDO.setVisibleDateStart(param.getDateStart());
                    scpCateItemSaleScopeStoreDO.setVisibleDateEnd(param.getDateEnd());
                } else {
                    scpCateItemSaleScopeStoreDO.setVisibleDateStart(null);
                    scpCateItemSaleScopeStoreDO.setVisibleDateEnd(null);
                }
                scpCateItemSaleScopeStoreDOList.add(scpCateItemSaleScopeStoreDO);
            }
        }
        List allById = this.scpCateItemRepo.findAllById(param.getIdList());
        allById = allById.stream().peek(scpCateItemDO -> {
            List scpCateItemSaleScopeStoreDOS = (List)masIdMap.get(scpCateItemDO.getId());
            Optional<ScpCateItemSaleScopeStoreDO> any = scpCateItemSaleScopeStoreDOS.stream().filter(ScpCateItemSaleScopeStoreDO::getVisibleStatus).findAny();
            scpCateItemDO.setVisibleStatus(any.isPresent());
        }).collect(Collectors.toList());
        this.scpCateItemRepo.saveAll(allById);
        if (CollUtil.isNotEmpty(scpCateItemSaleScopeStoreDOList)) {
            this.scpCateItemSaleScopeStoreRepo.saveAll(scpCateItemSaleScopeStoreDOList);
        }
    }

    @Override
    public ScpCateItemOperationVO getVisibleScope(Long id) {
        ScpCateItemDO scpCateItemDO = (ScpCateItemDO)this.scpCateItemRepo.findById(id).orElseThrow(() -> new BusinessException("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        ScpCateItemOperationVO result = new ScpCateItemOperationVO();
        result.setId(scpCateItemDO.getId());
        List<ScpCateItemSaleScopeStoreDO> storeDOList = this.scpCateItemSaleScopeStoreRepo.findAllByMasIdAndVisibleStatus(id, true);
        ArrayList<ScpCateItemOperationVO.StoreInfo> storeInfos = new ArrayList<ScpCateItemOperationVO.StoreInfo>();
        ArrayList<String> storeCodes = new ArrayList<String>();
        if (CollUtil.isNotEmpty(storeDOList)) {
            for (ScpCateItemSaleScopeStoreDO scpCateItemSaleScopeStoreDO : storeDOList) {
                ScpCateItemOperationVO.StoreInfo storeInfo = new ScpCateItemOperationVO.StoreInfo();
                storeCodes.add(scpCateItemSaleScopeStoreDO.getStoreCode());
                storeInfo.setStoreCode(scpCateItemSaleScopeStoreDO.getStoreCode());
                storeInfo.setVisibleStatus(scpCateItemSaleScopeStoreDO.getVisibleStatus());
                storeInfo.setVisibleDateStart(scpCateItemSaleScopeStoreDO.getVisibleDateStart());
                storeInfo.setVisibleDateEnd(scpCateItemSaleScopeStoreDO.getVisibleDateEnd());
                storeInfos.add(storeInfo);
            }
            result.setStoreCodes(storeCodes);
            result.setStoreList(storeInfos);
        }
        return result;
    }

    @Override
    public ApiResult<String> setPreSaleStatus(ScpCateItemPreSaleParam param) {
        this.scpCateItemRepo.updatePreStatusByIdIn(param.getIdList(), param.getStatus());
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> setUpDownStatus(ScpCateItemPreSaleParam param) {
        List collect;
        List allById = this.scpCateItemRepo.findAllById(param.getIdList());
        if (CollUtil.isEmpty((Collection)allById)) {
            throw new BusinessException("\u8bbe\u7f6e\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        if (param.getStatus().booleanValue() && CollUtil.isNotEmpty(collect = allById.stream().filter(v -> !Objects.equals(v.getSaleStatus(), Boolean.TRUE)).collect(Collectors.toList()))) {
            return ApiResult.ok((Object)"\u6279\u91cf\u4e0a\u67b6\u5931\u8d25\uff0c\u5b58\u5728\u672a\u7ef4\u62a4\u53ef\u552e\u8303\u56f4\u7684\u5546\u54c1\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u8fdb\u884c\u4e0a\u67b6\uff01");
        }
        this.scpCateItemRepo.updateUpDownStatusByIdIn(param.getIdList(), param.getStatus());
        return ApiResult.ok();
    }

    @Override
    public List<String> getVisibleAndSaleAndUpItemList(List<String> itemCodeList, String storeCode) {
        return this.scpCateItemRepoProc.getVisibleAndSaleAndUpItemList(itemCodeList, storeCode);
    }

    @Override
    public List<String> getSaleAndUpItemList(List<String> itemCodeList, String storeCode) {
        return this.scpCateItemRepoProc.getSaleAndUpItemList(itemCodeList, storeCode);
    }

    @Override
    public List<String> getPreSaleItemList(List<String> itemCodeList) {
        return this.scpCateItemRepoProc.getPreSaleItemList(itemCodeList);
    }

    @Override
    public void saveSortNo(Long id, Integer sorNo) {
        this.scpCateItemDomainService.saveSorNo(id, sorNo);
    }

    @Override
    @Transactional
    public ApiResult<Object> importSaleScope(List<ScpItemSaleScopeStoreImportVO> list, ScpItemSaleScopeImportParam param) {
        if (CollUtil.isEmpty(list)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> storeCodes = list.stream().map(ScpItemSaleScopeStoreImportVO::getStoreCode).filter(StringUtils::isNotBlank).toList();
        if (CollUtil.isEmpty(storeCodes)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u62a5\u8d27\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
        orgStoreBaseRpcParam.setStoreCodeList(storeCodes);
        ApiResult apiResult = this.orgStoreRpcService.findSimpleStoreByParam(orgStoreBaseRpcParam);
        if (apiResult.isFailed() || CollectionUtils.isEmpty((Collection)((Collection)apiResult.getData()))) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\u6216\u95e8\u5e97\u4e0d\u5b58\u5728");
        }
        List storeList = (List)apiResult.getData();
        List<String> existStoreCodes = storeList.stream().map(OrgStoreBaseRpcDTO::getStoreCode).toList();
        List<String> errorStoreCodes = storeCodes.stream().filter(storeCode -> !existStoreCodes.contains(storeCode)).toList();
        ScpCateItemOperationParam itemOperationParam = new ScpCateItemOperationParam();
        itemOperationParam.setDateStart(param.getDateStart());
        itemOperationParam.setDateEnd(param.getDateEnd());
        if (itemOperationParam.getDateStart() == null) {
            itemOperationParam.setDateStart(LocalDateTime.of(LocalDate.now(), LocalTime.MIN));
        }
        if (itemOperationParam.getDateEnd() == null) {
            itemOperationParam.setDateEnd(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
        }
        itemOperationParam.setIdList(List.of(param.getId()));
        itemOperationParam.setStoreCodes(existStoreCodes);
        this.setSaleScope(itemOperationParam);
        ApiResult result = ApiResult.ok();
        if (CollUtil.isNotEmpty(errorStoreCodes)) {
            result.setErrorMsg("\u95e8\u5e97\u7f16\u7801\u4e0d\u5b58\u5728\uff1a" + String.join((CharSequence)",", errorStoreCodes));
        }
        return result;
    }

    @Override
    public ApiResult<Object> importVisibleScope(List<ScpItemSaleScopeStoreImportVO> list, ScpItemVisibleScopeImportParam param) {
        if (CollUtil.isEmpty(list)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> storeCodes = list.stream().map(ScpItemSaleScopeStoreImportVO::getStoreCode).filter(StringUtils::isNotBlank).toList();
        if (CollUtil.isEmpty(storeCodes)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u62a5\u8d27\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
        orgStoreBaseRpcParam.setStoreCodeList(storeCodes);
        ApiResult apiResult = this.orgStoreRpcService.findSimpleStoreByParam(orgStoreBaseRpcParam);
        if (apiResult.isFailed() || CollectionUtils.isEmpty((Collection)((Collection)apiResult.getData()))) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\u6216\u95e8\u5e97\u4e0d\u5b58\u5728");
        }
        List storeList = (List)apiResult.getData();
        List<String> existStoreCodes = storeList.stream().map(OrgStoreBaseRpcDTO::getStoreCode).toList();
        List<String> errorStoreCodes = storeCodes.stream().filter(storeCode -> !existStoreCodes.contains(storeCode)).toList();
        ScpCateItemOperationVisibleParam itemOperationParam = new ScpCateItemOperationVisibleParam();
        itemOperationParam.setLimitFlag(param.getLimitFlag());
        itemOperationParam.setDateStart(param.getDateStart());
        itemOperationParam.setDateEnd(param.getDateEnd());
        itemOperationParam.setIdList(List.of(param.getId()));
        itemOperationParam.setStoreCodes(existStoreCodes);
        this.setVisibleScope(itemOperationParam);
        ApiResult result = ApiResult.ok();
        if (CollUtil.isNotEmpty(errorStoreCodes)) {
            result.setErrorMsg("\u95e8\u5e97\u7f16\u7801\u4e0d\u5b58\u5728\uff1a" + String.join((CharSequence)",", errorStoreCodes));
        }
        return result;
    }

    public ScpCateItemServiceImpl(ScpCateItemDomainService scpCateItemDomainService, ScpCateItemRepo scpCateItemRepo, ScpCateItemRepoProc scpCateItemRepoProc, RmiItemService rmiItemService, RmiSysUDCService rmiSysUDCService, ScpCateItemSaleScopeStoreRepo scpCateItemSaleScopeStoreRepo, ScpCateItemSaleScopeRegionRepo scpCateItemSaleScopeRegionRepo, OrgStoreRpcService orgStoreRpcService) {
        this.scpCateItemDomainService = scpCateItemDomainService;
        this.scpCateItemRepo = scpCateItemRepo;
        this.scpCateItemRepoProc = scpCateItemRepoProc;
        this.rmiItemService = rmiItemService;
        this.rmiSysUDCService = rmiSysUDCService;
        this.scpCateItemSaleScopeStoreRepo = scpCateItemSaleScopeStoreRepo;
        this.scpCateItemSaleScopeRegionRepo = scpCateItemSaleScopeRegionRepo;
        this.orgStoreRpcService = orgStoreRpcService;
    }
}

