/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.scpsman;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanDetailInfoRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoQueryVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoSimpleQueryVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoSimpleRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanSimpleInfoRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanSubordinateQueryVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanSuperiorQueryVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanSuperiorRespVO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.dto.scpsman.SalesmanUpdateDTO;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ScpsmanInfoRepoProc
extends BaseRepoProc<ScpsmanInfoDO> {
    @Autowired
    private ScpsmanInfoRepo scpsmanInfoRepo;
    private static final QScpsmanInfoDO Q_SALESMAN_INFO_DO = QScpsmanInfoDO.scpsmanInfoDO;

    protected ScpsmanInfoRepoProc() {
        super((EntityPathBase)Q_SALESMAN_INFO_DO);
    }

    public JPAQuery<SalesmanInfoRespVO> findSalesmanInfo(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanInfoRespVO.class, (Expression[])new Expression[]{ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanType, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouCode, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouName, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.name, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.source, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.businessType, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.creator, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.createTime, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.updater, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.modifyTime, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.jurisdictionAll})).from((EntityPath)Q_SALESMAN_INFO_DO);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        ScpsmanInfoRepoProc.where(salesmanInfoQueryVO, predicates);
        ((JPAQuery)jpaQuery.where(ExpressionUtils.allOf(predicates))).orderBy(ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.createTime.desc());
        return jpaQuery;
    }

    public JPAQuery<SalesmanSimpleInfoRespVO> findAllSalesmanCode(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanSimpleInfoRespVO.class, (Expression[])new Expression[]{ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo})).from((EntityPath)Q_SALESMAN_INFO_DO);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        ScpsmanInfoRepoProc.where(salesmanInfoQueryVO, predicates);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        salesmanInfoQueryVO.fillOrders(jpaQuery, Q_SALESMAN_INFO_DO);
        return jpaQuery;
    }

    public JPAQuery<SalesmanSimpleInfoRespVO> findAllSalesmanCode() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanSimpleInfoRespVO.class, (Expression[])new Expression[]{ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo})).from((EntityPath)Q_SALESMAN_INFO_DO);
        return jpaQuery;
    }

    public JPAQuery<SalesmanDetailInfoRespVO> findSalesmanInfoDetail(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanDetailInfoRespVO.class, (Expression[])new Expression[]{ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouName, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanType, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus})).from((EntityPath)Q_SALESMAN_INFO_DO);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        ScpsmanInfoRepoProc.where(salesmanInfoQueryVO, predicates);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        salesmanInfoQueryVO.fillOrders(jpaQuery, Q_SALESMAN_INFO_DO);
        salesmanInfoQueryVO.setPaging(jpaQuery);
        return jpaQuery;
    }

    public List<SalesmanInfoSimpleRespVO> simpleQuery(SalesmanInfoSimpleQueryVO param) {
        BooleanExpression expression = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (param.getEnableStatus() != null) {
            expression = ExpressionUtils.and((Predicate)expression, (Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus.eq((Object)param.getEnableStatus()));
        }
        if (CollUtil.isNotEmpty(param.getCodes())) {
            expression = ExpressionUtils.and((Predicate)expression, (Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.in(param.getCodes()));
        }
        if (CollUtil.isNotEmpty(param.getIds())) {
            expression = ExpressionUtils.and((Predicate)expression, (Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.id.in(param.getIds()));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanInfoSimpleRespVO.class, (Expression[])new Expression[]{ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanType})).from((EntityPath)Q_SALESMAN_INFO_DO)).where((Predicate)expression)).fetch();
    }

    public List<ScpsmanInfoDO> getSalesmanByCodes(Set<String> salesmanCodes) {
        BooleanExpression e = ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.in(salesmanCodes).and((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.deleteFlag.eq((Object)0));
        Iterable iterable = this.scpsmanInfoRepo.findAll((Predicate)e);
        if (IterUtil.isEmpty((Iterable)iterable)) {
            return new ArrayList<ScpsmanInfoDO>();
        }
        return Lists.newArrayList((Iterable)iterable);
    }

    public List<ScpsmanInfoDO> findSalesmanAllInfo(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        List scpsmanInfoDOS = ((JPAQuery)this.jpaQueryFactory.select((Expression)Q_SALESMAN_INFO_DO).from((EntityPath)Q_SALESMAN_INFO_DO)).fetch();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        ScpsmanInfoRepoProc.where(salesmanInfoQueryVO, predicates);
        return scpsmanInfoDOS;
    }

    private static void where(SalesmanInfoQueryVO salesmanInfoQueryVO, List<Predicate> predicates) {
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getScpsman())) {
            predicates.add((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.contains(salesmanInfoQueryVO.getScpsman()).or((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.name.contains(salesmanInfoQueryVO.getScpsman())));
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getOuCode())) {
            predicates.add((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouCode.eq((Object)salesmanInfoQueryVO.getOuCode()));
        }
        if (salesmanInfoQueryVO.getEnableStatus() != null) {
            predicates.add((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus.eq((Object)salesmanInfoQueryVO.getEnableStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getScpsmanType())) {
            predicates.add((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanType.eq((Object)salesmanInfoQueryVO.getScpsmanType()));
        }
        if (CollUtil.isNotEmpty(salesmanInfoQueryVO.getCodes())) {
            predicates.add((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.in(salesmanInfoQueryVO.getCodes()));
        }
        if (StrUtil.isNotBlank((CharSequence)salesmanInfoQueryVO.getLoginAccount())) {
            predicates.add((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.loginAccount.eq((Object)salesmanInfoQueryVO.getLoginAccount()));
        }
        if (StrUtil.isNotBlank((CharSequence)salesmanInfoQueryVO.getBusinessType())) {
            predicates.add((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.businessType.eq((Object)salesmanInfoQueryVO.getBusinessType()));
        }
        if (CollUtil.isNotEmpty(salesmanInfoQueryVO.getBusinessTypeList())) {
            List<String> businessTypes = salesmanInfoQueryVO.getBusinessTypeList();
            BooleanExpression condition = Expressions.asBoolean((boolean)false).isTrue();
            for (String type : businessTypes) {
                String pattern = "%," + type + ",%";
                BooleanExpression match = ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.businessType.startsWith(type + ",").or((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.businessType.endsWith("," + type)).or((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.businessType.eq((Object)type)).or((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.businessType.like(pattern));
                condition = condition.or((Predicate)match);
            }
            predicates.add((Predicate)condition);
        }
    }

    public void changeEnableStatus(Long id, Integer enableStatus) {
        this.jpaQueryFactory.update((EntityPath)Q_SALESMAN_INFO_DO).set(ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus, (Object)enableStatus).where(new Predicate[]{ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.id.eq((Object)id)}).execute();
    }

    public JPAQuery<SalesmanSuperiorRespVO> findByscpsmanType(SalesmanSuperiorQueryVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanSuperiorRespVO.class, (Expression[])new Expression[]{ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanType.as("type")})).from((EntityPath)Q_SALESMAN_INFO_DO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getUdc())) {
            predicates.add(ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanType.eq((Object)param.getUdc()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getScpsmanNo())) {
            String like = "%" + param.getScpsmanNo() + "%";
            predicates.add(ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.like(like));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, Q_SALESMAN_INFO_DO);
        return jpaQuery;
    }

    public JPAQuery<SalesmanInfoRespVO> findByRelateCode(List<String> codes, SalesmanInfoQueryVO salesmanInfoQueryVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanInfoRespVO.class, (Expression[])new Expression[]{ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanType, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouName, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouCode, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus})).from((EntityPath)Q_SALESMAN_INFO_DO)).where((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.in(codes));
        salesmanInfoQueryVO.fillOrders(jpaQuery, Q_SALESMAN_INFO_DO);
        salesmanInfoQueryVO.setPaging(jpaQuery);
        return jpaQuery;
    }

    public JPAQuery<SalesmanInfoRespVO> findByRelateCode(List<String> codes, SalesmanSubordinateQueryVO salesmanSubordinateQueryVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanInfoRespVO.class, (Expression[])new Expression[]{ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanType, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouName, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo, ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus})).from((EntityPath)Q_SALESMAN_INFO_DO)).where((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.in(codes));
        salesmanSubordinateQueryVO.fillOrders(jpaQuery, Q_SALESMAN_INFO_DO);
        salesmanSubordinateQueryVO.setPaging(jpaQuery);
        return jpaQuery;
    }

    public Long updateSalesmanInfo(SalesmanUpdateDTO salesmanUpdateDTO) {
        return this.jpaQueryFactory.update((EntityPath)Q_SALESMAN_INFO_DO).set((Path)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.fileCode, (Object)salesmanUpdateDTO.getFileCode()).where(new Predicate[]{ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.id.eq((Object)salesmanUpdateDTO.getSalesmanId())}).execute();
    }

    public List<ScpsmanInfoDO> getByIdByCodeOrNames(List<String> empCodes, List<String> names, List<String> salemans) {
        Iterable iterable;
        BooleanExpression expression = Q_SALESMAN_INFO_DO.isNotNull();
        if (CollUtil.isNotEmpty(salemans)) {
            expression = expression.and((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.in(salemans).or((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.name.in(salemans)));
        }
        if (CollUtil.isNotEmpty(empCodes)) {
            expression = expression.and((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.in(empCodes));
        }
        if (CollUtil.isNotEmpty(names)) {
            expression = expression.and((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.name.in(names));
        }
        if (!IterUtil.isEmpty((Iterable)(iterable = this.scpsmanInfoRepo.findAll((Predicate)expression)))) {
            return Lists.newArrayList((Iterable)iterable);
        }
        return new ArrayList<ScpsmanInfoDO>();
    }

    public List<ScpsmanInfoDO> getByIdByCodes(List<String> empCodes) {
        BooleanExpression expression = ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.in(empCodes);
        Iterable iterable = this.scpsmanInfoRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterable)) {
            return Lists.newArrayList((Iterable)iterable);
        }
        return new ArrayList<ScpsmanInfoDO>();
    }

    public List<ScpsmanInfoDO> getByIds(List<Long> ids) {
        BooleanExpression expression = ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.id.in(ids).and((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.deleteFlag.eq((Object)0));
        Iterable iterable = this.scpsmanInfoRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterable)) {
            return Lists.newArrayList((Iterable)iterable);
        }
        return new ArrayList<ScpsmanInfoDO>();
    }

    public Boolean existsSalesman(String code) {
        return super.exists((Path)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo, (Object)code);
    }

    public ScpsmanInfoDO getByCode(String code) {
        BooleanExpression e = ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.eq((Object)code).and((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.deleteFlag.eq((Object)0));
        Iterable optional = this.scpsmanInfoRepo.findAll((Predicate)e);
        if (IterUtil.isEmpty((Iterable)optional)) {
            return null;
        }
        return (ScpsmanInfoDO)((Object)Lists.newArrayList((Iterable)optional).get(0));
    }

    public Long getIdByCode(@NotBlank String code) {
        return super.getIdByValue((Path)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo, (Object)code);
    }

    public List<ScpsmanInfoDO> getByCodes(List<String> codes) {
        BooleanExpression e = ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.in(codes).and((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.deleteFlag.eq((Object)0));
        Iterable optional = this.scpsmanInfoRepo.findAll((Predicate)e);
        if (IterUtil.isEmpty((Iterable)optional)) {
            return null;
        }
        return Lists.newArrayList((Iterable)optional);
    }

    public List<ScpsmanInfoDO> getByLoginAccount(String loginAccount) {
        BooleanExpression expression = ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.loginAccount.in((Object[])new String[]{loginAccount}).and((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.deleteFlag.eq((Object)0));
        Iterable iterable = this.scpsmanInfoRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterable)) {
            return Lists.newArrayList((Iterable)iterable);
        }
        return new ArrayList<ScpsmanInfoDO>();
    }

    public List<ScpsmanInfoDO> getSalesmansContainsName(String agent) {
        BooleanExpression e = ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.scpsmanNo.contains(agent).or((Predicate)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.name.contains(agent));
        Iterable iterables = this.scpsmanInfoRepo.findAll((Predicate)e);
        if (IterUtil.isEmpty((Iterable)iterables)) {
            return null;
        }
        return Lists.newArrayList((Iterable)iterables);
    }

    public ScpsmanInfoDO getByScpsmanNo(String scpsmanNo) {
        return (ScpsmanInfoDO)((Object)super.getOneByValue((Path)ScpsmanInfoRepoProc.Q_SALESMAN_INFO_DO.loginAccount, (Object)scpsmanNo));
    }
}

