package com.elitesland.scp.application.facade.vo.param.order;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "订货订单查询参数")
@ToString(callSuper = true)
public class ScpDemandOrderAppCountParamVO implements Serializable {

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货单编码")
    private String docCode;

    @ApiModelProperty("单据状态")
    private String docStatus;

    @ApiModelProperty("单据状态集合")
    private List<String> docStatusList;

    @ApiModelProperty("门店编码/仓库编码")
    private String demandWhStCode;

    @ApiModelProperty("需求日期开始")
    private LocalDateTime demandDateFrom;

    @ApiModelProperty("需求日期结束")
    private LocalDateTime demandDateTo;

    @ApiModelProperty(name = "商品编码")
    private List<String> itemCodes;

    @ApiModelProperty("门店编码/仓库编码集合")
    private List<String> demandWhStCodes;

    @ApiModelProperty(name = "付款状态,待支付：WAIT_PAY，已付款：PAYED，无需支付：NO_PAY")
    private String payStatus;

    @ApiModelProperty(name = "单据类型")
    private String docType;

    @ApiModelProperty("付款状态集合")
    private List<String> payStatusList;

    @ApiModelProperty("单据类型集合")
    private List<String> docTypeList;

    @ApiModelProperty("是否评价，true：已评价，false：未评价")
    private Boolean replyFlag;

}
