package com.elitesland.scp.application.web.devops;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.Test;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;

public class TestController {

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    @Test
    public void testZhengxin() throws Exception {
        // 公钥内容
        var publicKeyStr ="-----BEGIN PUBLIC KEY-----\n" +
                "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqDKHcZ5JY6SuPRJ64rpz\n" +
                "d1LQshIFOzyQu6le+KzHrG4cmlGuwPUy/ZO0nfXsStpEUbh2cLgMrYosq+fI4aht\n" +
                "oGJxC4C2StTbPuo579hdzpI6vehc2Dt7PdTxKTek2qBX+mIMNEJ3q7pi65DI07Su\n" +
                "Qn2l69RRzGFQfKEo8EL7hZc4UDMq5KPlyLF4DThnjrI42mjcyuqNhNS+D4WDQ8ZF\n" +
                "2QuCy6MlHh/SpJNwthB8QPqfkBKnPrYv5/L+0L/DCxah6UK/ogrQNORTk/kh8cb9\n" +
                "aIdvtl3LBJ0oL5VrV/YzftIiCeN4AF8sxVEkRJdFafKBKzMEH2imPPC62hmO4vNU\n" +
                "KwIDAQAB\n" +
                "-----END PUBLIC KEY-----";
        // 待签名内容
        var plainText = "POS&POST&/api/pos/itmBrand/queryByCode&{\"brandCodes\":[\"POSTS\"]}&1723105582870&b54tb9DOfCAhbB5DXRZ8";
        // 签名
        var signatureText = "NuBjlhNSVif8IpU+qVOOMpOFEDx4bueNpOAKp+w81JO3rTGodpUoxxDnWv8QF0SCQljM6lVIdwhxjDnsGiDel69qvHg0szKAqb+fYO89cmLUUDLsC3iY5yVxQyIAbkolYvCYgsEGCIj0BXAfGycpE3W0kLW7F4tNsJAQNRZd/DB4ISJc1ESyEjE3PXc7ONhkZ15lMshg/N3OWiC+kZ8+SE/WH8WYq+ZIuK/jAK2Vjzznp2Ik4zvh1s+YTPVEauljtVYCMLTX8qayKeKb2xb3hHBz1LYhYw3N/pnPQdA7nDW92Tg4Jw6+N8nijwUwERzq1bnP1v1aM7RSkr1kXpH7uw==";
        // 签名算法
        var signatureAlgorithm = "SHA256withRSA";

        publicKeyStr = publicKeyStr.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").trim();
        byte[] publicKeyBytes = cn.hutool.core.codec.Base64.decode(publicKeyStr.getBytes(StandardCharsets.UTF_8));
        byte[] signatureTextBytes = cn.hutool.core.codec.Base64.decode(signatureText.getBytes(StandardCharsets.UTF_8));

        // 转换公钥
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);

        // 验签
        Signature signature = Signature.getInstance(signatureAlgorithm);
        signature.initVerify(publicKey);
        signature.update(plainText.getBytes(StandardCharsets.UTF_8));

        // 验证签名
        boolean verifyResult = signature.verify(signatureTextBytes);
        System.out.println("验签结果: " + verifyResult);
    }


//    @Test
//    public void testSignatureOriginal() throws Exception {
//
//        var privateKeyStr = "MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCoModxnkljpK49\n" +
//                "EnriunN3UtCyEgU7PJC7qV74rMesbhyaUa7A9TL9k7Sd9exK2kRRuHZwuAytiiyr\n" +
//                "58jhqG2gYnELgLZK1Ns+6jnv2F3Okjq96FzYO3s91PEpN6TaoFf6Ygw0QnerumLr\n" +
//                "kMjTtK5CfaXr1FHMYVB8oSjwQvuFlzhQMyrko+XIsXgNOGeOsjjaaNzK6o2E1L4P\n" +
//                "hYNDxkXZC4LLoyUeH9Kkk3C2EHxA+p+QEqc+ti/n8v7Qv8MLFqHpQr+iCtA05FOT\n" +
//                "+SHxxv1oh2+2XcsEnSgvlWtX9jN+0iIJ43gAXyzFUSREl0Vp8oErMwQfaKY88Lra\n" +
//                "GY7i81QrAgMBAAECggEAWwLsczhZMce8WGOVhvWo4Ro4vwItPn5pOoJNV3X2nYD/\n" +
//                "jSlBzDthmgDArPCTKXWtniKYRCnzAjxQK7zB4AkJOM3LqZO+EAPZltObAgMrz0kk\n" +
//                "6/m9s2uMJksBK3Jmi75TnLJNNEH7CztRp3GymYuc93GRxGgg0tyddrKlukwkWYY3\n" +
//                "Zc3LOLcj3A7jVko7OufgkaBl4UlcwY8YUJ6oKZ5zZbcocvTInC3PLTWxH0qazFP6\n" +
//                "7Fibp7Gthu7AwAsVkrMh15jSONugee4uf8qlybroU4jaUJtAbS+cMO7Rg+J0LgSw\n" +
//                "MpKnUx7i+R/bwsxP+y2LNxQyQPooXj3JcYMmyfgzsQKBgQDSgpxvO/tjwKnAUEfI\n" +
//                "JVAIPkblpUZOMKC30uA4lW6CY7Kqgx1y85o/M3z9c/t6Ol5cgxrfw5ITpikCd3LP\n" +
//                "PDz79o+yU7KVhoMAPoFkeL0dpZE5EW+GvFZGBwlgx6FtelfeHtkvNMai8QZGsN2W\n" +
//                "vOVOxUweZ/hllOWoOjyRXHrztwKBgQDMiy4M2roArDpe3RxjQTk3+hLd6WW3VLH3\n" +
//                "xae54WQhKOTVnIcr+PQAmZveiixEUX6gSfFiGGPYZN8NlQC8q78QYTBGIuMrugMv\n" +
//                "zVo/EMMruyggbZfRq5/a1ZuhjRyYRkeZ0Kfj48rapy6iA/6ePBtJFw9xq4J+Ep+V\n" +
//                "jZ+vOE9rLQKBgQCHd2Gv+0uVL+CNT5xB4jEUfO8mzSrnGkfyw5NjFladNgc9z05e\n" +
//                "MQFr9nhSqhaE25bptbzPjo0sc9skKTYKwlsEUfC68z2TF5Kpz4941nHs6CUCMoQw\n" +
//                "knZ6bgDM9OqfBwIQgI2G4VGKfcxqJVsTq89s125aitHAnQcFMSTU7kx5FQKBgQC3\n" +
//                "UUXEX4O0dqcZvjFjA2G0uXuPR07SMCYQWiUogsiqr2vnxpGe51BH+WOo300tLZy/\n" +
//                "K4Ya1KEnn8AI/DHc5lAm7fPF6B6RYfTZMsJfIzbISsR7y7z1PUvXZPpGn6GxF8u0\n" +
//                "Hz1ZER8NOCijK9FXH6eUqgY9aelZ9HbyIiurblw/QQKBgQC9PDYp/rx5WDlJsz3e\n" +
//                "rv/XN2Z4uvxJh0Xj5YfJBXDYjoeN94Mmftt29DR4jlCN3SkFLhgLkjonjb12bGr1\n" +
//                "nJLVOyiDhjEXpGeV4nkGjGSZaZ4IpfsD9KMQCvAW6Q7X6/78QhCE8TgrX/ml3hoL\n" +
//                "+lyshBrOANu6PDjP8GbXqTbGxQ==\n";
//
//        // 待签名内容
//        var plainText = "a=1&b=2";
//        // 签名算法
//        var signatureAlgorithm = "SHA256withRSA";
//
//        privateKeyStr = privateKeyStr.replace("-----BEGIN ENCRYPTED PRIVATE KEY-----", "").replace("-----END ENCRYPTED PRIVATE KEY-----", "").trim();
//        byte[] privateKeyBytes = cn.hutool.core.codec.Base64.decode(privateKeyStr.getBytes(StandardCharsets.UTF_8));
//
//        // 转换私钥
//        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
//        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
//        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
//
//        // 签名
//        Signature signature = Signature.getInstance(signatureAlgorithm);
//        signature.initSign(privateKey);
//        signature.update(plainText.getBytes(StandardCharsets.UTF_8));
//        var signatureBytes = signature.sign();
//
//        var signatureText = cn.hutool.core.codec.Base64.encode(signatureBytes);
//        System.out.println("签名结果: " + signatureText);
//    }
}
