package com.elitesland.scp.domain.entity.minOrder;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

@Entity
@Table(name = "scp_min_order_setting_item")
@org.hibernate.annotations.Table(appliesTo = "scp_min_order_setting_item", comment = "订货起订商品表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "订货起订商品表", description = "订货起订商品表")
@Where(clause = "delete_flag = 0")
public class ScpMinOrderSettingItemDO extends BaseModel implements Serializable {

    @ApiModelProperty("活动ID")
    @Comment("活动ID")
    @Column()
    private Long masId;

    @ApiModelProperty("商品ID")
    @Comment("商品ID")
    @Column()
    private Long itemId;

    @ApiModelProperty("商品编码")
    @Comment("商品编码")
    @Column()
    private String itemCode;

    @ApiModelProperty("商品名称")
    @Comment("商品名称")
    @Column()
    private String itemName;

    @ApiModelProperty("最小强配数量")
    @Comment("最小强配数量")
    @Column()
    private BigDecimal minNum;

    @ApiModelProperty("单位")
    @Comment("单位")
    @Column()
    private String uom;

    @ApiModelProperty("商品分类")
    @Comment("商品分类")
    @Column()
    private String itemType2;

}
