package com.elitesland.scp.domain.service.mrp;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDPlanRespVO;
import com.elitesland.scp.application.facade.vo.save.mrp.ScpMrpDPlanSaveVO;
import com.elitesland.scp.domain.convert.mrp.ScpMrpDPlanConvert;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDPlanDO;
import com.elitesland.scp.infr.repo.mrp.ScpMrpDPlanRepo;
import com.elitesland.scp.infr.repo.mrp.ScpMrpDPlanRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;

/**
 * @author chaofeng.xia
 * @since 2025/1/16
 */
@RequiredArgsConstructor
@Service
@Slf4j
public class ScpMrpDPlanDomainServiceImpl implements ScpMrpDPlanDomainService {

    private final ScpMrpDPlanRepo scpMrpDPlanRepo;

    private final ScpMrpDPlanRepoProc scpMrpDPlanRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasIds(List<Long> masIds) {
        scpMrpDPlanRepo.deleteByMasIds(masIds);
    }

    @Override
    public List<ScpMrpDPlanRespVO> findByMasIds(List<Long> masIds) {
        List<ScpMrpDPlanDO> scpMrpDPlanDOList = scpMrpDPlanRepo.findByMasIdIn(masIds);
        if (CollectionUtil.isEmpty(scpMrpDPlanDOList)) {
            return Collections.emptyList();
        }
        return ScpMrpDPlanConvert.INSTANCE.doToRespVO(scpMrpDPlanDOList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(List<ScpMrpDPlanSaveVO> saveVOList) {
        scpMrpDPlanRepo.saveAll(ScpMrpDPlanConvert.INSTANCE.saveVoToDo(saveVOList));
    }

    @Override
    @Transactional
    public List<ScpMrpDPlanDO> saveDO(List<ScpMrpDPlanDO> scpMrpDPlanDOList) {
        return scpMrpDPlanRepo.saveAll(scpMrpDPlanDOList);
    }

    @Override
    @Transactional
    public void updatePushStatus(List<Long> planIds, String pushStatus, String poNo, Long poDId, Integer poLineNo, String pushFailReason) {
        scpMrpDPlanRepoProc.updatePushStatus(planIds, pushStatus, poNo, poDId, poLineNo, pushFailReason);
    }

    @Override
    public List<ScpMrpDPlanRespVO> findByIds(List<Long> ids) {
        return scpMrpDPlanRepoProc.findByIds(ids);
    }

    @Override
    public List<ScpMrpDPlanRespVO> findByMrpId(Long mrpId) {
        return scpMrpDPlanRepoProc.findByMrpId(mrpId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpMrpDPlanRepo.deleteAllById(ids);
    }
}
