package com.elitesland.scp.infr.repo.purLimit;

import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingItemRespVO;
import com.elitesland.scp.domain.entity.purLimit.QScpPurLimitSettingDO;
import com.elitesland.scp.domain.entity.purLimit.QScpPurLimitSettingItemDO;
import com.elitesland.scp.domain.entity.purLimit.QScpPurLimitSettingStoreDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpPurLimitSettingItemRepoProc {
    private static final QScpPurLimitSettingStoreDO scpPurLimitSettingStoreDO = QScpPurLimitSettingStoreDO.scpPurLimitSettingStoreDO;
    private static final QScpPurLimitSettingDO scpPurLimitSettingDO = QScpPurLimitSettingDO.scpPurLimitSettingDO;
    private static final QScpPurLimitSettingItemDO scpPurLimitSettingItemDO = QScpPurLimitSettingItemDO.scpPurLimitSettingItemDO;
    private final JPAQueryFactory jpaQueryFactory;

    public List<ScpPurLimitSettingItemRespVO> getPurLimitSettingItemByStoreCode(String storeCode, String docType, List<String> itemType2s) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpPurLimitSettingItemRespVO.class,
                        scpPurLimitSettingItemDO.id,
                        scpPurLimitSettingItemDO.masId,
                        scpPurLimitSettingItemDO.itemId,
                        scpPurLimitSettingItemDO.itemCode,
                        scpPurLimitSettingItemDO.itemName,
                        scpPurLimitSettingItemDO.minNum,
                        scpPurLimitSettingItemDO.itemType2,
                        scpPurLimitSettingDO.activityCode
                )).from(scpPurLimitSettingDO)
                .leftJoin(scpPurLimitSettingItemDO).on(scpPurLimitSettingDO.id.eq(scpPurLimitSettingItemDO.masId))
                .leftJoin(scpPurLimitSettingStoreDO).on(scpPurLimitSettingStoreDO.masId.eq(scpPurLimitSettingDO.id));
        jpaQuery.where(scpPurLimitSettingStoreDO.storeCode.eq(storeCode));
        jpaQuery.where(scpPurLimitSettingItemDO.itemType2.in(itemType2s));
        jpaQuery.where(scpPurLimitSettingStoreDO.maxNum.gt(scpPurLimitSettingStoreDO.activeNum));
        jpaQuery.where(scpPurLimitSettingDO.docType.like("%" + docType + "%"));
        jpaQuery.where(scpPurLimitSettingDO.status.eq(Boolean.TRUE));
        LocalDateTime now = LocalDateTime.now();
        jpaQuery.where(scpPurLimitSettingDO.validFrom.loe(now).and(scpPurLimitSettingDO.validTo.goe(now)));
        return jpaQuery.fetch();
    }

    public List<Long> findMasIdByItemId(Long itemId) {
        var jpaQuery = jpaQueryFactory.select(scpPurLimitSettingItemDO.masId).distinct()
                .from(scpPurLimitSettingItemDO);
        jpaQuery.where(scpPurLimitSettingItemDO.itemId.eq(itemId));
        return jpaQuery.fetch();
    }

}
