package com.elitesland.scp.job.task;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.job.config.JobConstant;
import com.elitesland.scp.job.service.ScpDemandSetJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ScpDemandSetHandler {
    @Autowired
    private ScpDemandSetJobService scpDemandSetJobService;

    @XxlJob(JobConstant.SCP_DEMAND_SET_HANDLER)
    public ReturnT<String> scpDemandSetHandler(String param) {
        try {
            scpDemandSetJobService.autoCreateDemandSet();
        } catch (Exception e) {
            log.error("订货集定时任务执行失败：", e);
            throw new BusinessException("订货集定时任务执行失败:" + e.getMessage());
        }
        return ReturnT.SUCCESS;
    }
}
