package com.elitesland.scp.provider.authority;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.service.authority.InvWhAuthorityRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
@RestController
@RequiredArgsConstructor
@RequestMapping(ScpApplication.URI_PREFIX + InvWhAuthorityRpcService.PATH)
public class ScpmansAuthorityRpcServiceImpl implements InvWhAuthorityRpcService {

    private final ScpDemandAuthorityService scpDemandAuthorityService;

    /**
     * 获取当前登录账号对应的计划员权限所属仓库编码(启用)
     * @return
     */
    @Override
    public ApiResult<List<String>> getAuthorityData() {
        log.info("【getAuthorityData】获取当前登录账号对应的计划员权限所属仓库：{}");
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if(ObjectUtil.isEmpty(currentUserDTO)){
            throw new BusinessException("当前登录人查询异常");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setType(1L);
        scpManAuthorityParam.setEnableStatus(true);
        scpManAuthorityParam.setSize(Integer.MAX_VALUE);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        if(scpManAuthorityPageRespVOPagingVO.isEmpty()){
            return null;
        }
        List<ScpManAuthorityPageRespVO> records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List<String> whCodeList = records.stream().filter(t -> ObjectUtil.isNotNull(t.getStWhCode())).map(ScpManAuthorityPageRespVO::getStWhCode).collect(Collectors.toList());
        log.info("【getAuthorityData】获取当前登录账号对应的计划员权限所属仓库结果：{}",JSONUtil.toJsonStr(records));
        return ApiResult.ok(whCodeList);
    }

    /**
     * 获取当前登录账号对应的计划员权限所属仓库编码(启用)
     * @return
     */
    @Override
    public ApiResult<List<String>> findStoreAuthorityData() {
        log.info("【findStoreAuthorityData】获取当前登录账号对应的计划员权限所属门店：{}");
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if(ObjectUtil.isEmpty(currentUserDTO)){
            throw new BusinessException("当前登录人查询异常");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setType(0L);
        scpManAuthorityParam.setEnableStatus(true);
        List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOS = scpDemandAuthorityService.listQuery(scpManAuthorityParam);
        if(CollectionUtil.isEmpty(scpManAuthorityPageRespVOS)){
            return null;
        }
        List<String> whCodeList = scpManAuthorityPageRespVOS.stream().filter(t -> ObjectUtil.isNotNull(t.getStWhCode())).map(ScpManAuthorityPageRespVO::getStWhCode).collect(Collectors.toList());
        log.info("【findStoreAuthorityData】获取当前登录账号对应的计划员权限所属门店结果：{}",JSONUtil.toJsonStr(scpManAuthorityPageRespVOS));
        return ApiResult.ok(whCodeList);
    }

    @Override
    public ApiResult<List<Long>> getAuthorityDataIds() {
        log.info("【getAuthorityData】获取当前登录账号对应的计划员权限所属仓库：{}");
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if(ObjectUtil.isEmpty(currentUserDTO)){
            throw new BusinessException("当前登录人查询异常");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setType(1L);
        scpManAuthorityParam.setEnableStatus(true);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        if(scpManAuthorityPageRespVOPagingVO.isEmpty()){
            return null;
        }
        List<ScpManAuthorityPageRespVO> records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List<Long> collect = records.stream().filter(t -> ObjectUtil.isNotNull(t.getStWhId())).map(ScpManAuthorityPageRespVO::getStWhId).collect(Collectors.toList());
        log.info("【getAuthorityData】获取当前登录账号对应的计划员权限所属仓库结果：{}",JSONUtil.toJsonStr(collect));
        return ApiResult.ok(collect);
    }
}
