/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.devops;

import cn.hutool.core.codec.Base64;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.service.app.ScpCacheService;
import com.elitesland.scp.utils.SysUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8fd0\u7ef4\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/devops"}, produces={"application/json"})
public class DevopsController {
    private static final Logger log = LoggerFactory.getLogger(DevopsController.class);
    private final ScpCacheService scpCacheService;
    private final RedisTemplate redisTemplate;

    @GetMapping(value={"/clearCache"})
    @ApiOperation(value="\u5546\u54c1-\u6e05\u9664\u7f13\u5b58")
    public ApiResult<Map<String, Object>> clearCache() {
        log.info("[SCP-DEVOPS] clearCache  paramVO ={}");
        this.scpCacheService.deleteAllKeys();
        return ApiResult.ok();
    }

    @PostMapping(value={"/clearCacheByItem"})
    @ApiOperation(value="\u5546\u54c1-\u6e05\u9664\u7f13\u5b58-SPU\u7ea7\u522b")
    public ApiResult<Object> clearCacheByItem(@RequestBody List<Long> spuIds) {
        log.info("[SCP-DEVOPS] clearCacheByItem  paramVO ={}", (Object)JSONUtil.toJsonStr(spuIds));
        this.scpCacheService.deleteKeys(spuIds);
        return ApiResult.ok();
    }

    @GetMapping(value={"/clear/setting"})
    @ApiOperation(value="\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f-\u6e05\u9664\u7f13\u5b58")
    public ApiResult<Map<String, Object>> clearSysSetting() {
        log.info("[SCP-DEVOPS] clearSysSetting  paramVO ={}");
        SysUtils.refreshSetting();
        return ApiResult.ok();
    }

    @PostMapping(value={"/test"})
    public ApiResult<Map<String, Object>> payNotify() {
        log.info("[SCP-DEVOPS] clearSysSetting  paramVO ={}");
        SysUtils.refreshSetting();
        return ApiResult.ok();
    }

    @PostMapping(value={"/php/verify"})
    @ApiOperation(value="\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f-\u6e05\u9664\u7f13\u5b58")
    public ApiResult<Map<String, Object>> testVerify(@RequestBody Map<String, Object> paramVO) throws Exception {
        log.info("[SCP-DEVOPS] test  paramVO ={}", (Object)JSONUtil.toJsonStr(paramVO));
        String publicKeyStr = "-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqDKHcZ5JY6SuPRJ64rpz\nd1LQshIFOzyQu6le+KzHrG4cmlGuwPUy/ZO0nfXsStpEUbh2cLgMrYosq+fI4aht\noGJxC4C2StTbPuo579hdzpI6vehc2Dt7PdTxKTek2qBX+mIMNEJ3q7pi65DI07Su\nQn2l69RRzGFQfKEo8EL7hZc4UDMq5KPlyLF4DThnjrI42mjcyuqNhNS+D4WDQ8ZF\n2QuCy6MlHh/SpJNwthB8QPqfkBKnPrYv5/L+0L/DCxah6UK/ogrQNORTk/kh8cb9\naIdvtl3LBJ0oL5VrV/YzftIiCeN4AF8sxVEkRJdFafKBKzMEH2imPPC62hmO4vNU\nKwIDAQAB\n-----END PUBLIC KEY-----";
        StringJoiner joiner = new StringJoiner("&");
        joiner.add("POS");
        joiner.add("POST");
        joiner.add("/api/pos/itmBrand/queryByCode");
        joiner.add(JSONUtil.toJsonStr(paramVO));
        joiner.add("1723105582870");
        joiner.add("b54tb9DOfCAhbB5DXRZ8");
        String plainText = joiner.toString();
        String signatureText = "TQdr61wfyVTdOAV6RYoiEg6/qkEjLAtXrns2GiShdpVawbFq49T8s23+5jq9yxjqydSz4yKUKMzO4xEhVjNPvIB1LvxHsVHCtHPAuAaTuiorJiPTFXE8XG2TGvR3Psr3aOJTf7jd2X/ziyKctU96xHqnm6eOSbwJx8dxcHwHT+/hsZyGmCqe0j0L34TIwDUJxjtIXHE/3RpqQbTHygFkJSu9rWMo0Pk8fb9LjCWkoTkVWTeRYdKBMZ9/dSfyMLPFaOJFj3lUrA4GNXgE1KptEMwKwS2YorTDwO+FVdhwam5iY8z2c1xVW8ZaWdO1vpq8Fis978p8skd9bXzGlRoYig==";
        String signatureAlgorithm = "SHA256withRSA";
        publicKeyStr = publicKeyStr.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").trim();
        byte[] publicKeyBytes = Base64.decode((byte[])publicKeyStr.getBytes(StandardCharsets.UTF_8));
        byte[] signatureTextBytes = Base64.decode((byte[])signatureText.getBytes(StandardCharsets.UTF_8));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(signatureAlgorithm);
        signature.initVerify(publicKey);
        signature.update(plainText.getBytes(StandardCharsets.UTF_8));
        boolean verifyResult = signature.verify(signatureTextBytes);
        System.out.println("\u9a8c\u7b7e\u7ed3\u679c: " + verifyResult);
        return ApiResult.ok();
    }

    @GetMapping(value={"/clearSpecCache"})
    @ApiOperation(value="redis-\u6e05\u9664\u6307\u5b9a\u7f13\u5b58")
    public ApiResult<Map<String, Object>> clearSpecCache(String spec) {
        log.info("[SCP-DEVOPS] clearSpecCache  paramVO ={}");
        this.scpCacheService.deleteSpecKeys(spec);
        return ApiResult.ok();
    }

    @GetMapping(value={"/getKey/{key}"})
    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7684redisKey")
    public ApiResult<Object> getKey(@PathVariable String key) {
        Object o = this.redisTemplate.opsForValue().get((Object)key);
        log.info("key:{} value:{}", (Object)key, (Object)JSONUtil.toJsonStr((Object)o));
        return ApiResult.ok((Object)o);
    }

    public DevopsController(ScpCacheService scpCacheService, RedisTemplate redisTemplate) {
        this.scpCacheService = scpCacheService;
        this.redisTemplate = redisTemplate;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

