/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.boh.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.application.facade.vo.boh.StoreAppletHomeVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveTotalVO;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnTotalVO;
import com.elitesland.scp.application.facade.vo.boh.StoreTodoVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderListParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderListRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.boh.StoreAppletService;
import com.elitesland.scp.application.service.template.DemandOrderTemplateService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepo;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class StoreAppletServiceImpl
implements StoreAppletService {
    private static final Logger log = LoggerFactory.getLogger(StoreAppletServiceImpl.class);
    @Autowired
    @Qualifier(value="cloudt_taskExecutor")
    private TaskExecutor taskExecutor;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final ItmItemRpcService itmItemRpcService;
    private final DemandOrderTemplateService demandOrderTemplateService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpStoreDemandCalendarRepo scpStoreDemandCalendarRepo;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    @Autowired
    private ScpStoreDemandCalendarRepoProc scpStoreDemandCalendarRepoProc;
    private final RmiSysUDCService rmiSysUDCService;

    @Override
    public StoreAppletHomeVO find(Long storeId, LocalDateTime startDate, String demandWhStCode, String type) {
        StoreAppletHomeVO storeAppletHomeVO = new StoreAppletHomeVO();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        ScpsmanInfoDO byLoginAccount = this.scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
        log.info("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7:{}", (Object)JSONUtil.toJsonStr((Object)((Object)byLoginAccount)));
        if (byLoginAccount == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7\u67e5\u8be2\u5f02\u5e38");
        }
        String scpManType = byLoginAccount.getScpsmanType();
        String invisibleAccount = SysUtils.getInvisibleAccount();
        List invisibleAccountList = Arrays.stream(invisibleAccount.split(",")).collect(Collectors.toList());
        log.info("\u9650\u5236\u8d26\u53f7\u7c7b\u578b:{}", (Object)JSONUtil.toJsonStr(invisibleAccountList));
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
            storeAppletHomeVO.setReceiveCount(this.storeReceiveRepoProc.findReceive(storeId, startDate));
            storeAppletHomeVO.setReplyCount(this.scpDemandOrderRepoProc.countUnReply(storeId, startDate));
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
            storeAppletHomeVO.setRtnCount(this.storeReceiveRepoProc.findRtn(storeId, startDate));
            storeAppletHomeVO.setOrderCount(this.storeReceiveRepoProc.findOrderCount(storeId, startDate));
            if (invisibleAccountList.contains(scpManType)) {
                Optional<ScpStoreDemandCalendarDO> scpStoreDemandCalendarDO;
                OrgStoreDetailRpcDTO orgStore;
                String region;
                Map<String, String> itemType2 = this.rmiSysUDCService.getCodeMap("yst-supp", "ITEM_TYPE2");
                ArrayList<String> allDeliveryType = new ArrayList<String>(itemType2.keySet());
                String year = String.valueOf(LocalDateTime.now().getYear());
                String month = String.format("%02d", LocalDateTime.now().getMonthValue());
                String day = String.valueOf(LocalDateTime.now().getDayOfMonth());
                List<ScpStoreDemandCalendarDO> calendarList = this.scpStoreDemandCalendarRepoProc.findByUniqueKeys(allDeliveryType, "STORE", demandWhStCode, year, month, day);
                ArrayList<String> regionDeliveryType = new ArrayList<String>();
                ArrayList<ScpStoreDemandCalendarDO> calendarResultList = new ArrayList<ScpStoreDemandCalendarDO>();
                if (calendarList != null && !calendarList.isEmpty()) {
                    calendarList.forEach(calendar -> {
                        if (!allDeliveryType.contains(calendar.getDeliveryType())) {
                            regionDeliveryType.add(calendar.getDeliveryType());
                        }
                        calendarResultList.add((ScpStoreDemandCalendarDO)calendar);
                    });
                }
                if (CollectionUtil.isNotEmpty(regionDeliveryType) && StrUtil.isNotBlank((CharSequence)(region = (orgStore = Optional.ofNullable(this.orgStoreRpcService.get(storeId)).orElseThrow(() -> new BusinessException("\u95e8\u5e97\u4e0d\u5b58\u5728"))).getRegion()))) {
                    List<ScpStoreDemandCalendarDO> regionList = this.scpStoreDemandCalendarRepoProc.findByUniqueKeys(regionDeliveryType, "REGION", region, year, month, day);
                    calendarResultList.addAll(regionList);
                }
                storeAppletHomeVO.setOrderCalendar("W");
                if (CollectionUtil.isNotEmpty(calendarResultList) && (scpStoreDemandCalendarDO = calendarResultList.stream().filter(calendar -> calendar.getWorkStatus().equals("W")).findAny()).isEmpty()) {
                    storeAppletHomeVO.setOrderCalendar("E");
                }
            } else {
                storeAppletHomeVO.setOrderCalendar("W");
            }
        }, (Executor)this.taskExecutor);
        CompletableFuture.allOf(future1, future2).join();
        return storeAppletHomeVO;
    }

    private int templateCount(String demandWhStCode, String type) {
        DemandOrderListParamVO vo = new DemandOrderListParamVO();
        vo.setDemandWhStCode(demandWhStCode);
        vo.setType(type);
        List<DemandOrderListRespVO> list = this.demandOrderTemplateService.list(vo);
        if (CollUtil.isEmpty(list)) {
            return 0;
        }
        return list.size();
    }

    @Override
    public StoreTodoVO todo(StoreReceivePageParam param) {
        List<Long> docIds = this.findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreTodoVO();
        }
        return this.storeReceiveRepoProc.findTodo(param);
    }

    private List<Long> findDocIds(StoreReceivePageParam param) {
        if (StrUtil.isNotBlank((CharSequence)param.getItemName()) || StrUtil.isNotBlank((CharSequence)param.getItemCode()) || StrUtil.isNotBlank((CharSequence)param.getItemKeyword())) {
            List itemIdByCodeName = this.itmItemRpcService.findItemIdByCodeName(param.getItemCode(), param.getItemName(), param.getItemKeyword());
            if (CollectionUtil.isEmpty((Collection)itemIdByCodeName)) {
                return new ArrayList<Long>();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdByCodeName);
            } else {
                param.getItemIds().retainAll(itemIdByCodeName);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new ArrayList<Long>();
            }
        }
        if (CollectionUtil.isNotEmpty(param.getCateIds())) {
            List allLeafCateId = this.itmItemRpcService.findAllLeafCateId(param.getCateIds());
            param.setCateIds(allLeafCateId);
            List<Long> itemIdsByCate = this.storeReceiveRepoProc.findItemIdsByCate(allLeafCateId);
            if (CollectionUtil.isEmpty(itemIdsByCate)) {
                return new ArrayList<Long>();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdsByCate);
            } else {
                param.getItemIds().retainAll(itemIdsByCate);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new ArrayList<Long>();
            }
        }
        if (CollectionUtil.isNotEmpty(param.getItemIds())) {
            List<Long> docId = this.storeReceiveRepoProc.findDocId(param.getItemIds());
            if (CollectionUtil.isEmpty(docId)) {
                return new ArrayList<Long>();
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                param.setIds(docId);
            } else {
                param.getIds().retainAll(docId);
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                return new ArrayList<Long>();
            }
            return param.getIds();
        }
        return null;
    }

    @Override
    public StoreReceiveTotalVO receiveTotal(StoreReceivePageParam param) {
        List<Long> docIds = this.findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreReceiveTotalVO();
        }
        return this.storeReceiveRepoProc.findReceiveTotal(param);
    }

    @Override
    public StoreRtnTotalVO rtnCount(StoreReceivePageParam param) {
        List<Long> docIds = this.findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreRtnTotalVO();
        }
        return this.storeReceiveRepoProc.findRtnTotal(param);
    }

    public StoreAppletServiceImpl(StoreReceiveRepoProc storeReceiveRepoProc, ItmItemRpcService itmItemRpcService, DemandOrderTemplateService demandOrderTemplateService, ScpDemandOrderRepoProc scpDemandOrderRepoProc, ScpStoreDemandCalendarRepo scpStoreDemandCalendarRepo, OrgStoreRpcService orgStoreRpcService, ScpsmanInfoRepo scpsmanInfoRepo, RmiSysUDCService rmiSysUDCService) {
        this.storeReceiveRepoProc = storeReceiveRepoProc;
        this.itmItemRpcService = itmItemRpcService;
        this.demandOrderTemplateService = demandOrderTemplateService;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
        this.scpStoreDemandCalendarRepo = scpStoreDemandCalendarRepo;
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpsmanInfoRepo = scpsmanInfoRepo;
        this.rmiSysUDCService = rmiSysUDCService;
    }
}

