/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.serviceconfig;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigExportRespVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigImportVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigPageParamVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigPageVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigSaveVO;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.scp.domain.convert.serviceconifg.ScpServiceConfigConvert;
import com.elitesland.scp.domain.entity.serviceconfig.ScpServiceConfigDO;
import com.elitesland.scp.domain.service.serviceconfig.ScpServiceConfigDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.serviceconfig.ScpServiceConfigRepo;
import com.elitesland.scp.infr.repo.serviceconfig.ScpServiceConfigRepoProc;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.scp.rmi.RmiOrgRegionRpcService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgRegionDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpServiceConfigServiceImpl
implements ScpServiceConfigService {
    private static final Logger log = LoggerFactory.getLogger(ScpServiceConfigServiceImpl.class);
    private final ScpServiceConfigDomainService scpServiceConfigDomainService;
    private final UdcProvider udcProvider;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiOrgRegionRpcService rmiOrgRegionRpcService;
    private final ScpServiceConfigRepo scpServiceConfigRepo;
    private final ScpServiceConfigRepoProc scpServiceConfigRepoProc;
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";

    @Override
    @SysCodeProc
    public PagingVO<ScpServiceConfigPageVO> page(ScpServiceConfigPageParamVO queryParam) {
        PagingVO<ScpServiceConfigPageVO> pagingVO = this.scpServiceConfigDomainService.page(queryParam);
        if (pagingVO.isNotEmpty()) {
            Map storeLevelMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "STORE_LEVEL");
            pagingVO.getRecords().forEach(scpServiceConfig -> {
                if (StringUtils.isNotEmpty((String)scpServiceConfig.getStoreLevel())) {
                    String storeLevelName = Stream.of(scpServiceConfig.getStoreLevel().split(",")).map(storeLevelMap::get).collect(Collectors.joining(","));
                    scpServiceConfig.setStoreLevelName(storeLevelName);
                }
            });
        }
        return pagingVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createServiceConfig(List<ScpServiceConfigSaveVO> createParams) {
        if (CollectionUtils.isEmpty(createParams)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ScpServiceConfigDO> createList = ScpServiceConfigConvert.INSTANCE.saveVoDO(createParams);
        List<String> businessKeys = createList.stream().map(c -> {
            c.setBusinessKey(c.getFeeType() + "_" + c.getType() + "_" + c.getRegionStoreCode());
            return c.getBusinessKey();
        }).distinct().collect(Collectors.toList());
        List<ScpServiceConfigDO> existList = this.scpServiceConfigDomainService.findByBusinessKey(businessKeys);
        if (CollectionUtils.isNotEmpty(existList)) {
            existList.addAll(createList);
            this.checkEqual(existList);
        }
        this.scpServiceConfigRepo.saveAll(createList);
    }

    public void checkEqual(List<ScpServiceConfigDO> existList) {
        Map<String, List<ScpServiceConfigDO>> configMap = existList.stream().collect(Collectors.groupingBy(c -> c.getFeeType() + "_" + c.getType() + "_" + c.getRegionStoreId()));
        configMap.forEach((businessKey, list) -> {
            ArrayList storeLevelList = new ArrayList();
            list.forEach(d -> storeLevelList.addAll(d.getStoreLevels()));
            List repeatStoreLevels = storeLevelList.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(repeatStoreLevels)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, String.format("\u6570\u636e\u91cd\u590d\uff0c\u8d39\u7528\u5f52\u5c5e\u7c7b\u578b-\u533a\u57df\u7f16\u7801/\u95e8\u5e97\u7f16\u7801\u3010%s-%s\u3011\u914d\u7f6e\u91cd\u590d\u6216\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", ((ScpServiceConfigDO)list.get(0)).getFeeType(), ((ScpServiceConfigDO)list.get(0)).getRegionStoreCode()));
            }
        });
    }

    @Override
    @Transactional
    public void modifyServiceConfig(ScpServiceConfigSaveVO createParam) {
        if (createParam.getId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u9879\u76ee\u670d\u52a1\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ScpServiceConfigDO scpServiceConfigDO = ScpServiceConfigConvert.INSTANCE.saveVoDO(createParam);
        scpServiceConfigDO.setBusinessKey(scpServiceConfigDO.getFeeType() + "_" + scpServiceConfigDO.getType() + "_" + scpServiceConfigDO.getRegionStoreCode());
        List<ScpServiceConfigDO> existList = this.scpServiceConfigRepo.findByBusinessKeyAndIdNot(createParam.getBusinessKey(), createParam.getId());
        if (CollUtil.isNotEmpty(existList)) {
            existList.add(scpServiceConfigDO);
            this.checkEqual(existList);
        }
        this.scpServiceConfigRepo.save(scpServiceConfigDO);
    }

    @Override
    @SysCodeProc
    public ScpServiceConfigRespVO findDetailById(Long id) {
        if (id == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ScpServiceConfigRespVO serviceConfigRespVO = this.scpServiceConfigDomainService.findById(id);
        if (serviceConfigRespVO == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u9879\u76ee\u670d\u52a1\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        Map storeLevelMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "STORE_LEVEL");
        String storeLevelName = Stream.of(serviceConfigRespVO.getStoreLevel().split(",")).map(storeLevelMap::get).collect(Collectors.joining(","));
        serviceConfigRespVO.setStoreLevelName(storeLevelName);
        return serviceConfigRespVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteServiceConfig(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.scpServiceConfigDomainService.deleteBatch(ids);
    }

    @Override
    public PagingVO<ScpServiceConfigExportRespVO> exportSearch(ScpServiceConfigPageParamVO queryParam) {
        PagingVO<ScpServiceConfigExportRespVO> exportResult = this.scpServiceConfigDomainService.exportSearch(queryParam);
        if (exportResult != null && exportResult.isNotEmpty()) {
            Map storeLevelMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "STORE_LEVEL");
            Map feeTypeMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", "SC_FEE_TYPE");
            Map configTypeMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", "SERVICE_CONFIG_TYPE");
            exportResult.getRecords().forEach(sc -> {
                sc.setFeeType((String)feeTypeMap.get(sc.getFeeType()));
                sc.setTypeName((String)configTypeMap.get(sc.getType()));
                sc.setFeePercentageStr(sc.getFeePercentage().stripTrailingZeros().toPlainString() + "%");
                String storeLevelName = Stream.of(sc.getStoreLevel().split(",")).map(storeLevelMap::get).collect(Collectors.joining(","));
                sc.setStoreLevelName(storeLevelName);
            });
        }
        return exportResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> executeImport(List<ScpServiceConfigImportVO> dataList, int rowIdx) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<String> errorResult = new ArrayList<String>();
        boolean errorFlag = false;
        Map<String, String> feeTypeMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", "SC_FEE_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, String> configTypeMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", "SERVICE_CONFIG_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, String> storeLevelMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "STORE_LEVEL").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        List<String> ouCodes = dataList.stream().map(ScpServiceConfigImportVO::getOuCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        List<String> storeCodes = dataList.stream().filter(sc -> ScpUdcEnum.SERVICE_CONFIG_TYPE_STORE.getValueCodeName().equals(sc.getTypeName()) && StringUtils.isNotBlank((String)sc.getRegionStoreCode())).map(ScpServiceConfigImportVO::getRegionStoreCode).distinct().collect(Collectors.toList());
        List<String> regionCodes = dataList.stream().filter(sc -> ScpUdcEnum.SERVICE_CONFIG_TYPE_REGION.getValueCodeName().equals(sc.getTypeName()) && StringUtils.isNotBlank((String)sc.getRegionStoreCode())).map(ScpServiceConfigImportVO::getRegionStoreCode).distinct().collect(Collectors.toList());
        Map<String, OrgStoreBaseRpcDTO> storeMap = this.rmiOrgStoreRpcService.getOrgStoreBaseMap(storeCodes);
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuService.findOuDtoMapByOuCodes(ouCodes);
        Map<String, OrgRegionDTO> regionMap = this.rmiOrgRegionRpcService.findRegionMapByCodes(regionCodes);
        for (ScpServiceConfigImportVO sc2 : dataList) {
            ArrayList<String> errorList = new ArrayList<String>();
            if (StringUtils.isBlank((String)sc2.getFeeTypeName())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u8d39\u7528\u5f52\u5c5e\u7c7b\u578b", "\u8d39\u7528\u5f52\u5c5e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (!feeTypeMap.containsKey(sc2.getFeeTypeName())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u8d39\u7528\u5f52\u5c5e\u7c7b\u578b", "\u8d39\u7528\u5f52\u5c5e\u7c7b\u578b\u4e0d\u5b58\u5728"));
            } else {
                sc2.setFeeType(feeTypeMap.get(sc2.getFeeTypeName()));
            }
            if (StringUtils.isBlank((String)sc2.getOuCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u8d39\u7528\u5f52\u5c5e\u516c\u53f8\u7f16\u7801", "\u8d39\u7528\u5f52\u5c5e\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (!ouMap.containsKey(sc2.getOuCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u8d39\u7528\u5f52\u5c5e\u516c\u53f8\u7f16\u7801", "\u8d39\u7528\u5f52\u5c5e\u516c\u53f8\u7f16\u7801\u4e0d\u5b58\u5728"));
            } else {
                OrgOuRpcSimpleDTO ouDTO = ouMap.get(sc2.getOuCode());
                sc2.setOuId(ouDTO.getId());
                sc2.setOuName(ouDTO.getOuName());
            }
            if (StringUtils.isBlank((String)sc2.getTypeName())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u7c7b\u578b", "\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (!configTypeMap.containsKey(sc2.getTypeName())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u7c7b\u578b", "\u7c7b\u578b\u4e0d\u5b58\u5728"));
            } else {
                sc2.setType(configTypeMap.get(sc2.getTypeName()));
                if (ScpUdcEnum.SERVICE_CONFIG_TYPE_STORE.getValueCode().equals(sc2.getType())) {
                    if (StringUtils.isBlank((String)sc2.getRegionStoreCode())) {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u95e8\u5e97\u7f16\u7801", "\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    } else if (!storeMap.containsKey(sc2.getRegionStoreCode())) {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u95e8\u5e97\u7f16\u7801", "\u95e8\u5e97\u7f16\u7801\u4e0d\u5b58\u5728"));
                    } else {
                        OrgStoreBaseRpcDTO storeDTO = storeMap.get(sc2.getRegionStoreCode());
                        sc2.setRegionStoreId(storeDTO.getId());
                        sc2.setRegionStoreName(storeDTO.getStoreName());
                        sc2.setStoreLevel(storeDTO.getStoreLevel());
                    }
                } else if (StringUtils.isBlank((String)sc2.getRegionStoreCode())) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u533a\u57df\u7f16\u7801", "\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                } else if (!regionMap.containsKey(sc2.getRegionStoreCode())) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u533a\u57df\u7f16\u7801", "\u533a\u57df\u7f16\u7801\u4e0d\u5b58\u5728"));
                } else {
                    OrgRegionDTO regionDTO = regionMap.get(sc2.getRegionStoreCode());
                    sc2.setRegionStoreId(regionDTO.getId());
                    sc2.setRegionStoreName(regionDTO.getRegionName());
                    if (StringUtils.isBlank((String)sc2.getStoreLevelName())) {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u9002\u7528\u95e8\u5e97\u7b49\u7ea7", "\u7c7b\u578b\u4e3a\u533a\u57df\u9002\u7528\u95e8\u5e97\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a"));
                    }
                    sc2.setStoreLevel(Stream.of(sc2.getStoreLevelName().split(",")).map(storeLevelMap::get).collect(Collectors.joining(",")));
                }
            }
            if (sc2.getFeePercentageStr() == null || sc2.getFeePercentageStr().compareTo(BigDecimal.ZERO) <= 0) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowIdx, "\u8d39\u7528\u6bd4\u4f8b", "\u8d39\u7528\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u9700\u8981\u5927\u4e8e0"));
            }
            if (CollectionUtil.isNotEmpty(errorList)) {
                errorFlag = true;
                errorResult.add(StringUtils.join(errorList, (String)"\n"));
            } else {
                sc2.setBusinessKey(sc2.getFeeType() + "_" + sc2.getType() + "_" + sc2.getRegionStoreCode());
                errorResult.add(null);
            }
            ++rowIdx;
        }
        if (!errorFlag) {
            List<ScpServiceConfigDO> serviceConfigDOList = dataList.stream().map(entry -> {
                ScpServiceConfigDO scpServiceConfigDO = ScpServiceConfigConvert.INSTANCE.importToDO((ScpServiceConfigImportVO)entry);
                if (entry.getFeePercentageStr() != null) {
                    scpServiceConfigDO.setFeePercentage(entry.getFeePercentageStr().multiply(BigDecimal.valueOf(100L)));
                }
                return scpServiceConfigDO;
            }).collect(Collectors.toList());
            this.checkEqual(serviceConfigDOList);
            this.scpServiceConfigRepo.saveAll(serviceConfigDOList);
        }
        return CollectionUtils.isEmpty(errorResult) ? null : errorResult;
    }

    @Override
    public Map<String, ScpServiceConfigRespVO> findServiceConfigGroupByStore(String storeCode, String regionCode, String level) {
        Map feeTypeMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", "SC_FEE_TYPE");
        Set freeTypes = feeTypeMap.keySet();
        log.info("\u95e8\u5e97\u7f16\u7801\u3010{}\u3011\u533a\u57df\u7f16\u7801\u3010{}\u3011\u9002\u7528\u95e8\u5e97\u7b49\u7ea7\u3010{}\u3011\u8d39\u7528\u7c7b\u578b \u3010{}\u3011", new Object[]{storeCode, regionCode, level, JSON.toJSONString(freeTypes)});
        List<ScpServiceConfigRespVO> byStoreCode = this.scpServiceConfigRepoProc.findByStoreCode(storeCode);
        if (CollectionUtils.isEmpty(byStoreCode)) {
            List<ScpServiceConfigRespVO> byRegionCode = this.scpServiceConfigRepoProc.findByRegionCode(regionCode, level);
            if (CollectionUtils.isEmpty(byRegionCode)) {
                return null;
            }
            return byRegionCode.stream().collect(Collectors.toMap(ScpServiceConfigRespVO::getFeeType, v -> v, (t1, t2) -> t1));
        }
        List<String> existfeeTypes = byStoreCode.stream().map(ScpServiceConfigRespVO::getFeeType).filter(Objects::nonNull).distinct().toList();
        List<String> nonFeeTyoes = freeTypes.stream().filter(d -> !existfeeTypes.contains(d)).collect(Collectors.toList());
        log.info("\u95e8\u5e97\u7f16\u7801\u3010{}\u3011\u5b58\u5728\u975e\u514d\u8d39\u7c7b\u578b\u3010{}\u3011\uff0c\u8bf7\u68c0\u67e5", (Object)storeCode, nonFeeTyoes);
        if (CollectionUtils.isNotEmpty(nonFeeTyoes)) {
            log.info("\u95e8\u5e97\u7f16\u7801\u3010{}\u3011\u5b58\u5728\u975e\u514d\u8d39\u7c7b\u578b\u3010{}\u3011\uff0c\u8bf7\u68c0\u67e5", (Object)storeCode, nonFeeTyoes);
            List<ScpServiceConfigRespVO> byRegionCode = this.scpServiceConfigRepoProc.findByRegionCode2(regionCode, level, nonFeeTyoes);
            if (CollectionUtils.isNotEmpty(byRegionCode)) {
                byStoreCode.addAll(byRegionCode);
                return byStoreCode.stream().collect(Collectors.toMap(ScpServiceConfigRespVO::getFeeType, v -> v, (t1, t2) -> t1));
            }
            return byStoreCode.stream().collect(Collectors.toMap(ScpServiceConfigRespVO::getFeeType, t -> t, (t1, t2) -> t1));
        }
        return byStoreCode.stream().collect(Collectors.toMap(ScpServiceConfigRespVO::getFeeType, t -> t, (t1, t2) -> t1));
    }

    @Override
    public Map<String, ScpServiceConfigRespVO> checkServiceConfig(String storeCode, String regionCode, String level) {
        Map<String, ScpServiceConfigRespVO> configRespVOMap = this.findServiceConfigGroupByStore(storeCode, regionCode, level);
        log.info("configRespVOMap:{}", (Object)JSONUtil.toJsonStr(configRespVOMap));
        if (CollUtil.isEmpty(configRespVOMap)) {
            log.error("\u95e8\u5e97\u4fe1\u606f\u672a\u5b8c\u5584,\u672a\u627e\u5230\u95e8\u5e97\u5bf9\u5e94\u7684\u9879\u76ee\u670d\u52a1\u914d\u7f6e");
            throw new BusinessException(ApiCode.FAIL, "\u95e8\u5e97\u4fe1\u606f\u672a\u5b8c\u5584");
        }
        return configRespVOMap;
    }

    public ScpServiceConfigServiceImpl(ScpServiceConfigDomainService scpServiceConfigDomainService, UdcProvider udcProvider, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiOrgOuService rmiOrgOuService, RmiOrgRegionRpcService rmiOrgRegionRpcService, ScpServiceConfigRepo scpServiceConfigRepo, ScpServiceConfigRepoProc scpServiceConfigRepoProc) {
        this.scpServiceConfigDomainService = scpServiceConfigDomainService;
        this.udcProvider = udcProvider;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.rmiOrgRegionRpcService = rmiOrgRegionRpcService;
        this.scpServiceConfigRepo = scpServiceConfigRepo;
        this.scpServiceConfigRepoProc = scpServiceConfigRepoProc;
    }
}

