/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.authority;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthoritySaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityManager;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepoProc;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpDemandAuthprityServiceImpl
implements ScpDemandAuthorityService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandAuthprityServiceImpl.class);
    private final ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc;
    private final ScpDemandAuthorityRepo scpDemandAuthorityRepo;
    private final ScpDemandAuthorityManager scpDemandAuthorityManager;

    @Override
    @SysCodeProc
    public PagingVO<ScpManAuthorityPageRespVO> queryAuthorit(ScpManAuthorityParam paramVO) {
        long count = this.scpDemandAuthorityRepoProc.countDemandSet(paramVO);
        if (count > 0L) {
            List<ScpManAuthorityPageRespVO> franchisees = this.scpDemandAuthorityRepoProc.queryPageDemandAuthority(paramVO);
            this.scpDemandAuthorityManager.convertRegionName(franchisees, t -> ScpUdcEnum.SCPSMAN_AUTHORITY_TYPE_1.getValueCode().equals("" + t.getType()), ScpManAuthorityPageRespVO::getRegion, ScpManAuthorityPageRespVO::setRegionName);
            return PagingVO.builder().total(count).records(franchisees).build();
        }
        return new PagingVO();
    }

    @Override
    public PagingVO<ScpManAuthorityPageRespVO> getCurrentUserAuthority() {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setTypes(List.of(Integer.valueOf(1), Integer.valueOf(0)));
        scpManAuthorityParam.setEnableStatus(Boolean.TRUE);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.queryAuthorit(scpManAuthorityParam);
        return scpManAuthorityPageRespVOPagingVO;
    }

    @Override
    public void changeStatus(List<Long> ids, Boolean status) {
        this.scpDemandAuthorityRepoProc.changeStatus(ids, status);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        this.scpDemandAuthorityRepoProc.deleteByIds(ids);
    }

    @Override
    public Long saveScpManAuthority(ScpsmanAuthorityDO scpsmanAuthorityDO) {
        return ((ScpsmanAuthorityDO)this.scpDemandAuthorityRepo.save(scpsmanAuthorityDO)).getId();
    }

    @Override
    @SysCodeProc
    public List<ScpManAuthorityPageRespVO> listQuery(ScpManAuthorityParam paramVO) {
        return this.scpDemandAuthorityRepoProc.listQuery(paramVO);
    }

    @Override
    public boolean existsByscpsmanNo(ScpManAuthoritySaveVO saveVO) {
        return this.scpDemandAuthorityRepo.existsByscpsmanNo(saveVO.getScpsmanNo());
    }

    @Override
    @SysCodeProc
    public List<ScpManAuthorityPageRespVO> findByScpsmanNoIn(List<String> scpsmanNoList) {
        return this.scpDemandAuthorityRepoProc.findByScpsmanNoIn(scpsmanNoList);
    }

    public ScpDemandAuthprityServiceImpl(ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc, ScpDemandAuthorityRepo scpDemandAuthorityRepo, ScpDemandAuthorityManager scpDemandAuthorityManager) {
        this.scpDemandAuthorityRepoProc = scpDemandAuthorityRepoProc;
        this.scpDemandAuthorityRepo = scpDemandAuthorityRepo;
        this.scpDemandAuthorityManager = scpDemandAuthorityManager;
    }
}

