/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.minOrder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingStoreRespVO;
import com.elitesland.scp.domain.entity.minOrder.QScpMinOrderSettingDO;
import com.elitesland.scp.domain.entity.minOrder.QScpMinOrderSettingStoreDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScpMinOrderSettingStoreRepoProc {
    private static final QScpMinOrderSettingStoreDO scpMinOrderSettingStoreDO = QScpMinOrderSettingStoreDO.scpMinOrderSettingStoreDO;
    private static final QScpMinOrderSettingDO scpMinOrderSettingDO = QScpMinOrderSettingDO.scpMinOrderSettingDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<ScpMinOrderSettingStoreRespVO> pageList;

    public long countMinOrderSettingStore(ScpMinOrderSettingStorePageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)scpMinOrderSettingStoreDO.count()).from((EntityPath)scpMinOrderSettingStoreDO);
        jpaQuery.where(this.whereMinOrderSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpMinOrderSettingStoreRespVO> queryMinOrderSettingStore(ScpMinOrderSettingStorePageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)scpMinOrderSettingStoreDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpMinOrderSettingStoreDO);
        jpaQuery.where(this.whereMinOrderSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereMinOrderSettingPage(ScpMinOrderSettingStorePageParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (paramVO.getMasId() != null) {
            predicates.add(ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.masId.eq((Object)paramVO.getMasId()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<Long> findMasIdByStoreCode(String storeCode) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.masId).distinct()).from((EntityPath)scpMinOrderSettingStoreDO)).where((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeCode.eq((Object)storeCode))).fetch();
    }

    public List<ScpMinOrderSettingStoreRespVO> findByParam(ScpMinOrderSettingStoreParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpMinOrderSettingStoreRespVO.class, (Expression[])new Expression[]{ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.id, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.masId, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeId, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeCode, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeName, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeType2, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.maxNum, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.activeNum})).from((EntityPath)scpMinOrderSettingStoreDO);
        jpaQuery.where((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.masId.in(paramVO.getMasIds()));
        if (StrUtil.isNotBlank((CharSequence)paramVO.getStoreCode())) {
            jpaQuery.where((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeCode.eq((Object)paramVO.getStoreCode()));
        }
        if (paramVO.getUsed() != null && paramVO.getUsed().booleanValue()) {
            jpaQuery.where((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.activeNum.gt((Number)BigDecimal.ZERO));
        }
        return jpaQuery.fetch();
    }

    public List<ScpMinOrderSettingStoreRespVO> findEnabledByParam(ScpMinOrderSettingStoreParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpMinOrderSettingStoreRespVO.class, (Expression[])new Expression[]{ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.id, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.masId, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeId, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeCode, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeName})).from((EntityPath)scpMinOrderSettingStoreDO)).leftJoin((EntityPath)scpMinOrderSettingDO)).on((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.masId.eq(ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingDO.id));
        if (CollUtil.isNotEmpty(paramVO.getMasIds())) {
            jpaQuery.where((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.masId.in(paramVO.getMasIds()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreCodes())) {
            jpaQuery.where((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeCode.in(paramVO.getStoreCodes()));
        }
        jpaQuery.where((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingDO.status.eq(Boolean.TRUE));
        LocalDateTime startOfDay = LocalDateTime.now().toLocalDate().atStartOfDay();
        jpaQuery.where((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingDO.validTo.goe((Comparable)startOfDay));
        return jpaQuery.fetch();
    }

    public List<Long> findUsedSettingByMasIds(List<Long> masIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.masId).distinct()).from((EntityPath)scpMinOrderSettingStoreDO);
        jpaQuery.where((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.masId.in(masIds));
        jpaQuery.where((Predicate)ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.activeNum.gt((Number)0));
        return jpaQuery.fetch();
    }

    public ScpMinOrderSettingStoreRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pageList = Projections.bean(ScpMinOrderSettingStoreRespVO.class, (Expression[])new Expression[]{ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.id, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.masId, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeId, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeCode, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeName, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.storeType2, ScpMinOrderSettingStoreRepoProc.scpMinOrderSettingStoreDO.maxNum});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

