package com.elitesland.scp.domain.entity.purLimit;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "scp_pur_limit_setting_region")
@org.hibernate.annotations.Table(appliesTo = "scp_pur_limit_setting_region", comment = "订货限购区域表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "订货限购区域表", description = "订限购区域表")
@Where(clause = "delete_flag = 0")
public class ScpPurLimitSettingRegionDO extends BaseModel implements Serializable {

    @ApiModelProperty("活动ID")
    @Comment("活动ID")
    @Column()
    private Long masId;

    @ApiModelProperty("区域编码")
    @Comment("区域编码")
    @Column()
    private String region;

    @ApiModelProperty("区域名称")
    @Comment("区域名称")
    @Column()
    private String regionName;

}
