/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.core.common.utils.UUIDUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitescloud.cloudt.system.cacheable.SysCacheUserRpcService;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitesland.inv.dto.invTro.InvTroPayRpcDTO;
import com.elitesland.pur.dto.po.PurPoPayRpcDTO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartSaveVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppRelateOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpOrderPayRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDMgmtRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetSelectRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSubmitVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.AppDemandOrderService;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderDConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.scp.utils.TransactionCommitHandler;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.tenpay.business.entpay.mse.sdk.api.Payment;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class AppDemandOrderServiceImpl
implements AppDemandOrderService {
    private static final Logger log = LoggerFactory.getLogger(AppDemandOrderServiceImpl.class);
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDService scpDemandOrderDService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final RmiItemService rmiItemService;
    private final CartRedisUtil cartRedisUtil;
    private final SysAreaRpcService sysAreaRpcService;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpStoreCartService scpStoreCartService;
    private final CommonPriceService commonPriceService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RmiPurRpcService rmiPurRpcService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final RedisUtils redisUtils;
    private final MessageDelyQueueService messageDelyQueueService;
    private final TransactionCommitHandler transactionCommitHandler;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final TransactionTemplate transactionTemplate;
    private final ScpDemandOrderDRepo scpDemandOrderDRepo;
    private final ScpDemandOrderRepo scpDemandOrderRepo;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final ScpDemandSetDomainService scpDemandSetDomainService;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    private final SysCacheUserRpcService cacheUserRpcService;
    private final RedLockUtils redLockUtils;
    private final ScpServiceConfigService scpServiceConfigService;

    @Override
    public long submit(ScpDemandOrderSubmitVO saveVO) {
        RedissonRedLock redLock = null;
        try {
            redLock = this.redLockUtils.getRedLock("app-demand-order-submit-" + saveVO.getDemandWhStCode());
            boolean lockFlag = redLock.tryLock(3L, 5L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("\u8ba2\u8d27\u5355\u4e0b\u5355\u5df2\u5728\u5904\u7406\u4e2d,\u9501\u5931\u8d25");
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8ba2\u8d27\u5355\u4e0b\u5355\u5df2\u5728\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            List<ScpDemandOrderDSubmitVO> itemList = saveVO.getItemList();
            if (CollUtil.isEmpty(itemList)) {
                throw new BusinessException("\u8ba2\u8d27\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OrgStoreDetailRpcDTO orgStore = Optional.ofNullable(this.orgStoreRpcService.getByCode(saveVO.getDemandWhStCode())).orElseThrow(() -> new BusinessException("\u95e8\u5e97\u4e0d\u5b58\u5728"));
            saveVO.setStoreLevel(orgStore.getStoreLevel());
            saveVO.setStoreType2(orgStore.getStoreType2());
            this.scpServiceConfigService.checkServiceConfig(orgStore.getStoreCode(), orgStore.getRegion(), orgStore.getStoreLevel());
            Long currentUserId = UserService.currentUserId();
            if (currentUserId == null) {
                throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728");
            }
            BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(saveVO.getDemandWhStCode(), saveVO.getBusinessType(), currentUserId);
            ScpDemandOrderDSubmitVO scpDemandOrderDSubmitVO = itemList.get(0);
            ScpDemandOrderDSubmitVO.ItemSpecObjectVO itemSpecObjectVO = scpDemandOrderDSubmitVO.getItemSpecObjectVOS().get(0);
            String itemKey = SysUtils.generateRedisKey("SKU", scpDemandOrderDSubmitVO.getCombineItemCode(), itemSpecObjectVO.getItemCode(), itemSpecObjectVO.getActivityCode());
            Object o = cartOps.get((Object)itemKey);
            if (o == null) {
                throw new BusinessException("\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            }
            Integer expectArrivePriod = orgStore.getExpectArrivePriod();
            saveVO.setEtaDate(LocalDateTime.now().plusDays(Objects.requireNonNullElse(expectArrivePriod, 0).intValue()));
            List<ScpDemandOrderDSaveVO> saveItemList = AppDemandOrderServiceImpl.buildSaveItemList(itemList, null);
            ScpDemandSetSelectRespVO scpDemandSetDTO = this.scpDemandOrderService.getScpDemandSetSelectRespVO(saveVO.getType(), orgStore.getStoreCode());
            saveVO.setDemandId(scpDemandSetDTO.getId());
            saveVO.setDemandCode(scpDemandSetDTO.getDemandCode());
            saveVO.setDemandName(scpDemandSetDTO.getDemandName());
            saveVO.setDemandDate(scpDemandSetDTO.getDemandDate());
            final AtomicReference<ScpDemandOrderDO> scpDemandOrderDO = new AtomicReference<ScpDemandOrderDO>();
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    scpDemandOrderDO.set(this.scpDemandOrderService.saveAndSubmitDemandOrder(ScpDemandOrderConvert.INSTANCE.submitVoToSaveVO(saveVO)));
                    this.scpDemandOrderDService.batchSaveDemandOrderD(((ScpDemandOrderDO)scpDemandOrderDO.get()).getId(), "MG", saveItemList);
                }
                catch (Exception e) {
                    log.error("\u8ba2\u8d27\u5355\u4fdd\u5b58\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
                    transactionStatus.setRollbackOnly();
                    throw new BusinessException(e.getMessage());
                }
                Long id = ((ScpDemandOrderDO)scpDemandOrderDO.get()).getId();
                if (saveVO.getWithoutCart() == null || !saveVO.getWithoutCart().booleanValue()) {
                    this.clearCheckedStoreCartItems(saveVO, saveItemList);
                }
                return null;
            });
            if (((ScpDemandOrderDO)scpDemandOrderDO.get()).getApprStatus() != null && ((ScpDemandOrderDO)scpDemandOrderDO.get()).getApprStatus().equals(ScpUdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode())) {
                this.scpDemandOrderService.startWorkFlow(scpDemandOrderDO.get());
            }
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                    public void afterCommit() {
                        AppDemandOrderServiceImpl.this.splitDoc(scpDemandOrderDO, ((ScpDemandOrderDO)scpDemandOrderDO.get()).getId());
                    }
                });
            } else {
                this.splitDoc(scpDemandOrderDO, ((ScpDemandOrderDO)scpDemandOrderDO.get()).getId());
            }
            long l = scpDemandOrderDO.get().getId();
            return l;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (redLock != null) {
                redLock.unlock();
                log.info("\u8ba2\u8d27\u5355\u652f\u4ed8\uff0c\u91ca\u653e\u9501\u6210\u529f");
            }
        }
    }

    @Override
    public long reOrder(Long id) {
        ScpDemandOrderDO oldScpDemandOrderDO = (ScpDemandOrderDO)this.scpDemandOrderRepo.findById(id).orElseThrow(() -> new BusinessException("\u539f\u8ba2\u8d27\u5355\u6570\u636e\u4e0d\u5b58\u5728"));
        String orderNo = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("OB", new ArrayList<String>());
        ScpDemandOrderDO scpDemandOrderDO = new ScpDemandOrderDO();
        BeanUtils.copyProperties((Object)oldScpDemandOrderDO, (Object)scpDemandOrderDO, (String[])new String[0]);
        scpDemandOrderDO.setDocCode(orderNo);
        scpDemandOrderDO.setDocStatus(ScpUdcEnum.DEO_STATUS_DRAFT.getValueCode());
        scpDemandOrderDO.setId(null);
        scpDemandOrderDO.setCreateTime(null);
        scpDemandOrderDO.setCreator(null);
        scpDemandOrderDO.setModifyTime(null);
        ScpDemandSetSelectRespVO scpDemandSetDTO = this.scpDemandOrderService.getScpDemandSetSelectRespVO(scpDemandOrderDO.getType(), scpDemandOrderDO.getDemandWhStCode());
        scpDemandOrderDO.setDemandId(scpDemandSetDTO.getId());
        scpDemandOrderDO.setDemandCode(scpDemandSetDTO.getDemandCode());
        scpDemandOrderDO.setDemandName(scpDemandSetDTO.getDemandName());
        scpDemandOrderDO.setDemandDate(scpDemandSetDTO.getDemandDate());
        boolean shopUser = this.scpDemandOrderService.isShopUser();
        if (shopUser) {
            if (scpDemandSetDTO.getExpireTime() != null && scpDemandSetDTO.getExpireTime().isBefore(LocalDateTime.now())) {
                throw new BusinessException("\u4e0d\u5728\u8ba2\u8d27\u65f6\u95f4\u5185\uff0c\u65e0\u6cd5\u8ba2\u8d27\uff0c\u91cd\u65b0\u4e0b\u5355\u5931\u8d25");
            }
            scpDemandOrderDO.setAllowPayTimeout(true);
        } else {
            scpDemandOrderDO.setAllowPayTimeout(false);
        }
        List<ScpDemandOrderDDTO> demandOrderDByMasId = this.scpDemandOrderDDomainService.findDemandOrderDByMasIdAndProjectFeeFlag(id, false);
        if (CollUtil.isEmpty(demandOrderDByMasId)) {
            throw new BusinessException("\u539f\u8ba2\u8d27\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        ArrayList<ScpDemandOrderDSaveVO> saveItemList = new ArrayList<ScpDemandOrderDSaveVO>();
        for (ScpDemandOrderDDTO scpDemandOrderDDTO : demandOrderDByMasId) {
            ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = ScpDemandOrderDConvert.INSTANCE.dtoToSaveVO(scpDemandOrderDDTO);
            scpDemandOrderDSaveVO.setId(null);
            scpDemandOrderDSaveVO.setMasId(null);
            scpDemandOrderDSaveVO.setIsPushed(false);
            scpDemandOrderDSaveVO.setIsProjFeeCharged(scpDemandOrderDDTO.getTechFee() != null || scpDemandOrderDDTO.getMarketingFee() != null || scpDemandOrderDDTO.getOperationFee() != null);
            saveItemList.add(scpDemandOrderDSaveVO);
        }
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(scpDemandOrderDO.getBusinessType(), scpDemandOrderDO.getType());
        Boolean needApproval = orderSetting.getNeedApproval();
        if (needApproval != null) {
            if (needApproval.booleanValue()) {
                scpDemandOrderDO.setApprStatus(ScpUdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
            } else {
                scpDemandOrderDO.setApprStatus(ScpUdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode());
            }
        }
        AtomicReference<ScpDemandOrderDO> result = new AtomicReference<ScpDemandOrderDO>();
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(transactionStatus -> {
            try {
                ScpDemandOrderDO save = (ScpDemandOrderDO)this.scpDemandOrderRepo.save(scpDemandOrderDO);
                result.set(save);
                List<ScpDemandOrderDSaveVO> collect = saveItemList.stream().peek(vo -> vo.setMasId(save.getId())).collect(Collectors.toList());
                this.scpDemandOrderDService.batchSaveDemandOrderD(save.getId(), "MG", collect);
                oldScpDemandOrderDO.setDocStatus(ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode());
                this.scpDemandOrderRepo.save(oldScpDemandOrderDO);
            }
            catch (Exception e) {
                log.error("\u8ba2\u8d27\u5355\u4fdd\u5b58\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
                transactionStatus.setRollbackOnly();
                throw new BusinessException(e.getMessage());
            }
            return null;
        });
        long orderId = ((ScpDemandOrderDO)result.get()).getId();
        this.splitDocOrWorkflow(result, orderId);
        return orderId;
    }

    private void splitDocOrWorkflow(AtomicReference<ScpDemandOrderDO> result, long orderId) {
        if (result.get().getApprStatus() != null) {
            if (result.get().getApprStatus().equals(ScpUdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode())) {
                this.scpDemandOrderService.splitDoc(result.get(), orderId, new ArrayList<ScpDemandOrderDDO>());
            } else if (result.get().getApprStatus().equals(ScpUdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode())) {
                this.scpDemandOrderService.startWorkFlow(result.get());
            }
        }
    }

    private void splitDoc(AtomicReference<ScpDemandOrderDO> result, long orderId) {
        if (result.get().getApprStatus() != null && result.get().getApprStatus().equals(ScpUdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode())) {
            this.scpDemandOrderService.splitDoc(result.get(), orderId, new ArrayList<ScpDemandOrderDDO>());
        }
    }

    private static List<ScpDemandOrderDSaveVO> buildSaveItemList(List<ScpDemandOrderDSubmitVO> itemList, String itemCode) {
        return itemList.stream().flatMap(item -> item.getItemSpecObjectVOS().stream().flatMap(row -> {
            String uuid = UUIDUtil.getUUID();
            Optional<ScpDemandOrderDSubmitVO.WhAllocObject> maxRatioWhAllocObject = row.getWhAllocObjects().stream().max(Comparator.comparing(ScpDemandOrderDSubmitVO.WhAllocObject::getRatio));
            Stream<ScpDemandOrderDSaveVO> dvoStream = row.getWhAllocObjects().stream().map(whObj -> AppDemandOrderServiceImpl.buildScpDemandOrderDVO(item, row, whObj, uuid, itemCode));
            Stream<Object> giftStream = Stream.empty();
            if (maxRatioWhAllocObject.isPresent()) {
                ScpDemandOrderDSubmitVO.WhAllocObject wh = maxRatioWhAllocObject.get();
                List<ScpDemandOrderDSubmitVO.GiftItemVO> giftItemVOS = row.getGiftItemVOS();
                if (giftItemVOS != null && !giftItemVOS.isEmpty()) {
                    giftStream = giftItemVOS.stream().map(gift -> AppDemandOrderServiceImpl.buildScpDemandOrderGiftLine(item, row, gift, wh, uuid));
                }
            }
            return Stream.concat(dvoStream, giftStream);
        })).collect(Collectors.toList());
    }

    private void clearCheckedStoreCartItems(ScpDemandOrderSubmitVO saveVO, List<ScpDemandOrderDSaveVO> saveItemList) {
        for (ScpDemandOrderDSaveVO item : saveItemList) {
            if (Boolean.TRUE.equals(item.getGiftLineFlag())) continue;
            this.cartRedisUtil.clearCheckedStoreCartItems(saveVO.getDemandWhStCode(), UserService.currentUserId(), saveVO.getBusinessType(), SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode()));
        }
    }

    private static ScpDemandOrderDSaveVO buildScpDemandOrderDVO(ScpDemandOrderDSubmitVO item, ScpDemandOrderDSubmitVO.ItemSpecObjectVO row, ScpDemandOrderDSubmitVO.WhAllocObject whAllocObject, String uuid, String freightItemCode) {
        Integer amtPlace = SysUtils.getAmtPlace();
        ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
        scpDemandOrderDSaveVO.setAllocationDeQuantity(whAllocObject.getQty());
        scpDemandOrderDSaveVO.setRatio(whAllocObject.getRatio());
        scpDemandOrderDSaveVO.setSupplyType(whAllocObject.getSupplyType());
        scpDemandOrderDSaveVO.setCombineItemCode(item.getCombineItemCode());
        scpDemandOrderDSaveVO.setCombineItemName(item.getCombineItemName());
        scpDemandOrderDSaveVO.setCombineItemFlag(item.getCombineItemFlag());
        if (ScpConstant.WH_DELIVERY_TYPES.contains(row.getDeliveryType())) {
            scpDemandOrderDSaveVO.setSuppWhId(whAllocObject.getSupplyWhId());
            scpDemandOrderDSaveVO.setSuppWhCode(whAllocObject.getSupplyWhCode());
            scpDemandOrderDSaveVO.setSuppWhName(whAllocObject.getSupplyWhName());
        } else {
            if (whAllocObject.getSuppId() == null || whAllocObject.getSuppCode() == null) {
                throw new BusinessException("\u76f4\u9001\u5546\u54c1\u3010" + row.getItemName() + "\u3011\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546");
            }
            scpDemandOrderDSaveVO.setSuppWhId(whAllocObject.getSuppId());
            scpDemandOrderDSaveVO.setSuppWhCode(whAllocObject.getSuppCode());
            scpDemandOrderDSaveVO.setSuppWhName(whAllocObject.getSuppName());
        }
        scpDemandOrderDSaveVO.setSpuItemCode(item.getSpuCode());
        scpDemandOrderDSaveVO.setSpuItemName(item.getSpuName());
        scpDemandOrderDSaveVO.setItemId(row.getItemId());
        scpDemandOrderDSaveVO.setItemCode(row.getItemCode());
        scpDemandOrderDSaveVO.setItemName(row.getItemName());
        scpDemandOrderDSaveVO.setDemandQuantity(row.getDemandQuantity());
        scpDemandOrderDSaveVO.setUnit(row.getUom());
        scpDemandOrderDSaveVO.setUnitName(row.getUomName());
        scpDemandOrderDSaveVO.setPrice(whAllocObject.getPrice());
        scpDemandOrderDSaveVO.setSalePrice(whAllocObject.getSalePrice());
        if (whAllocObject.getSettlementPrice() == null) {
            scpDemandOrderDSaveVO.setSettlementPrice(whAllocObject.getPrice());
        } else {
            scpDemandOrderDSaveVO.setSettlementPrice(whAllocObject.getSettlementPrice());
        }
        if (whAllocObject.getSettlementSalePrice() == null) {
            scpDemandOrderDSaveVO.setSettlementSalePrice(whAllocObject.getSalePrice());
        } else {
            scpDemandOrderDSaveVO.setSettlementSalePrice(whAllocObject.getSettlementSalePrice());
        }
        scpDemandOrderDSaveVO.setDiscount(row.getDiscount());
        scpDemandOrderDSaveVO.setOuId(whAllocObject.getOuId());
        scpDemandOrderDSaveVO.setOuCode(whAllocObject.getOuCode());
        scpDemandOrderDSaveVO.setOuName(whAllocObject.getOuName());
        scpDemandOrderDSaveVO.setIsCalculated(Boolean.FALSE);
        scpDemandOrderDSaveVO.setIsPushed(Boolean.FALSE);
        scpDemandOrderDSaveVO.setUom2(row.getUom2());
        scpDemandOrderDSaveVO.setUom2Name(row.getUom2Name());
        scpDemandOrderDSaveVO.setUomRatio(row.getUomRatio());
        if (row.getUomRatio() != null) {
            scpDemandOrderDSaveVO.setQty2(whAllocObject.getQty().multiply(row.getUomRatio()).setScale((int)row.getDecimalPlaces(), RoundingMode.HALF_UP));
        }
        if (whAllocObject.getPrice() != null) {
            scpDemandOrderDSaveVO.setDemandAmt(SysUtils.processAmtScale(row.getDemandQuantity().multiply(whAllocObject.getPrice()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
            scpDemandOrderDSaveVO.setSaleAmt(SysUtils.processAmtScale(row.getDemandQuantity().multiply(whAllocObject.getSalePrice()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
        }
        if (scpDemandOrderDSaveVO.getSettlementPrice() != null) {
            scpDemandOrderDSaveVO.setSettlementAmt(SysUtils.processAmtScale(row.getDemandQuantity().multiply(scpDemandOrderDSaveVO.getSettlementPrice()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
        }
        if (scpDemandOrderDSaveVO.getSettlementSalePrice() != null) {
            scpDemandOrderDSaveVO.setSettlementSaleAmt(SysUtils.processAmtScale(row.getDemandQuantity().multiply(scpDemandOrderDSaveVO.getSettlementSalePrice()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
        }
        scpDemandOrderDSaveVO.setPreSaleStatus(row.getPreSaleStatus());
        scpDemandOrderDSaveVO.setFreightFlag(whAllocObject.getFreightFlag());
        scpDemandOrderDSaveVO.setFreightRatio(whAllocObject.getFreightRatio());
        scpDemandOrderDSaveVO.setSaleCustCode(whAllocObject.getSaleCustCode());
        scpDemandOrderDSaveVO.setSaleOuCode(whAllocObject.getSaleOuCode());
        scpDemandOrderDSaveVO.setSaleOuName(whAllocObject.getSaleOuName());
        scpDemandOrderDSaveVO.setTefPrice(whAllocObject.getTefPrice());
        scpDemandOrderDSaveVO.setMefPrice(whAllocObject.getMefPrice());
        scpDemandOrderDSaveVO.setOefPrice(whAllocObject.getOefPrice());
        scpDemandOrderDSaveVO.setIsProjFeeCharged(whAllocObject.getIsProjFeeCharged());
        scpDemandOrderDSaveVO.setProjectFeeFlag(Boolean.FALSE);
        scpDemandOrderDSaveVO.setTefFeeOuCode(whAllocObject.getTefFeeOuCode());
        scpDemandOrderDSaveVO.setTefFeeOuName(whAllocObject.getTefFeeOuName());
        scpDemandOrderDSaveVO.setOefFeeOuCode(whAllocObject.getOefFeeOuCode());
        scpDemandOrderDSaveVO.setOefFeeOuName(whAllocObject.getOefFeeOuName());
        scpDemandOrderDSaveVO.setMefFeeOuCode(whAllocObject.getMefFeeOuCode());
        scpDemandOrderDSaveVO.setMefFeeOuName(whAllocObject.getMefFeeOuName());
        if (whAllocObject.getIsProjFeeCharged() != null && whAllocObject.getIsProjFeeCharged().booleanValue()) {
            Optional.ofNullable(scpDemandOrderDSaveVO.getTefPrice()).ifPresent(price -> scpDemandOrderDSaveVO.setTechFee(price.multiply(scpDemandOrderDSaveVO.getDemandQuantity()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
            Optional.ofNullable(scpDemandOrderDSaveVO.getMefPrice()).ifPresent(price -> scpDemandOrderDSaveVO.setMarketingFee(price.multiply(scpDemandOrderDSaveVO.getDemandQuantity()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
            Optional.ofNullable(scpDemandOrderDSaveVO.getOefPrice()).ifPresent(price -> scpDemandOrderDSaveVO.setOperationFee(price.multiply(scpDemandOrderDSaveVO.getDemandQuantity()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
        }
        scpDemandOrderDSaveVO.setItemType(row.getItemType());
        scpDemandOrderDSaveVO.setDeliveryType(row.getDeliveryType());
        scpDemandOrderDSaveVO.setPreRootUuid(uuid);
        scpDemandOrderDSaveVO.setImgUrl(item.getUrl());
        scpDemandOrderDSaveVO.setFreightLineFlag(freightItemCode != null && freightItemCode.equals(row.getItemCode()));
        scpDemandOrderDSaveVO.setActivityId(row.getActivityId());
        scpDemandOrderDSaveVO.setActivityCode(row.getActivityCode());
        scpDemandOrderDSaveVO.setMinNum(row.getMinNum());
        scpDemandOrderDSaveVO.setCostType("standard");
        whAllocObject.setUuid(uuid);
        scpDemandOrderDSaveVO.setCurrency("CNY");
        return scpDemandOrderDSaveVO;
    }

    private static ScpDemandOrderDSaveVO buildScpDemandOrderGiftLine(ScpDemandOrderDSubmitVO item, ScpDemandOrderDSubmitVO.ItemSpecObjectVO row, ScpDemandOrderDSubmitVO.GiftItemVO gift, ScpDemandOrderDSubmitVO.WhAllocObject wh, String uuid) {
        ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
        scpDemandOrderDSaveVO.setGiftLineFlag(Boolean.TRUE);
        scpDemandOrderDSaveVO.setAllocationDeQuantity(gift.getQty());
        scpDemandOrderDSaveVO.setRatio(wh.getRatio());
        scpDemandOrderDSaveVO.setSupplyType(wh.getSupplyType());
        if (ScpConstant.WH_DELIVERY_TYPES.contains(row.getDeliveryType())) {
            scpDemandOrderDSaveVO.setSuppWhId(wh.getSupplyWhId());
            scpDemandOrderDSaveVO.setSuppWhCode(wh.getSupplyWhCode());
            scpDemandOrderDSaveVO.setSuppWhName(wh.getSupplyWhName());
        } else {
            scpDemandOrderDSaveVO.setSuppWhId(wh.getSuppId());
            scpDemandOrderDSaveVO.setSuppWhCode(wh.getSuppCode());
            scpDemandOrderDSaveVO.setSuppWhName(wh.getSuppName());
        }
        scpDemandOrderDSaveVO.setSpuItemCode(gift.getSpuCode());
        scpDemandOrderDSaveVO.setSpuItemName(gift.getSpuName());
        scpDemandOrderDSaveVO.setItemId(gift.getDiscountGiftItemId());
        scpDemandOrderDSaveVO.setItemCode(gift.getDiscountGiftItemCode());
        scpDemandOrderDSaveVO.setItemName(gift.getDiscountGiftItemName());
        scpDemandOrderDSaveVO.setDemandQuantity(row.getDemandQuantity());
        scpDemandOrderDSaveVO.setUnit(row.getUom());
        scpDemandOrderDSaveVO.setUnitName(row.getUomName());
        scpDemandOrderDSaveVO.setPrice(BigDecimal.ZERO);
        scpDemandOrderDSaveVO.setSalePrice(BigDecimal.ZERO);
        scpDemandOrderDSaveVO.setSettlementPrice(BigDecimal.ZERO);
        scpDemandOrderDSaveVO.setSettlementSalePrice(BigDecimal.ZERO);
        scpDemandOrderDSaveVO.setOuId(wh.getOuId());
        scpDemandOrderDSaveVO.setOuCode(wh.getOuCode());
        scpDemandOrderDSaveVO.setOuName(wh.getOuName());
        scpDemandOrderDSaveVO.setIsCalculated(Boolean.FALSE);
        scpDemandOrderDSaveVO.setIsPushed(Boolean.FALSE);
        scpDemandOrderDSaveVO.setUom2(row.getUom2());
        scpDemandOrderDSaveVO.setUom2Name(row.getUom2Name());
        scpDemandOrderDSaveVO.setUomRatio(row.getUomRatio());
        if (row.getUomRatio() != null) {
            scpDemandOrderDSaveVO.setQty2(gift.getQty().multiply(row.getUomRatio()).setScale((int)row.getDecimalPlaces(), RoundingMode.HALF_UP));
        }
        scpDemandOrderDSaveVO.setDemandAmt(BigDecimal.ZERO);
        scpDemandOrderDSaveVO.setFreightFlag(Boolean.FALSE);
        scpDemandOrderDSaveVO.setSaleCustCode(wh.getSaleCustCode());
        scpDemandOrderDSaveVO.setSaleOuCode(wh.getSaleOuCode());
        scpDemandOrderDSaveVO.setSaleOuName(wh.getSaleOuName());
        scpDemandOrderDSaveVO.setTefPrice(wh.getTefPrice());
        scpDemandOrderDSaveVO.setMefPrice(wh.getMefPrice());
        scpDemandOrderDSaveVO.setOefPrice(wh.getOefPrice());
        scpDemandOrderDSaveVO.setIsProjFeeCharged(wh.getIsProjFeeCharged());
        scpDemandOrderDSaveVO.setProjectFeeFlag(Boolean.FALSE);
        scpDemandOrderDSaveVO.setTefFeeOuCode(wh.getTefFeeOuCode());
        scpDemandOrderDSaveVO.setTefFeeOuName(wh.getTefFeeOuName());
        scpDemandOrderDSaveVO.setOefFeeOuCode(wh.getOefFeeOuCode());
        scpDemandOrderDSaveVO.setOefFeeOuName(wh.getOefFeeOuName());
        scpDemandOrderDSaveVO.setMefFeeOuCode(wh.getMefFeeOuCode());
        scpDemandOrderDSaveVO.setMefFeeOuName(wh.getMefFeeOuName());
        if (wh.getIsProjFeeCharged() != null && wh.getIsProjFeeCharged().booleanValue()) {
            Optional.ofNullable(scpDemandOrderDSaveVO.getTefPrice()).ifPresent(price -> scpDemandOrderDSaveVO.setTechFee(price.multiply(scpDemandOrderDSaveVO.getDemandQuantity())));
            Optional.ofNullable(scpDemandOrderDSaveVO.getMefPrice()).ifPresent(price -> scpDemandOrderDSaveVO.setMarketingFee(price.multiply(scpDemandOrderDSaveVO.getDemandQuantity())));
            Optional.ofNullable(scpDemandOrderDSaveVO.getOefPrice()).ifPresent(price -> scpDemandOrderDSaveVO.setOperationFee(price.multiply(scpDemandOrderDSaveVO.getDemandQuantity())));
        }
        scpDemandOrderDSaveVO.setItemType(row.getItemType());
        scpDemandOrderDSaveVO.setPreRootUuid(uuid);
        scpDemandOrderDSaveVO.setImgUrl(gift.getUrl());
        scpDemandOrderDSaveVO.setFreightLineFlag(Boolean.FALSE);
        scpDemandOrderDSaveVO.setActivityId(row.getActivityId());
        scpDemandOrderDSaveVO.setActivityCode(row.getActivityCode());
        scpDemandOrderDSaveVO.setMinNum(row.getMinNum());
        return scpDemandOrderDSaveVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveDemandOrderD(List<ScpDemandOrderDSaveVO> saveVOS) {
        BigDecimal maxLineNo = this.scpDemandOrderDDomainService.findMaxLineNoPushedByMasId(saveVOS.get(0).getMasId());
        AtomicInteger lineNo = new AtomicInteger(maxLineNo.add(BigDecimal.ONE).intValue());
        for (ScpDemandOrderDSaveVO saveVO : saveVOS) {
            if (saveVO.getId() == null) continue;
            saveVO.setLineNo(BigDecimal.valueOf(lineNo.getAndIncrement()));
        }
        this.scpDemandOrderDDomainService.batchSave(saveVOS, lineNo);
    }

    @Override
    public void addCart(Long id) {
        ScpDemandOrderRespVO demandOrder = this.scpDemandOrderService.findDemandOrderById(id).orElseThrow(new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728"));
        List<ScpDemandOrderDMgmtRespVO> demandItemList = this.scpDemandOrderDService.findDemandOrderDByMasId(id);
        if (CollUtil.isEmpty(demandItemList)) {
            return;
        }
        String storeCode = demandOrder.getDemandWhStCode();
        String docType = demandOrder.getDocType();
        String busType = demandOrder.getBusinessType();
        ArrayList<StoreCartSaveVO> cartSaveVOS = new ArrayList<StoreCartSaveVO>();
        String orderItemSetting = SysUtils.getOrderItemSetting();
        List itemIds = demandItemList.stream().map(ScpDemandOrderDMgmtRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(itemIds);
        List<ItmItemScpBaseRpcDTO> itemList = this.rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        Map itemMap = itemList.stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId, Function.identity()));
        for (ScpDemandOrderDMgmtRespVO item : demandItemList) {
            if (orderItemSetting.equals(item.getItemCode())) continue;
            StoreCartSaveVO cartSaveVO = new StoreCartSaveVO();
            ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = (ItmItemScpBaseRpcDTO)itemMap.get(item.getItemId());
            cartSaveVO.setDemandWhStCode(storeCode);
            cartSaveVO.setItemType2(itmItemScpBaseRpcDTO.getItemType2());
            cartSaveVO.setCartType(docType);
            cartSaveVO.setItemId(item.getItemId());
            cartSaveVO.setItemCode(item.getItemCode());
            cartSaveVO.setItemName(itmItemScpBaseRpcDTO.getItemName());
            cartSaveVO.setUom(item.getUnit());
            cartSaveVO.setUomName(item.getUnitName());
            cartSaveVO.setSpuId(itmItemScpBaseRpcDTO.getSpuId());
            cartSaveVO.setSpuCode(itmItemScpBaseRpcDTO.getSpuCode());
            cartSaveVO.setSpuName(itmItemScpBaseRpcDTO.getSpuName());
            cartSaveVO.setQty(item.getDemandQuantity());
            cartSaveVO.setSpec(itmItemScpBaseRpcDTO.getSpec());
            List skuAttchmentList = itmItemScpBaseRpcDTO.getSkuAttchmentList();
            List spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
            if (CollUtil.isNotEmpty((Collection)skuAttchmentList)) {
                first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                cartSaveVO.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)skuAttchmentList.get(0)).getUrl() : first.get().getUrl());
            } else if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                cartSaveVO.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
            }
            cartSaveVO.setItemCateCode(itmItemScpBaseRpcDTO.getItemCateCode());
            cartSaveVO.setItemCateName(itmItemScpBaseRpcDTO.getItemCateName());
            cartSaveVOS.add(cartSaveVO);
        }
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(busType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItemActivityItemPriceParamVO> priceParamVOS = cartSaveVOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setItemType2(row.getItemType2());
            priceParamVO.setUom(row.getUom());
            return priceParamVO;
        }).collect(Collectors.toList());
        Map<String, AppItemPriceRespVO> priceMap = this.commonPriceService.getNewPriceAndStockDetails(priceParamVOS, storeCode, orderSetting, demandOrder.getType());
        cartSaveVOS.forEach(row -> {
            if (priceMap.containsKey(row.getItemCode())) {
                AppItemPriceRespVO priceRespVO = (AppItemPriceRespVO)priceMap.get(row.getItemCode());
                row.setSuppId(priceRespVO.getSuppId());
                row.setSuppCode(priceRespVO.getSuppCode());
                row.setSuppName(priceRespVO.getSuppName());
                row.setStoreCode(priceRespVO.getStoreCode());
                row.setCostPrice(priceRespVO.getCostPrice());
                row.setPurPrice(priceRespVO.getPurPrice());
                row.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                row.setTefPrice(priceRespVO.getTefPrice());
                row.setMefPrice(priceRespVO.getMefPrice());
                row.setOefPrice(priceRespVO.getOefPrice());
                row.setItemPrice(priceRespVO.getPrice());
                row.setSalePrice(priceRespVO.getSalePrice());
                row.setTefFeeOuCode(priceRespVO.getTefFeeOuCode());
                row.setTefFeeOuName(priceRespVO.getTefFeeOuName());
                row.setOefFeeOuCode(priceRespVO.getOefFeeOuCode());
                row.setOefFeeOuName(priceRespVO.getOefFeeOuName());
                row.setMefFeeOuCode(priceRespVO.getMefFeeOuCode());
                row.setMefFeeOuName(priceRespVO.getMefFeeOuName());
            }
        });
        this.scpStoreCartService.batchSaveCart(storeCode, docType, cartSaveVOS);
    }

    @Override
    @SysCodeProc
    public ScpDemandOrderRespVO findDemandOrderById(Long id) {
        ScpDemandOrderRespVO orderRespVO = this.scpDemandOrderService.findDemandOrderById(id).orElseThrow(() -> new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728\uff01"));
        Map<String, String> areaMap = this.buildAddr(orderRespVO.getRecvProvince(), orderRespVO.getRecvCity(), orderRespVO.getRecvCounty());
        if (CollUtil.isNotEmpty(areaMap)) {
            orderRespVO.setRecvProvinceName(areaMap.get(orderRespVO.getRecvProvince()));
            orderRespVO.setRecvCityName(areaMap.get(orderRespVO.getRecvCity()));
            orderRespVO.setRecvCountyName(areaMap.get(orderRespVO.getRecvCounty()));
        }
        List<ScpDemandOrderDDTO> demandOrderD = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(id);
        AtomicReference<BigDecimal> itemTotalCount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> amt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> saleAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> noPayAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> freightAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> discountAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        for (ScpDemandOrderDDTO row : demandOrderD) {
            if (row.getProjectFeeFlag() != null && row.getProjectFeeFlag().booleanValue()) {
                saleAmt.updateAndGet(v -> v.add(row.getSettlementSaleAmt()));
                continue;
            }
            if (row.getPlanQuantity() != null) {
                itemTotalCount.updateAndGet(v -> v.add(row.getPlanQuantity()));
            }
            if (row.getSettlementAmt() != null) {
                amt.updateAndGet(v -> v.add(row.getSettlementAmt()));
            }
            if (row.getSettlementSaleAmt() != null) {
                saleAmt.updateAndGet(v -> v.add(row.getSettlementSaleAmt()));
            }
            if (row.getPayStatus() != null && ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode().equals(row.getPayStatus())) {
                noPayAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            }
            if (row.getFreightLineFlag().booleanValue()) {
                freightAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            } else {
                goodAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            }
            if (Objects.equals(row.getPlanAmt(), row.getSettlementAmt())) continue;
            discountAmt.updateAndGet(v -> v.add(row.getPlanAmt().subtract(row.getSettlementAmt())));
        }
        orderRespVO.setItemTotalCount(itemTotalCount.get());
        orderRespVO.setAmt(saleAmt.get());
        orderRespVO.setDiscountAmt(discountAmt.get());
        orderRespVO.setNoPayAmt(noPayAmt.get());
        orderRespVO.setGoodAmt(goodAmt.get());
        orderRespVO.setFreightAmt(freightAmt.get());
        return orderRespVO;
    }

    @Override
    @SysCodeProc
    public AppPayOrderRespVO findPayOrderBySrcDocId(Long srcDocId) {
        AppPayOrderRespVO appPayOrderRespVO = this.scpDemandOrderDomainService.payOrderBySrcDocId(srcDocId);
        return this.getAppPayOrderRespVO(appPayOrderRespVO);
    }

    @NotNull
    private AppPayOrderRespVO getAppPayOrderRespVO(AppPayOrderRespVO appPayOrderRespVO) {
        ScpDemandOrderDTO scpDemandOrderDTO = this.scpDemandOrderDomainService.findDemandOrderById(appPayOrderRespVO.getDocId()).get();
        appPayOrderRespVO.setDocCode(scpDemandOrderDTO.getDocCode());
        appPayOrderRespVO.setDocType(scpDemandOrderDTO.getDocType());
        appPayOrderRespVO.setBusinessType(scpDemandOrderDTO.getBusinessType());
        appPayOrderRespVO.setCreateTime(scpDemandOrderDTO.getCreateTime());
        appPayOrderRespVO.setRecvContactName(scpDemandOrderDTO.getRecvContactName());
        appPayOrderRespVO.setRecvContactTel(scpDemandOrderDTO.getRecvContactTel());
        String payStatus = this.queryWqfAndUpdatePayStatus(appPayOrderRespVO.getSrcDocNo(), appPayOrderRespVO.getPayStatus(), appPayOrderRespVO.getOnlinePayFlag());
        appPayOrderRespVO.setPayStatus(payStatus);
        Map<String, String> stringStringMap = this.buildAddr(scpDemandOrderDTO.getRecvProvince(), scpDemandOrderDTO.getRecvCity(), scpDemandOrderDTO.getRecvCounty());
        if (CollUtil.isNotEmpty(stringStringMap)) {
            appPayOrderRespVO.setRecvProvinceName(stringStringMap.get(scpDemandOrderDTO.getRecvProvince()));
            appPayOrderRespVO.setRecvCityName(stringStringMap.get(scpDemandOrderDTO.getRecvCity()));
            appPayOrderRespVO.setRecvCountyName(stringStringMap.get(scpDemandOrderDTO.getRecvCounty()));
        }
        if (!this.redisUtils.hasKey("SCP_ONLINE_PAY:" + appPayOrderRespVO.getSrcDocNo())) {
            return appPayOrderRespVO;
        }
        appPayOrderRespVO.setCountdown(this.messageDelyQueueService.getOrderExpireTime("SCP_ONLINE_PAY:" + appPayOrderRespVO.getSrcDocNo()));
        return appPayOrderRespVO;
    }

    @Override
    @SysCodeProc
    public AppPayOrderRespVO findPayOrderById(Long id) {
        ScpsmanInfoDO byLoginAccount;
        ScpDemandOrderDTO scpDemandOrderDTO = this.scpDemandOrderDomainService.findDemandOrderById(id).orElseThrow(new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728"));
        AppPayOrderRespVO appPayOrderRespVO = new AppPayOrderRespVO();
        SysUserBasicDTO byId = this.cacheUserRpcService.getById(scpDemandOrderDTO.getCreateUserId());
        if (byId != null && (byLoginAccount = this.scpsmanInfoRepo.findByLoginAccount(byId.getUsername())) != null) {
            String scpManType = byLoginAccount.getScpsmanType();
            appPayOrderRespVO.setCreatorScpManType(scpManType);
        }
        appPayOrderRespVO.setDocCode(scpDemandOrderDTO.getDocCode());
        appPayOrderRespVO.setDocStatus(scpDemandOrderDTO.getDocStatus());
        appPayOrderRespVO.setDocType(scpDemandOrderDTO.getDocType());
        appPayOrderRespVO.setBusinessType(scpDemandOrderDTO.getBusinessType());
        appPayOrderRespVO.setCreator(scpDemandOrderDTO.getCreator());
        appPayOrderRespVO.setCreateUserId(scpDemandOrderDTO.getCreateUserId());
        appPayOrderRespVO.setCreateTime(scpDemandOrderDTO.getCreateTime());
        appPayOrderRespVO.setRecvContactName(scpDemandOrderDTO.getRecvContactName());
        appPayOrderRespVO.setRecvContactTel(scpDemandOrderDTO.getRecvContactTel());
        appPayOrderRespVO.setPayStatus(scpDemandOrderDTO.getPayStatus());
        appPayOrderRespVO.setIsPushed(scpDemandOrderDTO.getIsPushed());
        appPayOrderRespVO.setPushedTime(scpDemandOrderDTO.getPushedTime());
        appPayOrderRespVO.setApprStatus(scpDemandOrderDTO.getApprStatus());
        appPayOrderRespVO.setRecvDetailaddr(scpDemandOrderDTO.getRecvDetailaddr());
        Map<String, String> stringStringMap = this.buildAddr(scpDemandOrderDTO.getRecvProvince(), scpDemandOrderDTO.getRecvCity(), scpDemandOrderDTO.getRecvCounty());
        if (CollUtil.isNotEmpty(stringStringMap)) {
            appPayOrderRespVO.setRecvProvinceName(stringStringMap.get(scpDemandOrderDTO.getRecvProvince()));
            appPayOrderRespVO.setRecvCityName(stringStringMap.get(scpDemandOrderDTO.getRecvCity()));
            appPayOrderRespVO.setRecvCountyName(stringStringMap.get(scpDemandOrderDTO.getRecvCounty()));
        }
        return appPayOrderRespVO;
    }

    private String queryWqfAndUpdatePayStatus(String srcDocNo, String payStatus, Boolean onlinePayFlag) {
        if (!onlinePayFlag.booleanValue() || ScpUdcEnum.PAY_STATUS_PAYED.getValueCode().equals(payStatus)) {
            return payStatus;
        }
        try {
            Payment payment = Payment.retrieveByOutPaymentId((String)srcDocNo);
            List<String> payStatusList = List.of("CLOSED", "PROCESSING");
            if (payStatusList.contains(payment.getPayStatus())) {
                return payStatus;
            }
            String updatePayStatus = "SUCCEEDED".equals(payment.getPayStatus()) ? ScpUdcEnum.PAY_STATUS_PAYED.getValueCode() : ScpUdcEnum.PAY_STATUS_PAYING.getValueCode();
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    this.scpDemandOrderDRepoProc.updatePayStatusBySrcDocId(srcDocNo, updatePayStatus);
                    return "ok";
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u8ba2\u8d27\u5355\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                    transactionStatus.setRollbackOnly();
                    return "ok";
                }
            });
            return updatePayStatus;
        }
        catch (EntpayException e) {
            log.error("\u67e5\u8be2\u94f6\u884c\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            return payStatus;
        }
    }

    @Override
    public AppPayOrderItemRespVO findPayOrderItemBySrcDocId(Long srcDocId) {
        List<ScpDemandOrderDDTO> demandOrderDDTOS = this.scpDemandOrderDDomainService.findDemandOrderDBySrcDocIdAndProjectFeeFlag(srcDocId, false);
        return this.getAppPayOrderItemRespVO(demandOrderDDTOS);
    }

    @NotNull
    private AppPayOrderItemRespVO getAppPayOrderItemRespVO(List<ScpDemandOrderDDTO> demandOrderDDTOS) {
        AppPayOrderItemRespVO result = new AppPayOrderItemRespVO();
        if (CollUtil.isEmpty(demandOrderDDTOS)) {
            throw new BusinessException("\u8ba2\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        Map<String, String> uomCodeMap = this.rmiSysUDCService.getCodeMap("yst-supp", "UOM");
        Map<String, String> deoStatus = this.rmiSysUDCService.getCodeMap("yst-suplan", "DEO_STATUS");
        List<Long> itemIds = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemScpBaseRpcDTO> scpItemMap = this.rmiItemService.findScpItemMap(itemIds);
        List<AppPayOrderItemRespVO.ItemSpecObjectVO> itemList = demandOrderDDTOS.stream().map(row -> {
            AppPayOrderItemRespVO.ItemSpecObjectVO specObj = new AppPayOrderItemRespVO.ItemSpecObjectVO();
            specObj.setItemCode(row.getItemCode());
            specObj.setItemName(row.getItemName());
            specObj.setCombineItemCode(row.getCombineItemCode());
            specObj.setCombineItemName(row.getCombineItemName());
            specObj.setActivityId(row.getActivityId());
            specObj.setActivityCode(row.getActivityCode());
            specObj.setStatus(row.getStatus());
            if (deoStatus.containsKey(row.getStatus())) {
                specObj.setStatusName((String)deoStatus.get(row.getStatus()));
            }
            specObj.setUom(row.getUnit());
            if (uomCodeMap.containsKey(row.getUnit())) {
                specObj.setUomName((String)uomCodeMap.get(row.getUnit()));
            }
            if (scpItemMap.containsKey(row.getItemId())) {
                ItmItemScpBaseRpcDTO item = (ItmItemScpBaseRpcDTO)scpItemMap.get(row.getItemId());
                specObj.setItemAttrName(StrUtil.isBlank((CharSequence)item.getItemAttrName()) ? item.getSpec() : item.getItemAttrName());
                specObj.setAnotherName(item.getAnotherName());
                List spuAttchmentList = item.getSpuAttchmentList();
                if (CollUtil.isNotEmpty((Collection)item.getSkuAttchmentList())) {
                    Optional<ItmItemAttachmentRpcDTO> first = item.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                    String url = first.isPresent() ? first.get().getUrl() : ((ItmItemAttachmentRpcDTO)item.getSkuAttchmentList().get(0)).getUrl();
                    specObj.setUrl(url);
                } else if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                    Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                    specObj.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                }
            }
            specObj.setAmt(row.getSettlementAmt());
            specObj.setOriginAmt(row.getPlanAmt());
            specObj.setQty(row.getPlanQuantity());
            return specObj;
        }).toList();
        BigDecimal totalNum = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal discountAmt = BigDecimal.ZERO;
        for (ScpDemandOrderDDTO dto : demandOrderDDTOS) {
            if (dto.getPlanQuantity() != null) {
                totalNum = totalNum.add(dto.getPlanQuantity());
            }
            if (dto.getSettlementAmt() != null) {
                amt = amt.add(dto.getSettlementAmt());
            }
            if (Objects.equals(dto.getPlanAmt(), dto.getSettlementAmt())) continue;
            BigDecimal subtract = dto.getPlanAmt().subtract(dto.getSettlementAmt());
            discountAmt = discountAmt.add(subtract);
        }
        List<AppPayOrderItemRespVO.ItemSpecObjectVO> itemResultList = itemList.stream().filter(d -> StringUtils.isBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<AppPayOrderItemRespVO.ItemSpecObjectVO>> subItemMap = itemList.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.groupingBy(AppPayOrderItemRespVO.ItemSpecObjectVO::getCombineItemCode));
        if (!subItemMap.isEmpty()) {
            subItemMap.forEach((k, v) -> {
                AppPayOrderItemRespVO.ItemSpecObjectVO combineOrderDRespVO = new AppPayOrderItemRespVO.ItemSpecObjectVO();
                combineOrderDRespVO.setCombineItemCode((String)k);
                combineOrderDRespVO.setCombineItemName(((AppPayOrderItemRespVO.ItemSpecObjectVO)v.get(0)).getCombineItemName());
                combineOrderDRespVO.setSubItemList((List<AppPayOrderItemRespVO.ItemSpecObjectVO>)v);
                itemResultList.add(combineOrderDRespVO);
            });
        }
        result.setItemList(itemResultList);
        result.setAmt(amt);
        result.setDiscountAmt(discountAmt);
        result.setTotalNum(totalNum);
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> freightAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        for (ScpDemandOrderDDTO row2 : demandOrderDDTOS) {
            if (row2.getPlanAmt() == null) continue;
            if (row2.getFreightLineFlag().booleanValue()) {
                freightAmt.updateAndGet(v -> v.add(row2.getPlanAmt()));
                continue;
            }
            goodAmt.updateAndGet(v -> v.add(row2.getPlanAmt()));
        }
        result.setGoodAmt(goodAmt.get());
        result.setFreightAmt(freightAmt.get());
        result.setCateNum(demandOrderDDTOS.size());
        return result;
    }

    @Override
    public AppPayOrderItemRespVO findPayOrderItemById(Long id) {
        List<ScpDemandOrderDDTO> demandOrderDDTOS = this.scpDemandOrderDDomainService.findDemandOrderDByMasIdAndProjectFeeFlag(id, false);
        return this.getAppPayOrderItemRespVO(demandOrderDDTOS);
    }

    @Override
    @SysCodeProc
    public List<AppRelateOrderRespVO> findRelateOrderById(Long id) {
        ArrayList<AppRelateOrderRespVO> result = new ArrayList<AppRelateOrderRespVO>();
        List<ScpDemandOrderDDTO> orderDDTOList = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(id);
        if (CollUtil.isEmpty(orderDDTOList)) {
            throw new BusinessException("\u5173\u8054\u5355\u636e\u4e0d\u5b58\u5728");
        }
        Map<String, String> uomCodeMap = this.rmiSysUDCService.getCodeMap("yst-supp", "UOM");
        Map<String, List<ScpDemandOrderDDTO>> orderMap = orderDDTOList.stream().filter(row -> row.getSrcDocId() != null).collect(Collectors.groupingBy(row -> row.getSrcDocNo() + "@" + row.getSaleOuCode()));
        for (Map.Entry<String, List<ScpDemandOrderDDTO>> entry : orderMap.entrySet()) {
            String srcDocNo = entry.getKey().split("@")[0];
            AppRelateOrderRespVO appRelateOrderRespVO = new AppRelateOrderRespVO();
            List<AppRelateOrderRespVO.ItemRespVO> inItemList = entry.getValue().stream().map(row -> {
                AppRelateOrderRespVO.ItemRespVO itemRespVO = new AppRelateOrderRespVO.ItemRespVO();
                itemRespVO.setItemCode(row.getItemCode());
                itemRespVO.setItemName(row.getItemName());
                itemRespVO.setQty(row.getPlanQuantity());
                itemRespVO.setAmt(row.getPlanAmt());
                itemRespVO.setUom(row.getUnit());
                if (uomCodeMap.containsKey(row.getUnit())) {
                    itemRespVO.setUomName((String)uomCodeMap.get(row.getUnit()));
                }
                return itemRespVO;
            }).collect(Collectors.toList());
            appRelateOrderRespVO.setItemList(inItemList);
            ScpDemandOrderDDTO scpDemandOrderDDTO = entry.getValue().get(0);
            String payStatus = this.queryWqfAndUpdatePayStatus(srcDocNo, scpDemandOrderDDTO.getPayStatus(), scpDemandOrderDDTO.getOnlinePayFlag());
            appRelateOrderRespVO.setPayStatus(payStatus);
            appRelateOrderRespVO.setSrcDocNo(srcDocNo);
            appRelateOrderRespVO.setSrcDocId(scpDemandOrderDDTO.getSrcDocId());
            appRelateOrderRespVO.setSrcDocCls(scpDemandOrderDDTO.getSrcDocCls());
            appRelateOrderRespVO.setSaleOuName(scpDemandOrderDDTO.getSaleOuName());
            appRelateOrderRespVO.setSaleOuCode(scpDemandOrderDDTO.getSaleOuCode());
            appRelateOrderRespVO.setCreateTime(scpDemandOrderDDTO.getCreateTime());
            appRelateOrderRespVO.setAmt(inItemList.stream().map(AppRelateOrderRespVO.ItemRespVO::getAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            appRelateOrderRespVO.setPayerName(scpDemandOrderDDTO.getPayerName());
            result.add(appRelateOrderRespVO);
        }
        return result;
    }

    @Override
    public ScpOrderPayRespVO payInfo(String docCls, Long id) {
        List<PurPoPayRpcDTO> purPoPayList;
        List<ScpOrderPayRespVO.PayItem> payItems;
        BigDecimal totalAmt;
        List<InvTroPayRpcDTO> invTroPayList;
        ScpOrderPayRespVO scpOrderPayRespVO = new ScpOrderPayRespVO();
        LocalDateTime createTime = this.scpDemandOrderDDomainService.findDocCreateTimeBySrcDocId(id);
        if (createTime == null) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        scpOrderPayRespVO.setDocDateTime(createTime);
        if ("STKTRO".equals(docCls) && CollUtil.isNotEmpty(invTroPayList = this.rmiInvStkRpcService.payInfo(id))) {
            totalAmt = invTroPayList.stream().map(InvTroPayRpcDTO::getReceiptAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            payItems = ScpDemandOrderConvert.INSTANCE.troDtosToRespVOS(invTroPayList);
            scpOrderPayRespVO.setItemList(payItems);
            scpOrderPayRespVO.setAmt(totalAmt);
            scpOrderPayRespVO.setPayDateTime(invTroPayList.get(0).getReceiptDate());
        }
        if ("PO".equals(docCls) && CollUtil.isNotEmpty(purPoPayList = this.rmiPurRpcService.payInfo(id))) {
            totalAmt = purPoPayList.stream().map(PurPoPayRpcDTO::getReceiptAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            payItems = ScpDemandOrderConvert.INSTANCE.purDtosToRespVOS(purPoPayList);
            scpOrderPayRespVO.setItemList(payItems);
            scpOrderPayRespVO.setAmt(totalAmt);
            scpOrderPayRespVO.setPayDateTime(purPoPayList.get(0).getReceiptDate());
        }
        return scpOrderPayRespVO;
    }

    private Map<String, String> buildAddr(String province, String city, String county) {
        HashSet<String> areaCodes = new HashSet<String>();
        areaCodes.add(province);
        areaCodes.add(city);
        areaCodes.add(county);
        SysAreaQueryDTO comCityCodeRpcDtoParam = new SysAreaQueryDTO();
        comCityCodeRpcDtoParam.setAreaCodes(areaCodes);
        List rpcDtos = (List)this.sysAreaRpcService.queryList(comCityCodeRpcDtoParam).getData();
        if (CollUtil.isNotEmpty((Collection)rpcDtos)) {
            return rpcDtos.stream().collect(Collectors.toMap(SysAreaRespDTO::getAreaCode, SysAreaRespDTO::getAreaName, (t1, t2) -> t1));
        }
        return new HashMap<String, String>();
    }

    @Override
    public Long findIdByCode(String docCode) {
        if (StrUtil.isBlank((CharSequence)docCode)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8ba2\u8d27\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long id = this.scpDemandOrderDomainService.findIdByCode(docCode);
        if (id == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728");
        }
        return id;
    }

    public AppDemandOrderServiceImpl(OrgStoreRpcService orgStoreRpcService, ScpDemandOrderService scpDemandOrderService, ScpDemandOrderDService scpDemandOrderDService, ScpDemandOrderDDomainService scpDemandOrderDDomainService, RmiItemService rmiItemService, CartRedisUtil cartRedisUtil, SysAreaRpcService sysAreaRpcService, RmiSysUDCService rmiSysUDCService, ScpStoreCartService scpStoreCartService, CommonPriceService commonPriceService, RmiInvStkRpcService rmiInvStkRpcService, RmiPurRpcService rmiPurRpcService, MessageQueueTemplate messageQueueTemplate, ScpOrderSettingDomainService scpOrderSettingDomainService, ScpDemandOrderDomainService scpDemandOrderDomainService, RedisUtils redisUtils, MessageDelyQueueService messageDelyQueueService, TransactionCommitHandler transactionCommitHandler, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc, TransactionTemplate transactionTemplate, ScpDemandOrderDRepo scpDemandOrderDRepo, ScpDemandOrderRepo scpDemandOrderRepo, RmiSysUserRpcService rmiSysUserRpcService, ScpDemandSetDomainService scpDemandSetDomainService, ScpsmanInfoRepo scpsmanInfoRepo, SysCacheUserRpcService cacheUserRpcService, RedLockUtils redLockUtils, ScpServiceConfigService scpServiceConfigService) {
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpDemandOrderService = scpDemandOrderService;
        this.scpDemandOrderDService = scpDemandOrderDService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.rmiItemService = rmiItemService;
        this.cartRedisUtil = cartRedisUtil;
        this.sysAreaRpcService = sysAreaRpcService;
        this.rmiSysUDCService = rmiSysUDCService;
        this.scpStoreCartService = scpStoreCartService;
        this.commonPriceService = commonPriceService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.rmiPurRpcService = rmiPurRpcService;
        this.messageQueueTemplate = messageQueueTemplate;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.redisUtils = redisUtils;
        this.messageDelyQueueService = messageDelyQueueService;
        this.transactionCommitHandler = transactionCommitHandler;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
        this.transactionTemplate = transactionTemplate;
        this.scpDemandOrderDRepo = scpDemandOrderDRepo;
        this.scpDemandOrderRepo = scpDemandOrderRepo;
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.scpDemandSetDomainService = scpDemandSetDomainService;
        this.scpsmanInfoRepo = scpsmanInfoRepo;
        this.cacheUserRpcService = cacheUserRpcService;
        this.redLockUtils = redLockUtils;
        this.scpServiceConfigService = scpServiceConfigService;
    }
}

