/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.template;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.cart.CartAddItemParamVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartSaveVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderApplyFailureRespVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderApplyParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderApplyRespVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderApplySuccessRespVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderDeleteParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderDetailQueryVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderDetailRespVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderListParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderListRespVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderLoadParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderPageQueryVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderPageRespVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderSaveParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderStatusChangeParamVO;
import com.elitesland.scp.application.facade.vo.template.ScpDemandTemplateExportParamVO;
import com.elitesland.scp.application.facade.vo.template.ScpDemandTemplateExportRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.authority.StoreAuthorityService;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.template.DemandOrderTemplateService;
import com.elitesland.scp.application.service.template.TemplateApplyCartContext;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.app.ScpStoreItemConvert;
import com.elitesland.scp.domain.entity.template.ScpTemplateOrder;
import com.elitesland.scp.domain.entity.template.ScpTemplateOrderDO;
import com.elitesland.scp.domain.entity.template.ScpTemplateSetDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.item.ScpCateItemDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.authority.StoreAuthorityRespDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcDTO;
import com.elitesland.scp.enums.DayOfWeekEnumHelper;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.template.ScpDemandOrderTemplateRepo;
import com.elitesland.scp.infr.repo.template.ScpDemandOrderTemplateRepoProc;
import com.elitesland.scp.infr.repo.template.ScpDemandTemplateSetRepo;
import com.elitesland.scp.infr.repo.template.ScpDemandTemplateSetRepoProc;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiPriceRpcService;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.service.authority.StoreAuthorityRpcService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DemandOrderTemplateServiceImpl
implements DemandOrderTemplateService {
    private static final Logger log = LoggerFactory.getLogger(DemandOrderTemplateServiceImpl.class);
    private final ScpDemandOrderTemplateRepo scpDemandOrderTemplateRepo;
    private final ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc;
    private final ScpDemandTemplateSetRepo scpDemandTemplateSetRepo;
    private final ScpDemandTemplateSetRepoProc scpDemandTemplateSetRepoProc;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final RmiSysUDCService rmiSysUDCService;
    private final StoreAuthorityRpcService storeAuthorityRpcService;
    private final RmiItemService rmiItemService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiPriceRpcService rmiPriceRpcService;
    private final RmiSalRpcService rmiSalRpcService;
    private final ScpCateItemDomainService scpCateItemDomainService;
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final StoreAuthorityService storeAuthorityService;
    private final CartRedisUtil cartRedisUtil;
    private final ScpStoreCartService scpStoreCartService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;

    @Override
    @SysCodeProc
    public DemandOrderDetailRespVO detail(DemandOrderDetailQueryVO vo) {
        DemandOrderDetailRespVO respVO = new DemandOrderDetailRespVO();
        respVO.setId(vo.getId());
        Optional templateSetRepoById = this.scpDemandTemplateSetRepo.findById(vo.getId());
        if (templateSetRepoById.isEmpty()) {
            return null;
        }
        ScpTemplateSetDO templateSetDO = (ScpTemplateSetDO)((Object)templateSetRepoById.get());
        respVO.setRemark(templateSetDO.getRemark());
        respVO.setDemandTemCode(templateSetDO.getDemandTemCode());
        respVO.setDemandTemName(templateSetDO.getDemandTemName());
        respVO.setDetailedTime(templateSetDO.getDetailedTime());
        respVO.setStartDate(templateSetDO.getStartDate());
        respVO.setEndDate(templateSetDO.getEndDate());
        respVO.setDemandTemStatus(templateSetDO.getDemandTemStatus());
        respVO.setDocType(templateSetDO.getDocType());
        respVO.setBusinessType(templateSetDO.getBusinessType());
        respVO.setType(templateSetDO.getType());
        List<ScpTemplateOrderDO> orderData = this.scpDemandOrderTemplateRepoProc.findByMasId(vo.getId());
        if (CollUtil.isEmpty(orderData)) {
            return respVO;
        }
        List<String> settings = this.scpOrderSettingDomainService.findItemCatesByBusinessType(templateSetDO.getBusinessType(), templateSetDO.getType());
        if (CollUtil.isNotEmpty(settings)) {
            respVO.setItemCates(settings);
        }
        List<ScpTemplateOrderDO> removeDuplicatesByWhStZoCode = this.removeDuplicatesByWhStZoCode(orderData);
        List<DemandOrderDetailRespVO.WhStZoObject> whStZoObjects = removeDuplicatesByWhStZoCode.stream().map(order -> {
            DemandOrderDetailRespVO.WhStZoObject whStZoObject = new DemandOrderDetailRespVO.WhStZoObject();
            if (order.getType() != null) {
                whStZoObject.setType(order.getType().toString());
            }
            if (order.getType() != null) {
                whStZoObject.setTypeName(this.getTypeName(whStZoObject.getType()));
            }
            whStZoObject.setWhStZoId(order.getWhStZoId());
            whStZoObject.setWhStZoCode(order.getWhStZoCode());
            whStZoObject.setWhStZoName(order.getWhStZoName());
            whStZoObject.setDetailedAddress(order.getDetailedAddress());
            whStZoObject.setBelongOrgCode(order.getBelongOrgCode());
            whStZoObject.setBelongOrgName(order.getBelongOrgName());
            whStZoObject.setBelongOuCode(order.getBelongOuCode());
            whStZoObject.setBelongOuName(order.getBelongOuName());
            whStZoObject.setStoreType(order.getStoreType());
            if (StrUtil.isNotBlank((CharSequence)order.getStoreType())) {
                whStZoObject.setStoreTypeName(this.getStoreTypeName(order.getStoreType()));
            }
            return whStZoObject;
        }).collect(Collectors.toList());
        respVO.setWhStZoObjects(whStZoObjects);
        List<ScpTemplateOrderDO> removeDuplicatesByItemCode = this.removeDuplicatesByItemCode(orderData);
        List<DemandOrderDetailRespVO.ItemObject> itemObjects = removeDuplicatesByItemCode.stream().map(order -> {
            DemandOrderDetailRespVO.ItemObject itemObject = new DemandOrderDetailRespVO.ItemObject();
            itemObject.setItemId(order.getItemId());
            itemObject.setItemCode(order.getItemCode());
            itemObject.setItemName(order.getItemName());
            itemObject.setItemCateCode(order.getItemCateCode());
            itemObject.setItemCateName(order.getItemCateName());
            itemObject.setItemSpec(order.getItemSpec());
            itemObject.setBasicUnitMeasure(order.getBasicUnitMeasure());
            itemObject.setBasicUnitMeasureName(order.getBasicUnitMeasureName());
            itemObject.setWeight(SysUtils.processQtyScale(order.getWeight()));
            itemObject.setDemandQuantity(SysUtils.processQtyScale(order.getDemandQuantity()));
            itemObject.setTotalWeight(SysUtils.processQtyScale(order.getTotalWeight()));
            itemObject.setWeightUom(order.getWeightUom());
            itemObject.setWeightUomName(order.getWeightUomName());
            itemObject.setUom2(order.getUom2());
            itemObject.setUom2Name(order.getUom2Name());
            itemObject.setQty2(order.getQty2());
            itemObject.setUomRatio(order.getUomRatio());
            itemObject.setDecimalPlaces(order.getDecimalPlaces());
            return itemObject;
        }).collect(Collectors.toList());
        respVO.setItemObjects(itemObjects);
        return respVO;
    }

    private String getRegionName(String regionCode) {
        Map<String, String> regionMap = this.rmiSysUDCService.getCodeMap("yst-supp", "REGION");
        return regionMap.get(regionCode);
    }

    private String getTypeName(String type) {
        Map<String, String> templateOrderType = this.rmiSysUDCService.getCodeMap("yst-suplan", "TEMPLATE_ORDER_TYPE");
        return templateOrderType.get(type);
    }

    private String getDocTypeName(String docType) {
        Map<String, String> templateOrderType = this.rmiSysUDCService.getCodeMap("yst-suplan", "OB_DOC_TYPE");
        return templateOrderType.get(docType);
    }

    private String getStoreTypeName(String storeType) {
        Map<String, String> storeType2 = this.rmiSysUDCService.getCodeMap("yst-supp", "STORE_TYPE2");
        return storeType2.get(storeType);
    }

    public List<ScpTemplateOrderDO> removeDuplicatesByWhStZoCode(List<ScpTemplateOrderDO> orderData) {
        return orderData.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getWhStZoCode())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ScpTemplateOrderDO>(Comparator.comparing(ScpTemplateOrderDO::getWhStZoCode))), ArrayList::new));
    }

    public List<ScpTemplateOrderDO> removeDuplicatesByItemCode(List<ScpTemplateOrderDO> orderData) {
        return orderData.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getItemCode())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ScpTemplateOrderDO>(Comparator.comparing(ScpTemplateOrderDO::getItemCode))), ArrayList::new));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(DemandOrderSaveParamVO vo) {
        if (vo.getId() == null) {
            String demandTemCode = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("BKTE", new ArrayList<String>());
            vo.setDemandTemCode(demandTemCode);
        }
        ScpTemplateSetDO scpTemplateSetDO = new ScpTemplateSetDO();
        scpTemplateSetDO.setId(vo.getId());
        scpTemplateSetDO.setDemandTemCode(vo.getDemandTemCode());
        scpTemplateSetDO.setDemandTemName(vo.getDemandTemName());
        scpTemplateSetDO.setStartDate(vo.getStartDate());
        scpTemplateSetDO.setEndDate(vo.getEndDate());
        scpTemplateSetDO.setDetailedTime(vo.getDetailedTime());
        scpTemplateSetDO.setDemandTemStatus(vo.getDemandTemStatus());
        scpTemplateSetDO.setRemark(vo.getRemark());
        scpTemplateSetDO.setDocType(vo.getDocType());
        scpTemplateSetDO.setType(vo.getType());
        scpTemplateSetDO = (ScpTemplateSetDO)((Object)this.scpDemandTemplateSetRepo.save((Object)scpTemplateSetDO));
        if (vo.getId() != null) {
            log.info("\u7f16\u8f91\u64cd\u4f5c,\u5148\u5220\u9664\u65e2\u6709\u660e\u7ec6,masId:{}", (Object)vo.getId());
            this.scpDemandOrderTemplateRepoProc.deleteByMasId(vo.getId());
        }
        ArrayList<ScpTemplateOrderDO> entities = new ArrayList<ScpTemplateOrderDO>();
        HashSet<String> used = new HashSet<String>();
        if (CollUtil.isNotEmpty(vo.getWhStZoObjects())) {
            for (DemandOrderSaveParamVO.WhStZoObject whStZoObject : vo.getWhStZoObjects()) {
                if (used.contains(whStZoObject.getWhStZoCode())) continue;
                ScpTemplateOrderDO scpTemplateOrderDO = new ScpTemplateOrderDO();
                scpTemplateOrderDO.setMasId(scpTemplateSetDO.getId());
                scpTemplateOrderDO.setType(whStZoObject.getType());
                scpTemplateOrderDO.setWhStZoId(whStZoObject.getWhStZoId());
                scpTemplateOrderDO.setWhStZoCode(whStZoObject.getWhStZoCode());
                scpTemplateOrderDO.setWhStZoName(whStZoObject.getWhStZoName());
                scpTemplateOrderDO.setDetailedAddress(whStZoObject.getDetailedAddress());
                scpTemplateOrderDO.setBelongOrgCode(whStZoObject.getBelongOrgCode());
                scpTemplateOrderDO.setBelongOrgName(whStZoObject.getBelongOrgName());
                scpTemplateOrderDO.setBelongOuCode(whStZoObject.getBelongOuCode());
                scpTemplateOrderDO.setBelongOuName(whStZoObject.getBelongOuName());
                scpTemplateOrderDO.setStoreType(whStZoObject.getStoreType());
                entities.add(scpTemplateOrderDO);
                used.add(whStZoObject.getWhStZoCode());
            }
        }
        HashMap itemMap = new HashMap();
        if (CollUtil.isNotEmpty(vo.getItemObjects())) {
            Map<String, List<DemandOrderSaveParamVO.ItemObject>> itemCodeMap = vo.getItemObjects().stream().collect(Collectors.groupingBy(DemandOrderSaveParamVO.ItemObject::getItemCode));
            for (Map.Entry<String, List<DemandOrderSaveParamVO.ItemObject>> entry : itemCodeMap.entrySet()) {
                BigDecimal qtySum = entry.getValue().stream().map(DemandOrderSaveParamVO.ItemObject::getDemandQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                qtySum = SysUtils.processQtyScale(qtySum);
                DemandOrderSaveParamVO.ItemObject itemObject = entry.getValue().get(0);
                String itemCode = itemObject.getItemCode();
                if (StrUtil.isBlank((CharSequence)itemObject.getItemCateCode())) {
                    throw new BusinessException(itemCode + "\u5bf9\u5e94\u7684\u5546\u54c1\u54c1\u7c7b\u7f16\u7801\u4e3a\u7a7a");
                }
                ScpTemplateOrderDO scpTemplateOrderDO = new ScpTemplateOrderDO();
                scpTemplateOrderDO.setMasId(scpTemplateSetDO.getId());
                scpTemplateOrderDO.setItemId(itemObject.getItemId());
                scpTemplateOrderDO.setItemCode(itemCode);
                scpTemplateOrderDO.setItemName(itemObject.getItemName());
                scpTemplateOrderDO.setItemCateCode(itemObject.getItemCateCode());
                scpTemplateOrderDO.setItemCateName(itemObject.getItemCateName());
                scpTemplateOrderDO.setItemSpec(itemObject.getItemSpec());
                scpTemplateOrderDO.setBasicUnitMeasure(itemObject.getBasicUnitMeasure());
                scpTemplateOrderDO.setBasicUnitMeasureName(itemObject.getBasicUnitMeasureName());
                scpTemplateOrderDO.setWeight(SysUtils.processQtyScale(itemObject.getWeight()));
                scpTemplateOrderDO.setDemandQuantity(qtySum);
                scpTemplateOrderDO.setTotalWeight(SysUtils.processQtyScale(itemObject.getTotalWeight()));
                scpTemplateOrderDO.setWeightUom(itemObject.getWeightUom());
                scpTemplateOrderDO.setWeightUomName(itemObject.getWeightUomName());
                scpTemplateOrderDO.setUom2(itemObject.getUom2());
                scpTemplateOrderDO.setUom2Name(itemObject.getUom2Name());
                scpTemplateOrderDO.setUomRatio(itemObject.getUomRatio());
                scpTemplateOrderDO.setQty2(itemObject.getQty2());
                scpTemplateOrderDO.setDecimalPlaces(itemObject.getDecimalPlaces());
                entities.add(scpTemplateOrderDO);
            }
        }
        if (CollUtil.isNotEmpty(entities)) {
            this.scpDemandOrderTemplateRepo.saveAll(entities);
        }
        return scpTemplateSetDO.getId();
    }

    @Override
    @SysCodeProc
    public PagingVO<DemandOrderPageRespVO> page(DemandOrderPageQueryVO vo) {
        if (Boolean.TRUE.equals(vo.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> pagingVO = this.getAuthorityPageRespVOPagingVO();
            if (pagingVO.isEmpty()) {
                return new PagingVO();
            }
            this.extractedAuthorityParam(vo, pagingVO);
            List<ScpTemplateOrder> scpTemplateOrders = this.scpDemandOrderTemplateRepoProc.findMasIdsByWhStZoIds(vo.getStoreIds(), vo.getWhIds());
            if (CollectionUtil.isEmpty(scpTemplateOrders)) {
                return new PagingVO();
            }
            vo.setIds(scpTemplateOrders.stream().map(ScpTemplateOrder::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }
        PagingVO<DemandOrderPageRespVO> data = this.scpDemandTemplateSetRepoProc.findTemplateSet(vo);
        List records = data.getRecords();
        List<Long> templateIds = records.stream().map(DemandOrderPageRespVO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderList = this.scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIds);
        Map<Long, BigDecimal> itemTypeMap = this.sumItemCodes(orderList);
        records.forEach(item -> item.setTypeNumber((BigDecimal)itemTypeMap.get(item.getId())));
        return data;
    }

    public Map<Long, BigDecimal> sumItemCodes(List<ScpTemplateOrderDO> orderData) {
        List filteredList = orderData.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getItemCode())).collect(Collectors.toList());
        HashMap<Long, Set> itemCodesMap = new HashMap<Long, Set>();
        HashMap<Long, BigDecimal> sumItemCodesMap = new HashMap<Long, BigDecimal>();
        for (ScpTemplateOrderDO order : filteredList) {
            Long masId = order.getMasId();
            String itemCode = order.getItemCode();
            if (itemCodesMap.containsKey(masId) && ((Set)itemCodesMap.get(masId)).contains(itemCode)) continue;
            BigDecimal sum = sumItemCodesMap.getOrDefault(masId, BigDecimal.ZERO);
            sum = sum.add(BigDecimal.ONE);
            sumItemCodesMap.put(masId, sum);
            Set itemCodes = itemCodesMap.getOrDefault(masId, new HashSet());
            itemCodes.add(itemCode);
            itemCodesMap.put(masId, itemCodes);
        }
        return sumItemCodesMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusChange(DemandOrderStatusChangeParamVO vo) {
        this.scpDemandTemplateSetRepoProc.updateStatus(vo.getDemandTemStatus(), vo.getIds());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(DemandOrderDeleteParamVO vo) {
        this.scpDemandTemplateSetRepoProc.delete(vo.getIds());
    }

    @Override
    public PagingVO<DemandOrderPageRespVO> load(DemandOrderLoadParamVO vo) {
        OrgStoreDetailRpcDTO storeDetailRpcDTO;
        log.info("\u52a0\u8f7d\u6a21\u677f\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)((Object)vo)));
        List<DemandOrderPageRespVO> templateSetLoad = this.scpDemandTemplateSetRepoProc.findTemplateSetLoad(vo);
        log.info("\u52a0\u8f7d\u6a21\u677f\u67e5\u8be2\u7ed3\u679c,\u8fc7\u6ee4\u524d:{}", (Object)JSONUtil.toJsonStr(templateSetLoad));
        templateSetLoad = templateSetLoad.stream().filter(e -> this.detailedTimeContainsDay(e.getDetailedTime())).collect(Collectors.toList());
        log.info("\u52a0\u8f7d\u6a21\u677f\u67e5\u8be2\u7ed3\u679c,\u8fc7\u6ee4\u8be6\u7ec6\u65e5\u671f\u540e:{}", (Object)JSONUtil.toJsonStr(templateSetLoad));
        String demandWhStCode = vo.getDemandWhStCode();
        String type = vo.getType();
        boolean isStore = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type);
        String region = "";
        if (isStore && (storeDetailRpcDTO = this.rmiOrgStoreRpcService.findOrgStoreByStoreCode(demandWhStCode)) != null) {
            region = storeDetailRpcDTO.getRegion();
        }
        List<Long> templateIds = templateSetLoad.stream().map(DemandOrderPageRespVO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderList = this.scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIds);
        List tempIdsByType = orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(demandWhStCode)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        List<Object> tempIdsByRegion = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)region) && isStore) {
            String finalRegion = region;
            tempIdsByRegion = orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(finalRegion)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        }
        List<Object> expected = new ArrayList<Object>();
        expected.addAll(tempIdsByType);
        expected.addAll(tempIdsByRegion);
        List<Object> finalExpected = expected = expected.stream().distinct().collect(Collectors.toList());
        List<DemandOrderPageRespVO> filterData = templateSetLoad.stream().filter(e -> finalExpected.contains(e.getId())).collect(Collectors.toList());
        log.info("\u52a0\u8f7d\u6a21\u677f\u67e5\u8be2\u7ed3\u679c,\u8fc7\u6ee4\u540e:{}", (Object)JSONUtil.toJsonStr(filterData));
        List<DemandOrderPageRespVO> records = DemandOrderTemplateServiceImpl.toPage(vo.getCurrent(), vo.getSize(), filterData);
        return PagingVO.builder().total((long)filterData.size()).records(records).build();
    }

    private boolean detailedTimeContainsDay(String detailedTimeStr) {
        DayOfWeek dayOfWeek = LocalDate.now().getDayOfWeek();
        String dayOfWeekStr = dayOfWeek.toString();
        List list = DayOfWeekEnumHelper.splitAndList((String)detailedTimeStr);
        return list.contains(dayOfWeekStr);
    }

    @Override
    public List<DemandOrderListRespVO> list(DemandOrderListParamVO vo) {
        OrgStoreDetailRpcDTO storeDetailRpcDTO;
        log.info("\u9009\u62e9\u6a21\u677f\u5217\u8868\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)vo));
        List<DemandOrderListRespVO> templateSetList = this.scpDemandTemplateSetRepoProc.findTemplateSetList(vo);
        log.info("\u9009\u62e9\u6a21\u677f\u5217\u8868\u7ed3\u679c,\u8fc7\u6ee4\u524d:{}", (Object)JSONUtil.toJsonStr(templateSetList));
        templateSetList = templateSetList.stream().filter(e -> this.detailedTimeContainsDay(e.getDetailedTime())).collect(Collectors.toList());
        log.info("\u9009\u62e9\u6a21\u677f\u5217\u8868\u7ed3\u679c,\u8fc7\u6ee4\u8be6\u7ec6\u65e5\u671f\u540e:{}", (Object)JSONUtil.toJsonStr(templateSetList));
        String demandWhStCode = vo.getDemandWhStCode();
        String type = vo.getType();
        boolean isStore = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type);
        String region = "";
        if (isStore && (storeDetailRpcDTO = this.rmiOrgStoreRpcService.findOrgStoreByStoreCode(demandWhStCode)) != null) {
            region = storeDetailRpcDTO.getRegion();
        }
        List<Long> templateIds = templateSetList.stream().map(DemandOrderListRespVO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderList = this.scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIds);
        List tempIdsByType = orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(demandWhStCode)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        List<Object> tempIdsByRegion = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)region) && isStore) {
            String finalRegion = region;
            tempIdsByRegion = orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(finalRegion)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        }
        List<Object> expected = new ArrayList<Object>();
        expected.addAll(tempIdsByType);
        expected.addAll(tempIdsByRegion);
        List<Object> finalExpected = expected = expected.stream().distinct().collect(Collectors.toList());
        List<DemandOrderListRespVO> filterData = templateSetList.stream().filter(e -> finalExpected.contains(e.getId())).collect(Collectors.toList());
        log.info("\u52a0\u8f7d\u6a21\u677f\u67e5\u8be2\u7ed3\u679c,\u8fc7\u6ee4\u540e:{}", (Object)JSONUtil.toJsonStr(filterData));
        if (CollUtil.isEmpty(filterData)) {
            return filterData;
        }
        List<Long> templateIdsFiltered = filterData.stream().map(DemandOrderListRespVO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderListFiltered = this.scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIdsFiltered);
        Map<Long, BigDecimal> itemTypeMap = this.sumItemCodes(orderListFiltered);
        filterData.forEach(item -> item.setTypeNumber((BigDecimal)itemTypeMap.get(item.getId())));
        return filterData;
    }

    public static List<DemandOrderPageRespVO> toPage(int page, int size, List<DemandOrderPageRespVO> list) {
        int fromIndex = page * size;
        int toIndex = page * size + size;
        if (fromIndex > list.size()) {
            return new ArrayList<DemandOrderPageRespVO>();
        }
        if (toIndex >= list.size()) {
            return list.subList(fromIndex, list.size());
        }
        return list.subList(fromIndex, toIndex);
    }

    @Override
    public DemandOrderApplyRespVO apply(DemandOrderApplyParamVO vo) {
        log.info("\u5e94\u7528\u6a21\u677f\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)vo));
        String demandWhStCode = vo.getDemandWhStCode();
        String type = vo.getType();
        boolean isStore = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type);
        DemandOrderApplyRespVO result = new DemandOrderApplyRespVO();
        List orderTemList = this.scpDemandOrderTemplateRepoProc.findByMasIdIn(vo.getIds()).stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getItemCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(orderTemList)) {
            return this.buildDefaultResult();
        }
        log.info("\u6a21\u677f\u5e94\u7528,\u5546\u54c1\u8be6\u60c5\u6570\u636e{}", (Object)JSONUtil.toJsonStr(orderTemList));
        HashMap<String, DemandOrderApplySuccessRespVO> successMap = new HashMap<String, DemandOrderApplySuccessRespVO>();
        ArrayList<DemandOrderApplyFailureRespVO> fail = new ArrayList<DemandOrderApplyFailureRespVO>();
        List<Object> itemCodePermittedList = new ArrayList();
        if (isStore) {
            List<StoreAuthorityRespDTO.ItemInfo> itemsByStoreCode = this.getPermitedItemsByStoreCode(demandWhStCode);
            itemCodePermittedList = itemsByStoreCode.stream().map(StoreAuthorityRespDTO.ItemInfo::getItemCode).distinct().collect(Collectors.toList());
        }
        log.info("\u95e8\u5e97\u8981\u8d27\u6743\u9650\u5546\u54c1\u7f16\u7801\u96c6\u5408{}", (Object)JSONUtil.toJsonStr(itemCodePermittedList));
        List<String> itemCodeList = orderTemList.stream().map(ScpTemplateOrderDO::getItemCode).distinct().collect(Collectors.toList());
        List<String> existItemCodes = this.scpCateItemDomainService.existByItemCodes(itemCodeList);
        log.info("\u5c0f\u7a0b\u5e8f\u4e0a\u67b6\u7684\u5546\u54c1{}", (Object)JSONUtil.toJsonStr(existItemCodes));
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(vo.getBusinessType(), type);
        List<AppItemActivityItemPriceParamVO> priceParamVOS = orderTemList.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom2());
            return priceParamVO;
        }).collect(Collectors.toList());
        Map<String, AppItemPriceRespVO> priceMap = this.commonPriceService.getNewPriceAndStockDetails(priceParamVOS, demandWhStCode, orderSetting, type);
        for (ScpTemplateOrderDO templateOrderDO : orderTemList) {
            String itemCode = templateOrderDO.getItemCode();
            String itemName = templateOrderDO.getItemName();
            if ("BOH".equals(vo.getInvoker()) && !existItemCodes.contains(itemCode)) {
                this.addFail(fail, itemCode, itemName, "\u8be5\u5546\u54c1\u4e0d\u5c5e\u4e8e\u5c0f\u7a0b\u5e8f\u5546\u54c1");
                continue;
            }
            if (!priceMap.containsKey(itemCode)) {
                this.addFail(fail, itemCode, itemName, "\u8be5\u5546\u54c1\u6ca1\u6709\u7ed3\u7b97\u4ef7");
                continue;
            }
            if (!itemCodePermittedList.contains(itemCode) && isStore) {
                this.addFail(fail, itemCode, itemName, "\u95e8\u5e97\u8981\u8d27\u6743\u9650\u4e0d\u5305\u542b");
                continue;
            }
            this.addSuccess(successMap, templateOrderDO, null);
        }
        ArrayList<DemandOrderApplySuccessRespVO> success = new ArrayList<DemandOrderApplySuccessRespVO>(successMap.values());
        this.processItemInfo(success);
        result.setSuccess(success);
        result.setFail(fail);
        if (success.size() == 0) {
            result.setAllFailed(true);
        }
        log.info("\u5e94\u7528\u6a21\u677f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)result));
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DemandOrderApplyRespVO applyCart(DemandOrderApplyParamVO vo) {
        String demandWhStCode = vo.getDemandWhStCode();
        vo.setInvoker("BOH");
        TemplateApplyCartContext context = new TemplateApplyCartContext();
        DemandOrderApplyRespVO respVO = this.applyBOH(vo, context);
        List<DemandOrderApplySuccessRespVO> success = respVO.getSuccess();
        if (CollUtil.isEmpty(success)) {
            return respVO;
        }
        log.info("\u5c0f\u7a0b\u5e8f\u6a21\u677f\u8fc7\u6ee4\u6210\u529f\u5546\u54c1\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(success));
        CartAddItemParamVO cartAddItemParamVO = this.formatToCartAdd(success, demandWhStCode, context.getPriceMap());
        log.info("\u5c0f\u7a0b\u5e8f\u6a21\u677f\u5546\u54c1\u6dfb\u52a0\u91c7\u8d2d\u8f66\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)cartAddItemParamVO));
        Long currentUserId = UserService.currentUserId();
        this.cartRedisUtil.updateUnSelectedStoreCartItems(vo.getDemandWhStCode(), currentUserId, vo.getDocType());
        List<StoreCartSaveVO> saveVOS = ScpStoreItemConvert.INSTANCE.paramVosToSaveVos(cartAddItemParamVO.getItemSpecObjectVOS());
        this.scpStoreCartService.batchSaveCart(demandWhStCode, vo.getDocType(), saveVOS);
        return respVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandTemplateExportRespVO> queryTemplateExport(ScpDemandTemplateExportParamVO vo) {
        ArrayList<ScpDemandTemplateExportRespVO> resultVoList = new ArrayList<ScpDemandTemplateExportRespVO>();
        PagingVO<ScpDemandTemplateExportRespVO> data = this.scpDemandTemplateSetRepoProc.findTemplateSetExport(vo);
        List records = data.getRecords();
        Map templateHeaderData = records.stream().collect(Collectors.toMap(ScpDemandTemplateExportRespVO::getId, Function.identity()));
        List<Long> templateIds = records.stream().map(ScpDemandTemplateExportRespVO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderList = this.scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIds);
        Map<Long, List<ScpTemplateOrderDO>> groupedTemplateDetail = orderList.stream().collect(Collectors.groupingBy(ScpTemplateOrderDO::getMasId));
        Map<Long, BigDecimal> itemTypeMap = this.sumItemCodes(orderList);
        records.forEach(item -> item.setTypeNumber((BigDecimal)itemTypeMap.get(item.getId())));
        for (Map.Entry<Long, List<ScpTemplateOrderDO>> entry : groupedTemplateDetail.entrySet()) {
            Long templateId = entry.getKey();
            ScpDemandTemplateExportRespVO templateHeader = (ScpDemandTemplateExportRespVO)templateHeaderData.get(templateId);
            List<ScpTemplateOrderDO> templateOrderDOS = entry.getValue();
            for (ScpTemplateOrderDO templateOrderDO : templateOrderDOS) {
                ScpDemandTemplateExportRespVO resultVo = new ScpDemandTemplateExportRespVO();
                resultVo.setId(templateHeader.getId());
                resultVo.setDemandTemCode(templateHeader.getDemandTemCode());
                resultVo.setDemandTemName(templateHeader.getDemandTemName());
                resultVo.setDocType(templateHeader.getDocType());
                resultVo.setDocTypeName(this.getDocTypeName(templateHeader.getDocType()));
                resultVo.setDemandType(templateHeader.getDemandType());
                resultVo.setStartDate(templateHeader.getStartDate());
                resultVo.setEndDate(templateHeader.getEndDate());
                if (StrUtil.isNotBlank((CharSequence)templateHeader.getDetailedTime())) {
                    resultVo.setDetailedTime(DayOfWeekEnumHelper.splitAndListDesc((String)templateHeader.getDetailedTime()));
                }
                resultVo.setDemandTemStatus(templateHeader.getDemandTemStatus());
                resultVo.setDemandTemStatusName(this.getStatusName(templateHeader.getDemandTemStatus()));
                resultVo.setTypeNumber(templateHeader.getTypeNumber());
                resultVo.setCreator(templateHeader.getCreator());
                resultVo.setCreateTime(templateHeader.getCreateTime());
                resultVo.setRemark(templateHeader.getRemark());
                if (templateOrderDO.getType() != null) {
                    resultVo.setType(templateOrderDO.getType().toString());
                }
                if (templateOrderDO.getType() != null) {
                    resultVo.setTypeName(this.getTypeName(resultVo.getType()));
                }
                resultVo.setWhStZoId(templateOrderDO.getWhStZoId());
                resultVo.setWhStZoCode(templateOrderDO.getWhStZoCode());
                resultVo.setWhStZoName(templateOrderDO.getWhStZoName());
                resultVo.setDetailedAddress(templateOrderDO.getDetailedAddress());
                resultVo.setBelongOrgCode(templateOrderDO.getBelongOrgCode());
                resultVo.setBelongOrgName(templateOrderDO.getBelongOrgName());
                resultVo.setBelongOuCode(templateOrderDO.getBelongOuCode());
                resultVo.setBelongOuName(templateOrderDO.getBelongOuName());
                resultVo.setStoreType(templateOrderDO.getStoreType());
                if (StrUtil.isNotBlank((CharSequence)templateOrderDO.getStoreType())) {
                    resultVo.setStoreTypeName(this.getStoreTypeName(templateOrderDO.getStoreType()));
                }
                resultVo.setItemId(templateOrderDO.getItemId());
                resultVo.setItemCode(templateOrderDO.getItemCode());
                resultVo.setItemName(templateOrderDO.getItemName());
                resultVo.setItemCateCode(templateOrderDO.getItemCateCode());
                resultVo.setItemCateName(templateOrderDO.getItemCateName());
                resultVo.setItemSpec(templateOrderDO.getItemSpec());
                resultVo.setBasicUnitMeasure(templateOrderDO.getBasicUnitMeasure());
                if (templateOrderDO.getWeight() != null) {
                    resultVo.setWeight(SysUtils.processQtyScale(templateOrderDO.getWeight()) + this.getUomName(templateOrderDO.getWeightUomName()));
                }
                resultVo.setWeightUom(templateOrderDO.getWeightUom());
                resultVo.setWeightUomName(templateOrderDO.getWeightUomName());
                resultVo.setDemandQuantity(templateOrderDO.getDemandQuantity());
                if (templateOrderDO.getTotalWeight() != null) {
                    resultVo.setTotalWeight(SysUtils.processQtyScale(templateOrderDO.getTotalWeight()) + this.getUomName(templateOrderDO.getWeightUomName()));
                }
                resultVoList.add(resultVo);
            }
        }
        int total = this.getPageTotal(vo);
        log.info("\u8ba2\u8d27\u6a21\u677f\u5bfc\u51fa,total:{},resultVoList:{}", (Object)total, (Object)JSONUtil.toJsonStr(resultVoList));
        return PagingVO.builder().total((long)total).records(resultVoList).build();
    }

    private String getStatusName(Integer status) {
        if (1 == status) {
            return "\u542f\u7528";
        }
        if (0 == status) {
            return "\u7981\u7528";
        }
        return "N/A";
    }

    private String getUomName(String uomName) {
        if (uomName == null) {
            return "";
        }
        return uomName;
    }

    private int getPageTotal(ScpDemandTemplateExportParamVO vo) {
        List<Long> ids = vo.getIds();
        if (CollUtil.isEmpty(ids)) {
            List<ScpTemplateOrderDO> orderList = this.scpDemandOrderTemplateRepoProc.findALL();
            return orderList.size();
        }
        List<ScpTemplateOrderDO> orderList = this.scpDemandOrderTemplateRepoProc.findByMasIdIn(ids);
        return orderList.size();
    }

    private CartAddItemParamVO formatToCartAdd(List<DemandOrderApplySuccessRespVO> success, String demandWhStCode, Map<String, AppItemPriceRespVO> priceMap) {
        CartAddItemParamVO cartAddItemParamVO = new CartAddItemParamVO();
        log.info("\u4ef7\u683c\u5b57\u5178\u6570\u636e:{}", (Object)JSONUtil.toJsonStr(priceMap));
        List itemsOneSpec = success.stream().filter(e -> "1".equals(e.getItemAttr2())).map(DemandOrderApplySuccessRespVO::getSpuId).distinct().collect(Collectors.toList());
        log.info("\u5355\u89c4\u683c\u5546\u54c1spuId:{}", (Object)JSONUtil.toJsonStr(itemsOneSpec));
        List itemsMulSpec = success.stream().filter(e -> "0".equals(e.getItemAttr2())).map(DemandOrderApplySuccessRespVO::getItemId).distinct().collect(Collectors.toList());
        log.info("\u591a\u89c4\u683c\u5546\u54c1itemId:{}", (Object)JSONUtil.toJsonStr(itemsMulSpec));
        Map<Object, Object> skuImgByItemIdsOneSpec = new HashMap();
        Map<Object, Object> skuImgByItemIdsMulSpec = new HashMap();
        ArrayList<Long> itemIdTotal = new ArrayList<Long>();
        itemIdTotal.addAll(itemsOneSpec);
        itemIdTotal.addAll(itemsMulSpec);
        log.info("\u6240\u6709\u6821\u9a8c\u6210\u529f\u5546\u54c1itemId:{}", (Object)JSONUtil.toJsonStr(itemIdTotal));
        List<ItmItemAttachmentProviderDTO> list = this.rmiItemService.findSkuImgByItemIds(itemIdTotal);
        if (CollUtil.isNotEmpty(list)) {
            skuImgByItemIdsOneSpec = list.stream().filter(e -> itemsOneSpec.contains(e.getItemId())).collect(Collectors.toMap(ItmItemAttachmentProviderDTO::getItemId, Function.identity(), (oldValue, newValue) -> oldValue));
            skuImgByItemIdsMulSpec = list.stream().filter(e -> itemsMulSpec.contains(e.getItemId())).collect(Collectors.toMap(ItmItemAttachmentProviderDTO::getItemId, Function.identity(), (oldValue, newValue) -> oldValue));
        }
        log.info("\u5355\u89c4\u683c\u5546\u54c1Map:{},\u591a\u89c4\u683c\u5546\u54c1Map:{}", (Object)JSONUtil.toJsonStr(skuImgByItemIdsOneSpec), (Object)JSONUtil.toJsonStr(skuImgByItemIdsMulSpec));
        cartAddItemParamVO.setDemandWhStCode(demandWhStCode);
        HashMap finalSkuImgByItemIdsOneSpec = skuImgByItemIdsOneSpec;
        HashMap finalSkuImgByItemIdsMulSpec = skuImgByItemIdsMulSpec;
        List<CartAddItemParamVO.ItemSpecObjectVO> itemSpecObjectVOS = success.stream().map(item -> {
            String key = item.getItemCode() + "-" + item.getUom();
            CartAddItemParamVO.ItemSpecObjectVO vo = new CartAddItemParamVO.ItemSpecObjectVO();
            vo.setItemId(item.getItemId());
            vo.setItemCode(item.getItemCode());
            vo.setItemName(item.getItemName());
            vo.setUom(item.getUom());
            vo.setUomName(item.getUomName());
            vo.setSpuCode(item.getSpuItemCode());
            vo.setSpuName(item.getSpuItemName());
            vo.setQty(item.getDemandQuantity());
            if (priceMap.containsKey(key)) {
                AppItemPriceRespVO priceRespVO = (AppItemPriceRespVO)priceMap.get(item.getItemCode());
                vo.setItemPrice(priceRespVO.getPrice());
                vo.setSuppId(priceRespVO.getSuppId());
                vo.setSuppCode(priceRespVO.getSuppCode());
                vo.setStoreCode(priceRespVO.getStoreCode());
                vo.setCostPrice(priceRespVO.getCostPrice());
                vo.setPurPrice(priceRespVO.getPurPrice());
                vo.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                vo.setTefPrice(priceRespVO.getTefPrice());
                vo.setMefPrice(priceRespVO.getMefPrice());
                vo.setOefPrice(priceRespVO.getOefPrice());
                vo.setSalePrice(priceRespVO.getSalePrice());
            }
            vo.setSpec(item.getSpec());
            vo.setUrl(this.getItemUrl(item.getItemAttr2(), item.getItemId(), item.getSpuId(), finalSkuImgByItemIdsOneSpec, finalSkuImgByItemIdsMulSpec));
            vo.setItemCateCode(item.getItemCateCode());
            vo.setItemCateName(item.getItemCateName());
            vo.setItemPrice(item.getItemPrice());
            return vo;
        }).collect(Collectors.toList());
        cartAddItemParamVO.setItemSpecObjectVOS(itemSpecObjectVOS);
        log.info("\u5c0f\u7a0b\u5e8f\u6a21\u677f\u5546\u54c1\u6dfb\u52a0\u91c7\u8d2d\u8f66\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)cartAddItemParamVO));
        return cartAddItemParamVO;
    }

    private String getItemUrl(String itemAttr2, Long itemId, Long spuId, Map<Long, ItmItemAttachmentProviderDTO> skuImgByItemIdsOneSpec, Map<Long, ItmItemAttachmentProviderDTO> skuImgByItemIdsMulSpec) {
        if ("1".equals(itemAttr2) && skuImgByItemIdsOneSpec.containsKey(spuId)) {
            return skuImgByItemIdsOneSpec.get(spuId).getUrl();
        }
        if ("0".equals(itemAttr2) && skuImgByItemIdsMulSpec.containsKey(itemId)) {
            return skuImgByItemIdsMulSpec.get(itemId).getUrl();
        }
        return "";
    }

    private void addSuccess(Map<String, DemandOrderApplySuccessRespVO> successMap, ScpTemplateOrderDO templateOrderDO, AppItemPriceRespVO priceRespVO) {
        String itemCode = templateOrderDO.getItemCode();
        if (successMap.containsKey(itemCode)) {
            DemandOrderApplySuccessRespVO vo = successMap.get(itemCode);
            BigDecimal oldQty = vo.getDemandQuantity();
            BigDecimal newQty = templateOrderDO.getQty2();
            BigDecimal sumQty = oldQty.add(newQty);
            vo.setDemandQuantity(sumQty);
        } else {
            DemandOrderApplySuccessRespVO vo = new DemandOrderApplySuccessRespVO();
            vo.setItemId(templateOrderDO.getItemId());
            vo.setItemCode(templateOrderDO.getItemCode());
            vo.setItemName(templateOrderDO.getItemName());
            vo.setDemandQuantity(templateOrderDO.getQty2());
            vo.setItemCateCode(templateOrderDO.getItemCateCode());
            vo.setItemCateName(templateOrderDO.getItemCateName());
            vo.setQty2(templateOrderDO.getDemandQuantity());
            vo.setUom2(templateOrderDO.getBasicUnitMeasure());
            vo.setUom2Name(templateOrderDO.getBasicUnitMeasureName());
            vo.setDecimalPlaces(templateOrderDO.getDecimalPlaces());
            vo.setUomRatio(templateOrderDO.getUomRatio());
            if (priceRespVO != null) {
                vo.setItemPrice(priceRespVO.getPrice());
                vo.setSuppId(priceRespVO.getSuppId());
                vo.setSuppCode(priceRespVO.getSuppCode());
                vo.setStoreCode(priceRespVO.getStoreCode());
                vo.setCostPrice(priceRespVO.getCostPrice());
                vo.setPurPrice(priceRespVO.getPurPrice());
                vo.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                vo.setTefPrice(priceRespVO.getTefPrice());
                vo.setMefPrice(priceRespVO.getMefPrice());
                vo.setOefPrice(priceRespVO.getOefPrice());
            }
            successMap.put(itemCode, vo);
        }
    }

    private void addFail(List<DemandOrderApplyFailureRespVO> fail, String itemCode, String itemName, String msg) {
        DemandOrderApplyFailureRespVO failVO = new DemandOrderApplyFailureRespVO();
        failVO.setItemCode(itemCode);
        failVO.setItemName(itemName);
        failVO.setMsg(msg);
        fail.add(failVO);
    }

    private DemandOrderApplyRespVO buildDefaultResult() {
        DemandOrderApplyRespVO vo = new DemandOrderApplyRespVO();
        vo.setAllFailed(false);
        vo.setFail(new ArrayList<DemandOrderApplyFailureRespVO>());
        vo.setSuccess(new ArrayList<DemandOrderApplySuccessRespVO>());
        return vo;
    }

    private List<StoreAuthorityRespDTO.ItemInfo> getPermitedItemsByStoreCode(String storeCode) {
        StoreAuthorityRpcDTO storeAuthorityRpcDTO = new StoreAuthorityRpcDTO();
        storeAuthorityRpcDTO.setStoreCode(storeCode);
        StoreAuthorityRespDTO data = (StoreAuthorityRespDTO)this.storeAuthorityRpcService.getStoreAuthorityData(storeAuthorityRpcDTO).getData();
        if (data == null) {
            return new ArrayList<StoreAuthorityRespDTO.ItemInfo>();
        }
        return data.getItemInfos();
    }

    private PagingVO<ScpManAuthorityPageRespVO> getAuthorityPageRespVOPagingVO() {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setTypes(List.of(Integer.valueOf(1), Integer.valueOf(0)));
        scpManAuthorityParam.setEnableStatus(Boolean.TRUE);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        return scpManAuthorityPageRespVOPagingVO;
    }

    private void extractedAuthorityParam(DemandOrderPageQueryVO queryParam, PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO) {
        List records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List<Long> whIds = records.stream().filter(v -> 1 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> storeIds = records.stream().filter(v -> 0 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhId).filter(Objects::nonNull).collect(Collectors.toList());
        queryParam.setWhIds(whIds);
        queryParam.setStoreIds(storeIds);
    }

    public DemandOrderApplyRespVO applyBOH(DemandOrderApplyParamVO vo, TemplateApplyCartContext context) {
        log.info("\u5e94\u7528\u6a21\u677f\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)vo));
        String demandWhStCode = vo.getDemandWhStCode();
        String type = vo.getType();
        boolean isStore = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type);
        DemandOrderApplyRespVO result = new DemandOrderApplyRespVO();
        List orderTemList = this.scpDemandOrderTemplateRepoProc.findByMasIdIn(vo.getIds()).stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getItemCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(orderTemList)) {
            return this.buildDefaultResult();
        }
        log.info("\u6a21\u677f\u5e94\u7528,\u5546\u54c1\u8be6\u60c5\u6570\u636e{}", (Object)JSONUtil.toJsonStr(orderTemList));
        List<String> itemCodeList = orderTemList.stream().map(ScpTemplateOrderDO::getItemCode).distinct().collect(Collectors.toList());
        HashMap<String, DemandOrderApplySuccessRespVO> successMap = new HashMap<String, DemandOrderApplySuccessRespVO>();
        ArrayList<DemandOrderApplyFailureRespVO> fail = new ArrayList<DemandOrderApplyFailureRespVO>();
        List<Object> itemCodePermittedList = new ArrayList();
        if (isStore) {
            List<StoreAuthorityRespDTO.ItemInfo> itemsByStoreCode = this.getPermitedItemsByStoreCodeBOH(demandWhStCode, vo.getDocType(), type, context, itemCodeList);
            itemCodePermittedList = itemsByStoreCode.stream().map(StoreAuthorityRespDTO.ItemInfo::getItemCode).distinct().collect(Collectors.toList());
        }
        log.info("\u95e8\u5e97\u8981\u8d27\u6743\u9650\u5546\u54c1\u7f16\u7801\u96c6\u5408{}", (Object)JSONUtil.toJsonStr(itemCodePermittedList));
        List<String> allBOHItemCodes = this.scpCateItemDomainService.existByItemCodes(itemCodeList);
        log.info("\u5c0f\u7a0b\u5e8f\u4e0a\u67b6\u5546\u54c1{}", (Object)JSONUtil.toJsonStr(allBOHItemCodes));
        ItmItemBaseRpcParam rpcParam = new ItmItemBaseRpcParam();
        rpcParam.setItemCodes(allBOHItemCodes);
        List<ItmItemBaseRpcDTO> itemRpcDtoByParam = this.rmiItemService.findItemBaseRpcDtoByParam(rpcParam);
        context.setItemRpcDtoByParam(itemRpcDtoByParam);
        Map<String, AppItemPriceRespVO> priceMap = context.getPriceMap();
        for (ScpTemplateOrderDO templateOrderDO : orderTemList) {
            String itemCode = templateOrderDO.getItemCode();
            String itemName = templateOrderDO.getItemName();
            if ("BOH".equals(vo.getInvoker()) && !allBOHItemCodes.contains(itemCode)) {
                this.addFail(fail, itemCode, itemName, "\u8be5\u5546\u54c1\u4e0d\u5c5e\u4e8e\u5c0f\u7a0b\u5e8f\u5546\u54c1");
                continue;
            }
            if (!itemCodePermittedList.contains(itemCode) && isStore) {
                this.addFail(fail, itemCode, itemName, "\u95e8\u5e97\u8981\u8d27\u6743\u9650\u4e0d\u5305\u542b");
                continue;
            }
            if (!priceMap.containsKey(itemCode)) {
                this.addFail(fail, itemCode, itemName, "\u8be5\u5546\u54c1\u6ca1\u6709\u67e5\u8be2\u5230\u4ef7\u683c");
                continue;
            }
            AppItemPriceRespVO priceRespVO = priceMap.get(itemCode);
            this.addSuccess(successMap, templateOrderDO, priceRespVO);
        }
        ArrayList<DemandOrderApplySuccessRespVO> success = new ArrayList<DemandOrderApplySuccessRespVO>(successMap.values());
        this.processItemInfoBOH(success, context);
        result.setSuccess(success);
        result.setFail(fail);
        if (success.size() == 0) {
            result.setAllFailed(true);
        }
        log.info("\u5e94\u7528\u6a21\u677f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)result));
        return result;
    }

    private void processItemInfoBOH(List<DemandOrderApplySuccessRespVO> success, TemplateApplyCartContext context) {
        if (CollUtil.isEmpty(success)) {
            return;
        }
        List itemCodeList = success.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getItemCode())).map(DemandOrderApplySuccessRespVO::getItemCode).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(context.getItemRpcDtoByParam())) {
            throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5546\u54c1\u6743\u9650");
        }
        List itemRpcDtoByParam = context.getItemRpcDtoByParam().stream().filter(item -> itemCodeList.contains(item.getItemCode())).collect(Collectors.toList());
        Map itemCodeEntityMap = itemRpcDtoByParam.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode, Function.identity()));
        success.forEach(item -> {
            String itemCode = item.getItemCode();
            if (itemCodeEntityMap.containsKey(itemCode)) {
                ItmItemBaseRpcDTO itmItemRpcDTO = (ItmItemBaseRpcDTO)itemCodeEntityMap.get(itemCode);
                item.setSpuId(itmItemRpcDTO.getSpuId());
                item.setSpuItemCode(itmItemRpcDTO.getSpuCode());
                item.setSpuItemName(itmItemRpcDTO.getSpuName());
                item.setUom(itmItemRpcDTO.getUom());
                item.setUomName(itmItemRpcDTO.getUomName());
                if (item.getItemId() == null) {
                    item.setItemId(itmItemRpcDTO.getId());
                }
                if (StrUtil.isBlank((CharSequence)item.getItemName())) {
                    item.setItemName(itmItemRpcDTO.getItemName());
                }
                if (StrUtil.isBlank((CharSequence)item.getItemCateCode())) {
                    item.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                }
                item.setItemAttr2(itmItemRpcDTO.getItemAttr2());
                item.setSpec(itmItemRpcDTO.getSpec());
                item.setItemType(itmItemRpcDTO.getItemType2());
            }
        });
    }

    private void processItemInfo(List<DemandOrderApplySuccessRespVO> success) {
        if (CollUtil.isEmpty(success)) {
            return;
        }
        List itemCodeList = success.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getItemCode())).map(DemandOrderApplySuccessRespVO::getItemCode).distinct().collect(Collectors.toList());
        ItmItemBaseRpcParam rpcParam = new ItmItemBaseRpcParam();
        rpcParam.setItemCodes(itemCodeList);
        List<ItmItemBaseRpcDTO> itemRpcDtoByParam = this.rmiItemService.findItemBaseRpcDtoByParam(rpcParam);
        Map itemCodeEntityMap = itemRpcDtoByParam.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode, Function.identity()));
        success.forEach(item -> {
            String itemCode = item.getItemCode();
            if (itemCodeEntityMap.containsKey(itemCode)) {
                ItmItemBaseRpcDTO itmItemRpcDTO = (ItmItemBaseRpcDTO)itemCodeEntityMap.get(itemCode);
                item.setSpuId(itmItemRpcDTO.getSpuId());
                item.setSpuItemCode(itmItemRpcDTO.getSpuCode());
                item.setSpuItemName(itmItemRpcDTO.getSpuName());
                item.setUom(itmItemRpcDTO.getUom2());
                item.setUomName(itmItemRpcDTO.getUom2Name());
                if (item.getItemId() == null) {
                    item.setItemId(itmItemRpcDTO.getId());
                }
                if (StrUtil.isBlank((CharSequence)item.getItemName())) {
                    item.setItemName(itmItemRpcDTO.getItemName());
                }
                if (StrUtil.isBlank((CharSequence)item.getItemCateCode())) {
                    item.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                }
                item.setItemAttr2(itmItemRpcDTO.getItemAttr2());
                item.setSpec(itmItemRpcDTO.getSpec());
                item.setItemType(itmItemRpcDTO.getItemType2());
            }
        });
    }

    private List<StoreAuthorityRespDTO.ItemInfo> getPermitedItemsByStoreCodeBOH(String storeCode, String docType, String type, TemplateApplyCartContext context, List<String> itemCodeList) {
        StoreAuthorityRpcDTO storeAuthorityRpcDTO = new StoreAuthorityRpcDTO();
        storeAuthorityRpcDTO.setStoreCode(storeCode);
        storeAuthorityRpcDTO.setDocType(docType);
        StoreAuthorityRespDTO data = this.storeAuthorityService.getStoreAuthorityDataBOH(storeAuthorityRpcDTO, context, itemCodeList, type);
        if (data == null) {
            return new ArrayList<StoreAuthorityRespDTO.ItemInfo>();
        }
        return data.getItemInfos();
    }

    public DemandOrderTemplateServiceImpl(ScpDemandOrderTemplateRepo scpDemandOrderTemplateRepo, ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc, ScpDemandTemplateSetRepo scpDemandTemplateSetRepo, ScpDemandTemplateSetRepoProc scpDemandTemplateSetRepoProc, RmiSysUserRpcService rmiSysUserRpcService, RmiSysUDCService rmiSysUDCService, StoreAuthorityRpcService storeAuthorityRpcService, RmiItemService rmiItemService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiPriceRpcService rmiPriceRpcService, RmiSalRpcService rmiSalRpcService, ScpCateItemDomainService scpCateItemDomainService, ScpDemandAuthorityService scpDemandAuthorityService, StoreAuthorityService storeAuthorityService, CartRedisUtil cartRedisUtil, ScpStoreCartService scpStoreCartService, CommonPriceService commonPriceService, ScpOrderSettingDomainService scpOrderSettingDomainService) {
        this.scpDemandOrderTemplateRepo = scpDemandOrderTemplateRepo;
        this.scpDemandOrderTemplateRepoProc = scpDemandOrderTemplateRepoProc;
        this.scpDemandTemplateSetRepo = scpDemandTemplateSetRepo;
        this.scpDemandTemplateSetRepoProc = scpDemandTemplateSetRepoProc;
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.rmiSysUDCService = rmiSysUDCService;
        this.storeAuthorityRpcService = storeAuthorityRpcService;
        this.rmiItemService = rmiItemService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiPriceRpcService = rmiPriceRpcService;
        this.rmiSalRpcService = rmiSalRpcService;
        this.scpCateItemDomainService = scpCateItemDomainService;
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.storeAuthorityService = storeAuthorityService;
        this.cartRedisUtil = cartRedisUtil;
        this.scpStoreCartService = scpStoreCartService;
        this.commonPriceService = commonPriceService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
    }
}

