package com.elitesland.scp.application.web.authority;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.OrgStoreListParam;
import com.elitesland.scp.application.facade.vo.resp.app.OrgStoreRespVO;
import com.elitesland.scp.application.service.app.AppStoreListService;
import com.elitesland.support.provider.org.dto.OrgStoreRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreRpcParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping(value = "/store/component", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "中台-门店列表", tags = {"中台-门店列表"})
@AllArgsConstructor
public class storeListComponentController {

    private final AppStoreListService appStoreListService;

    @ApiOperation("中台 - 门店列表放大镜")
    @PostMapping("/pageQuery")
    public ApiResult<PagingVO<OrgStoreRpcDTO>> pageQuery(@RequestBody @Validated OrgStoreRpcParam param) {
        return ApiResult.ok(appStoreListService.pageQuery(param));
    }

    @ApiOperation("中台 - 门店列表过滤门店日历放大镜")
    @PostMapping("/pageQueryByDate")
    public ApiResult<PagingVO<OrgStoreRpcDTO>> pageQueryByDate(@RequestBody @Validated OrgStoreListParam param) {
        return ApiResult.ok(appStoreListService.pageQueryByDate(param));
    }


}
