package com.elitesland.scp.domain.entity.purLimit;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "scp_pur_limit_setting_store")
@org.hibernate.annotations.Table(appliesTo = "scp_pur_limit_setting_store", comment = "订货限购门店表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "订货限购门店表", description = "订货限购门店表")
@Where(clause = "delete_flag = 0")
public class ScpPurLimitSettingStoreDO extends BaseModel implements Serializable {

    @ApiModelProperty("活动ID")
    @Comment("活动ID")
    @Column()
    private Long masId;

    @ApiModelProperty("门店ID")
    @Comment("门店ID")
    @Column()
    private Long storeId;

    @ApiModelProperty("门店编码")
    @Comment("门店编码")
    @Column()
    private String storeCode;

    @ApiModelProperty("门店名称")
    @Comment("门店名称")
    @Column()
    private String storeName;

    @ApiModelProperty("经营类型")
    @Comment("经营类型")
    @Column()
    private String storeType2;

    @ApiModelProperty("最大起订次数")
    @Comment("最大起订次数")
    @Column()
    private Integer maxNum;

    @ApiModelProperty("已配次数")
    @Comment("已配次数")
    @Column()
    private Integer activeNum;
}
