package com.elitesland.scp.infr.repo.minOrder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingPageRespVO;
import com.elitesland.scp.domain.entity.minOrder.QScpMinOrderSettingDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpMinOrderSettingRepoProc {
    private static final QScpMinOrderSettingDO scpMinOrderSettingDO = QScpMinOrderSettingDO.scpMinOrderSettingDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<ScpMinOrderSettingPageRespVO> pageList = Projections.bean(
            ScpMinOrderSettingPageRespVO.class,
            scpMinOrderSettingDO.id,
            scpMinOrderSettingDO.docType,
            scpMinOrderSettingDO.activityCode,
            scpMinOrderSettingDO.activityName,
            scpMinOrderSettingDO.activityType,
            scpMinOrderSettingDO.validFrom,
            scpMinOrderSettingDO.validTo,
            scpMinOrderSettingDO.status,
            scpMinOrderSettingDO.creator,
            scpMinOrderSettingDO.createUserId,
            scpMinOrderSettingDO.createTime,
            scpMinOrderSettingDO.updater,
            scpMinOrderSettingDO.modifyUserId,
            scpMinOrderSettingDO.modifyTime,
            scpMinOrderSettingDO.remark
    );

    public long countMinOrderSetting(ScpMinOrderSettingPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpMinOrderSettingDO.count())
                .from(scpMinOrderSettingDO);
        jpaQuery.where(this.whereMinOrderSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpMinOrderSettingPageRespVO> queryMinOrderSetting(ScpMinOrderSettingPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpMinOrderSettingDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpMinOrderSettingDO);
        jpaQuery.where(this.whereMinOrderSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereMinOrderSettingPage(ScpMinOrderSettingPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpMinOrderSettingDO.docType.eq(paramVO.getDocType()));
        }
        if (paramVO.getValidFrom() != null && paramVO.getValidTo() != null) {
            predicates.add(scpMinOrderSettingDO.validFrom.loe(paramVO.getValidFrom()).and(scpMinOrderSettingDO.validTo.goe(paramVO.getValidTo())));
        }
        if (paramVO.getStatus() != null) {
            predicates.add(scpMinOrderSettingDO.status.eq(paramVO.getStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getActivityCodeName())) {
            predicates.add(scpMinOrderSettingDO.activityCode.like("%" + paramVO.getActivityCodeName() + "%").or(scpMinOrderSettingDO.activityName.like("%" + paramVO.getActivityCodeName() + "%")));
        }
        if (CollUtil.isNotEmpty(paramVO.getIds())) {
            predicates.add(scpMinOrderSettingDO.id.in(paramVO.getIds()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void enableMinOrderSetting(List<Long> ids, Boolean enable) {
        JPAUpdateClause update = jpaQueryFactory.update(scpMinOrderSettingDO)
                .set(scpMinOrderSettingDO.status, enable)
                .where(scpMinOrderSettingDO.id.in(ids));
        update.execute();
    }

    public long deleteByIds(List<Long> ids) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpMinOrderSettingDO.id.in(ids));
        var delete = jpaQueryFactory.delete(scpMinOrderSettingDO)
                .where(ExpressionUtils.allOf(predicates));
        return delete.execute();
    }

}
