package com.elitesland.scp.application.facade.vo.resp.purLimit;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("订货强配分页返回")
public class ScpPurLimitSettingPageRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -3038925240131174177L;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("活动类型")
    @SysCode(sys = "yst-suplan", mod = "PURLIMIT_SETTING_TYPE")
    private String activityType;
    private String activityTypeName;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("状态")
    private Boolean status;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "单据类型名称")
    private List<String> docTypeNames;

    @ApiModelProperty("是否引用 true:引用，false:未引用")
    private Boolean useFlag;
}
