package com.elitesland.scp.application.facade.vo.save.authority;


import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 计划员权限分配VO
 * @author : wz
 * @date : 2024-3-18
 */
@Data
@ApiModel(value = "计划员权限分配导入模板", description = "计划员权限分配导入模板")
public class ScpManAuthorityImportVO implements Serializable {

    /** 计划员编码 */
    @ApiModelProperty(name = "计划员编码")
    @ExcelProperty(index = 0)
    private String scpsmanNo ;

    /** 计划员姓名 */
    @ApiModelProperty(name = "计划员姓名")
    @ExcelProperty(index = 1)
    private String scpsman ;

    /** 公司名称 */
    @ApiModelProperty(name = "公司名称")
    @ExcelProperty(index = 2)
    private String ouName ;

    /** 公司编码 */
    @ApiModelProperty(name = "公司编码")
    private String ouCode ;

    /** 类型 */
    @ApiModelProperty(name = "类型")
    @ExcelProperty(index = 3)
    private String typeName;

    /** 门店编码/仓库编码 */
    @ApiModelProperty(name = "门店编码/仓库编码")
    @ExcelProperty(index = 4)
    private String stWhCode ;

    /** 门店名称/仓库名称 */
    @ApiModelProperty(name = "门店名称/仓库名称")
    @ExcelProperty(index = 5)
    private String stWhName ;

    /** 启用状态*/
    @ApiModelProperty(name = "启用状态")
    @ExcelProperty(index = 6)
    private String enableStatusName ;



}