package com.elitesland.scp.domain.service.minOrder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingRegionRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingRegionSaveVO;
import com.elitesland.scp.domain.convert.minOrder.ScpMinOrderSettingRegionConvert;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingRegionDO;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingRegionRepo;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingRegionRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpMinOrderSettingRegionDomainServiceImpl implements ScpMinOrderSettingRegionDomainService {

    private final ScpMinOrderSettingRegionRepo scpMinOrderSettingRegionRepo;
    private final ScpMinOrderSettingRegionRepoProc scpMinOrderSettingRegionRepoProc;

    @Override
    public List<ScpMinOrderSettingRegionRespVO> findByMasId(Long masId) {
        List<ScpMinOrderSettingRegionDO> settingItemDOS = scpMinOrderSettingRegionRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpMinOrderSettingRegionConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveSettingRegion(List<ScpMinOrderSettingRegionSaveVO> saveVOS) {
        scpMinOrderSettingRegionRepo.saveAll(ScpMinOrderSettingRegionConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        scpMinOrderSettingRegionRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpMinOrderSettingRegionRepo.deleteByIds(ids);
    }

    @Override
    public PagingVO<ScpMinOrderSettingRegionRespVO> page(ScpMinOrderSettingRegionPageParamVO paramVO) {
        long count = scpMinOrderSettingRegionRepoProc.countMinOrderSettingRegion(paramVO);
        if (count > 0) {
            List<ScpMinOrderSettingRegionRespVO> respVOList = scpMinOrderSettingRegionRepoProc.queryMinOrderSettingRegion(paramVO);
            return new PagingVO<>(count, respVOList);
        }
        return new PagingVO<>();
    }

    @Override
    public List<Long> findMasIdByRegionCode(String regionCode) {
        return scpMinOrderSettingRegionRepoProc.findMasIdByRegionCode(regionCode);
    }
}
