package com.elitesland.scp.domain.service.purLimit;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingSaveVO;
import com.elitesland.scp.infr.dto.purLimit.ScpPurLimitSettingDTO;

import java.util.List;
import java.util.Optional;

public interface ScpPurLimitSettingDomainService {

    /**
     * 订货强配活动查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpPurLimitSettingPageRespVO> queryPurLimitSettingList(ScpPurLimitSettingPageParamVO paramVO);

    /**
     * 订货强配活动详情查询
     *
     * @param id
     * @return
     */
    Optional<ScpPurLimitSettingDTO> findPurLimitSettingById(Long id);

    /**
     * 订货强配活动配置保存
     *
     * @param saveVO 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    Long savePurLimitSetting(ScpPurLimitSettingSaveVO saveVO);

    /**
     * 订货强配活动状态变更
     *
     * @param ids    单据类型配置的ID列表
     * @param enable 单据类型配置的状态，true表示启用，false表示禁用
     */
    void enablePurLimitSetting(List<Long> ids, Boolean enable);

    /**
     * 删除订货强配活动
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);
}
