package com.elitesland.scp.domain.service.stock;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageVO;
import com.elitesland.scp.domain.convert.stock.ScpSafetyTargetStockConvert;
import com.elitesland.scp.domain.entity.stock.ScpSafetyTargetStockDO;
import com.elitesland.scp.infr.dto.stock.ScpSafetyTargetStockDTO;
import com.elitesland.scp.infr.repo.stock.ScpSafetyTargetStockRepo;
import com.elitesland.scp.infr.repo.stock.ScpSafetyTargetStockRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 01月 16日 11:34
 * @version: 1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpSafetyTargetStockDomainServiceImpl implements ScpSafetyTargetStockDomainService {

    private final ScpSafetyTargetStockRepo scpSafetyTargetStockRepo;

    private final ScpSafetyTargetStockRepoProc scpSafetyTargetStockRepoProc;

    @Override
    public PagingVO<ScpSafetyTargetStockPageVO> searchPage(ScpSafetyTargetStockPageParam param) {
        return scpSafetyTargetStockRepoProc.searchPage(param);
    }

    @Override
    public ScpSafetyTargetStockDTO findById(Long id) {
        Optional<ScpSafetyTargetStockDO> targetStockDO = scpSafetyTargetStockRepo.findById(id);
        return targetStockDO.map(ScpSafetyTargetStockConvert.INSTANCE::doToDto).orElse(null);
    }

    @Override
    public List<ScpSafetyTargetStockDTO> findByBusinessKey(String businessKey) {
        List<ScpSafetyTargetStockDO> safetyTargetStockDOS = scpSafetyTargetStockRepo.findByBusinessKey(businessKey);
        if(CollectionUtils.isNotEmpty(safetyTargetStockDOS)){
            return safetyTargetStockDOS.stream().map(ScpSafetyTargetStockConvert.INSTANCE::doToDto).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional
    public Long save(ScpSafetyTargetStockDTO dto) {
        return scpSafetyTargetStockRepo.save(ScpSafetyTargetStockConvert.INSTANCE.dtoToDo(dto)).getId();
    }

    @Override
    @Transactional
    public List<ScpSafetyTargetStockDO> saveAll(List<ScpSafetyTargetStockDTO> saveList) {
        List<ScpSafetyTargetStockDO> stockDOS = saveList.stream()
                .map(ScpSafetyTargetStockConvert.INSTANCE::dtoToDo)
                .collect(Collectors.toList());
        return scpSafetyTargetStockRepo.saveAll(stockDOS);
    }

    @Override
    @Transactional
    public void delete(List<Long> ids) {
        scpSafetyTargetStockRepo.deleteAllById(ids);
    }

    @Override
    public List<ScpSafetyTargetStockDTO> findIdBatch(List<Long> ids) {
        List<ScpSafetyTargetStockDO> stockDOS = scpSafetyTargetStockRepo.findAllById(ids);
        if(CollectionUtils.isEmpty(stockDOS)){
            return new ArrayList<>();
        }else{
            return stockDOS.stream().map(ScpSafetyTargetStockConvert.INSTANCE::doToDto).collect(Collectors.toList());

        }
    }

}
