/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.collect;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.app.ScpStoreItemParamVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectCancelVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.collect.ScpUserCollectRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.collect.ScpUserCollectSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.ScpCacheService;
import com.elitesland.scp.application.service.collect.ScpUserCollectService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.item.ScpCateItemService;
import com.elitesland.scp.domain.convert.collect.ScpUserCollectConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.collect.ScpUserCollectDO;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmCateCodeAndNameRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemCateCodeRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSpuBusinessRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemCateCodeParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import io.seata.common.util.CollectionUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.stereotype.Service;

@Service
public class ScpUserCollectServiceImpl
implements ScpUserCollectService {
    private static final Logger log = LoggerFactory.getLogger(ScpUserCollectServiceImpl.class);
    private final CartRedisUtil cartRedisUtil;
    private final ScpCacheService scpCacheService;
    private final CollectRedisUtil collectRedisUtil;
    private final CommonPriceService commonPriceService;
    private final RmiItemService rmiItemService;
    private final ScpCateItemService scpCateItemService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ItmItemRpcService itmItemRpcService;

    @Override
    public List<ScpUserCollectRespVO> getUserList(ScpUserCollectParamVO paramVO) {
        List spuIds;
        List skuImgByItemIds;
        Long currentUserId = UserService.currentUserId();
        List<ScpUserCollectDO> userCollectItems = this.collectRedisUtil.getUserCollectItems(paramVO.getDemandWhStCode(), currentUserId);
        if (CollUtil.isEmpty(userCollectItems)) {
            return new ArrayList<ScpUserCollectRespVO>();
        }
        Map<String, AppItemPriceRespVO> priceMap = this.getItemPrice(paramVO, userCollectItems);
        ArrayList<ScpUserCollectRespVO> resultList = new ArrayList<ScpUserCollectRespVO>();
        Map<String, List<ScpUserCollectDO>> spuMap = userCollectItems.stream().collect(Collectors.groupingBy(item -> SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode())));
        HashSet uniqueValues = new HashSet();
        HashSet itemIdSet = new HashSet();
        for (ScpUserCollectDO userCollectItem : userCollectItems) {
            Optional.ofNullable(userCollectItem.getSpuCode()).ifPresent(uniqueValues::add);
            Optional.ofNullable(userCollectItem.getItemId()).ifPresent(itemIdSet::add);
        }
        ArrayList<String> spuCodes = new ArrayList<String>(uniqueValues);
        Map<Object, Object> moqMap = CollUtil.isNotEmpty(spuCodes) ? this.rmiItemService.findMoqByParam(spuCodes, paramVO.getOuCode()) : new HashMap();
        ArrayList itemIds = new ArrayList(itemIdSet);
        Map cateMap = new HashMap();
        Map<Object, Object> scpCateItemMap = new HashMap();
        if (CollUtil.isNotEmpty(itemIds)) {
            CateItemRpcParam cateItemRpcParam = new CateItemRpcParam();
            cateItemRpcParam.setItemIds(itemIds);
            ApiResult<List<ScpCateItemDTO>> apiResult = this.scpCateItemService.query(cateItemRpcParam);
            if (apiResult.isSuccess()) {
                List items = (List)apiResult.getData();
                if (CollUtil.isNotEmpty((Collection)items)) {
                    List itemCateCodes = items.stream().map(ScpCateItemDTO::getCateCode).collect(Collectors.toList());
                    if (CollUtil.isNotEmpty(itemCateCodes)) {
                        ItmItemCateCodeParam cateCodeParam = new ItmItemCateCodeParam();
                        cateCodeParam.setItemCateCodes(itemCateCodes);
                        ItmItemCateCodeRpcDTO itemCateCodeRpcDTO = this.itmItemRpcService.findCateCodeReItemCateCode(cateCodeParam);
                        cateMap = itemCateCodeRpcDTO.getCateMap();
                    }
                    scpCateItemMap = items.stream().collect(Collectors.toMap(ScpCateItemDTO::getItemId, item -> item));
                }
            } else {
                log.error("\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u5206\u7c7b\u5f02\u5e38\uff1a{}", (Object)apiResult.getMsg());
            }
        }
        for (Map.Entry entry : spuMap.entrySet()) {
            Optional<ItmItemAttachmentRpcDTO> attachOpt;
            ScpUserCollectRespVO vo = new ScpUserCollectRespVO();
            List storeCartDOS = (List)entry.getValue();
            ScpUserCollectDO scpUserCollectDO = (ScpUserCollectDO)storeCartDOS.get(0);
            vo.setSpuId(scpUserCollectDO.getSpuId());
            vo.setSpuCode(scpUserCollectDO.getSpuCode());
            vo.setSpuName(scpUserCollectDO.getSpuName());
            vo.setSpec(scpUserCollectDO.getSpec());
            vo.setAnotherName(scpUserCollectDO.getAnotherName());
            vo.setCombineItemCode(scpUserCollectDO.getCombineItemCode());
            vo.setCombineItemName(scpUserCollectDO.getCombineItemName());
            if (CollUtil.isNotEmpty(scpUserCollectDO.getSpuAttchmentList())) {
                attachOpt = scpUserCollectDO.getSpuAttchmentList().stream().filter(attach -> attach.getMajor()).findFirst();
                vo.setUrl(attachOpt.isPresent() ? attachOpt.get().getUrl() : scpUserCollectDO.getSpuAttchmentList().get(0).getUrl());
            }
            if (CollUtil.isNotEmpty(scpUserCollectDO.getSpuAttchmentList())) {
                attachOpt = scpUserCollectDO.getSpuAttchmentList().stream().filter(attach -> attach.getMajor()).findFirst();
                vo.setUrl(attachOpt.isPresent() ? attachOpt.get().getUrl() : scpUserCollectDO.getSpuAttchmentList().get(0).getUrl());
            }
            vo.setItemCateCode(scpUserCollectDO.getItemCateCode());
            vo.setItemCateName(scpUserCollectDO.getItemCateName());
            vo.setDocType(scpUserCollectDO.getDocType());
            List moqList = (List)moqMap.get(scpUserCollectDO.getSpuCode());
            ArrayList<ScpUserCollectRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<ScpUserCollectRespVO.ItemSpecObjectVO>();
            for (ScpUserCollectDO collectDO : storeCartDOS) {
                ScpCateItemDTO scpCateItemDTO;
                ScpStoreCartDO storeCartItem;
                ScpUserCollectRespVO.ItemSpecObjectVO detailVo = new ScpUserCollectRespVO.ItemSpecObjectVO();
                detailVo.setUom(collectDO.getUom());
                detailVo.setUomName(collectDO.getUomName());
                detailVo.setItemCode(collectDO.getItemCode());
                detailVo.setItemId(collectDO.getItemId());
                detailVo.setItemName(collectDO.getItemName());
                detailVo.setItemAttrName(collectDO.getItemAttrName());
                AppItemPriceRespVO priceRespVO = priceMap.get(SysUtils.getItemKey(collectDO.getCombineItemCode(), collectDO.getItemCode()));
                if (priceRespVO != null) {
                    detailVo.setItemPrice(priceRespVO.getPrice());
                    detailVo.setSuppCode(priceRespVO.getSuppCode());
                    detailVo.setSuppName(priceRespVO.getSuppName());
                    detailVo.setSuppId(priceRespVO.getSuppId());
                    detailVo.setCostPrice(priceRespVO.getCostPrice());
                    detailVo.setPurPrice(priceRespVO.getPurPrice());
                    detailVo.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                    detailVo.setStoreCode(priceRespVO.getStoreCode());
                    detailVo.setTefPrice(priceRespVO.getTefPrice());
                    detailVo.setMefPrice(priceRespVO.getMefPrice());
                    detailVo.setOefPrice(priceRespVO.getOefPrice());
                    detailVo.setSalePrice(priceRespVO.getSalePrice());
                    detailVo.setTefFeeOuCode(priceRespVO.getTefFeeOuCode());
                    detailVo.setTefFeeOuName(priceRespVO.getTefFeeOuName());
                    detailVo.setMefFeeOuCode(priceRespVO.getMefFeeOuCode());
                    detailVo.setMefFeeOuName(priceRespVO.getMefFeeOuName());
                    detailVo.setOefFeeOuCode(priceRespVO.getOefFeeOuCode());
                    detailVo.setOefFeeOuName(priceRespVO.getOefFeeOuName());
                    vo.setCombineQty(priceRespVO.getCombineQty());
                }
                if ((storeCartItem = this.cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(collectDO.getCombineItemCode(), collectDO.getItemCode()), paramVO.getDemandWhStCode(), collectDO.getDocType(), currentUserId)) != null) {
                    detailVo.setQty(storeCartItem.getQty());
                } else {
                    detailVo.setQty(BigDecimal.ZERO);
                }
                detailVo.setUom2(collectDO.getUom2());
                detailVo.setUom2Name(collectDO.getUom2Name());
                detailVo.setDecimalPlaces(collectDO.getDecimalPlaces());
                detailVo.setUomRatio(collectDO.getUomRatio());
                detailVo.setItemType(collectDO.getItemType());
                if (collectDO.getItemId() != null && (scpCateItemDTO = (ScpCateItemDTO)scpCateItemMap.get(collectDO.getItemId())) != null) {
                    detailVo.setScpItemCateCode(scpCateItemDTO.getCateCode());
                    ItmCateCodeAndNameRpcDTO itmCateCodeAndNameRpcDTO = (ItmCateCodeAndNameRpcDTO)cateMap.get(scpCateItemDTO.getCateCode());
                    if (itmCateCodeAndNameRpcDTO != null) {
                        detailVo.setScpItemCateName(String.join((CharSequence)">", itmCateCodeAndNameRpcDTO.getCateNameList()));
                    }
                }
                if (CollUtil.isNotEmpty((Collection)moqList)) {
                    detailVo.setMoq(((ItmItemSpuBusinessRpcDTO)moqList.get(0)).getMoq());
                }
                itemSpecObjectVOS.add(detailVo);
            }
            vo.setItemSpecObjectVOS(itemSpecObjectVOS);
            resultList.add(vo);
        }
        List<ScpUserCollectRespVO> result = resultList.stream().filter(d -> StringUtils.isBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<ScpUserCollectRespVO>> map = resultList.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.groupingBy(ScpUserCollectRespVO::getCombineItemCode));
        if (!map.isEmpty()) {
            map.forEach((k, v) -> {
                ScpUserCollectRespVO combineOrderDRespVO = new ScpUserCollectRespVO();
                combineOrderDRespVO.setCombineItemCode((String)k);
                combineOrderDRespVO.setCombineItemName(((ScpUserCollectRespVO)v.get(0)).getCombineItemName());
                combineOrderDRespVO.setCombineItemFlag(Boolean.TRUE);
                combineOrderDRespVO.setSubItemList((List<ScpUserCollectRespVO>)v);
                result.add(combineOrderDRespVO);
            });
        }
        if (CollectionUtils.isNotEmpty(result) && CollectionUtils.isNotEmpty((Collection)(skuImgByItemIds = this.itmItemRpcService.findSkuImgByItemIds(spuIds = result.stream().map(ScpUserCollectRespVO::getSpuId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))))) {
            Map<Long, List<ItmItemAttachmentProviderDTO>> listMap = skuImgByItemIds.stream().collect(Collectors.groupingBy(ItmItemAttachmentProviderDTO::getItemId));
            result.forEach(d -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)listMap.get(d.getSpuId())))) {
                    d.setFileCode(((ItmItemAttachmentProviderDTO)((List)listMap.get(d.getSpuId())).get(0)).getFileCode());
                }
            });
        }
        return result;
    }

    private Map<String, AppItemPriceRespVO> getItemPrice(ScpUserCollectParamVO paramVO, List<ScpUserCollectDO> userCollectItems) {
        HashMap<String, AppItemPriceRespVO> resultMap = new HashMap<String, AppItemPriceRespVO>();
        Map<String, List<ScpUserCollectDO>> businessTypeMap = userCollectItems.stream().filter(i -> i.getBusinessType() != null).collect(Collectors.groupingBy(ScpUserCollectDO::getBusinessType));
        businessTypeMap.forEach((businessType, userCollectDOS) -> {
            ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType((String)businessType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            List<AppItemActivityItemPriceParamVO> priceParamVOS = userCollectDOS.stream().map(row -> {
                AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                priceParamVO.setItemCode(row.getItemCode());
                priceParamVO.setItemId(row.getItemId());
                priceParamVO.setItemCateCode(row.getItemCateCode());
                priceParamVO.setUom(row.getUom());
                priceParamVO.setItemType2(row.getItemType2());
                priceParamVO.setCombineItemCode(row.getCombineItemCode());
                priceParamVO.setCombineItemFlag(StringUtils.isNotEmpty((CharSequence)row.getCombineItemCode()));
                return priceParamVO;
            }).collect(Collectors.toList());
            Map<String, AppItemPriceRespVO> priceMap = this.commonPriceService.getNewPriceAndStockDetails(priceParamVOS, paramVO.getDemandWhStCode(), orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            resultMap.putAll(priceMap);
        });
        return resultMap;
    }

    @Override
    public Long add(ScpUserCollectSaveVO saveVO) {
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.collectRedisUtil.getUserCollectOps(saveVO.getDemandWhStCode(), currentUserId);
        String product = (String)cartOps.get((Object)SysUtils.generateRedisKey("SPU", saveVO.getCombineItemCode(), saveVO.getItemCode()));
        if (StrUtil.isBlank((CharSequence)product)) {
            ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
            scpStoreItemParamVO.setSpuId(saveVO.getSpuId());
            scpStoreItemParamVO.setOuCode(saveVO.getOuCode());
            List<ScpStoreItemDO> itemDOS = this.scpCacheService.getItem(scpStoreItemParamVO);
            if (CollUtil.isEmpty(itemDOS)) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5546\u54c1");
            }
            List userCollectDOS = itemDOS.stream().map(row -> {
                ScpUserCollectDO scpUserCollectDO = ScpUserCollectConvert.INSTANCE.itemDoToCollectDo((ScpStoreItemDO)row);
                scpUserCollectDO.setDocType(saveVO.getDocType());
                scpUserCollectDO.setBusinessType(saveVO.getBusinessType());
                scpUserCollectDO.setUserId(currentUserId);
                scpUserCollectDO.setDemandWhStCode(saveVO.getDemandWhStCode());
                scpUserCollectDO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                scpUserCollectDO.setSkuAttchmentList(row.getSkuAttachmentList());
                scpUserCollectDO.setSpuAttchmentList(row.getSpuAttachmentList());
                scpUserCollectDO.setItemType2(row.getItemType2());
                scpUserCollectDO.setCombineItemCode(saveVO.getCombineItemCode());
                scpUserCollectDO.setCombineItemName(saveVO.getCombineItemName());
                scpUserCollectDO.setItemCode(row.getItemCode());
                return scpUserCollectDO;
            }).collect(Collectors.toList());
            cartOps.put((Object)SysUtils.generateRedisKey("SPU", saveVO.getCombineItemCode(), saveVO.getItemCode()), (Object)JSON.toJSONString(userCollectDOS));
        }
        return 1L;
    }

    @Override
    public Boolean deleteBySpuIdAndUid(ScpUserCollectCancelVO cancelVO) {
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.collectRedisUtil.getUserCollectOps(cancelVO.getDemandWhStCode(), currentUserId);
        Long delete = cartOps.delete(new Object[]{SysUtils.generateRedisKey("SPU", cancelVO.getCombineItemCode(), cancelVO.getItemCode())});
        return delete > 0L;
    }

    @Override
    public void batchSave(List<ScpUserCollectSaveVO> saveVOList) {
        if (CollUtil.isEmpty(saveVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6536\u85cf\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        saveVOList.forEach(this::add);
    }

    public ScpUserCollectServiceImpl(CartRedisUtil cartRedisUtil, ScpCacheService scpCacheService, CollectRedisUtil collectRedisUtil, CommonPriceService commonPriceService, RmiItemService rmiItemService, ScpCateItemService scpCateItemService, ScpOrderSettingDomainService scpOrderSettingDomainService, ItmItemRpcService itmItemRpcService) {
        this.cartRedisUtil = cartRedisUtil;
        this.scpCacheService = scpCacheService;
        this.collectRedisUtil = collectRedisUtil;
        this.commonPriceService = commonPriceService;
        this.rmiItemService = rmiItemService;
        this.scpCateItemService = scpCateItemService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.itmItemRpcService = itmItemRpcService;
    }
}

