/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderReplyPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderReplySaveVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderReplyService;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderReplyConvert;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderReplyDomainService;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderReplyDTO;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpDemandOrderReplyServiceImpl
implements ScpDemandOrderReplyService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderReplyServiceImpl.class);
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderReplyDomainService scpDemandOrderReplyDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long create(ScpDemandOrderReplySaveVO saveVO) {
        if (CollUtil.isNotEmpty(saveVO.getPicList())) {
            saveVO.setPics(String.join((CharSequence)";", saveVO.getPicList()));
        }
        Long id = this.scpDemandOrderReplyDomainService.save(saveVO);
        this.scpDemandOrderDomainService.updateReplyFlagById(saveVO.getOrderId());
        return id;
    }

    @Override
    public ScpDemandOrderReplyRespVO findReplyByOrderId(Long orderId) {
        Optional<ScpDemandOrderReplyDTO> replyOpt = this.scpDemandOrderReplyDomainService.findReplyByOrderId(orderId);
        if (replyOpt.isEmpty()) {
            return new ScpDemandOrderReplyRespVO();
        }
        ScpDemandOrderReplyRespVO replyRespVO = ScpDemandOrderReplyConvert.INSTANCE.dtoToRespVO(replyOpt.get());
        replyRespVO.setPicList(StrUtil.split((CharSequence)replyRespVO.getPics(), (CharSequence)";"));
        return replyRespVO;
    }

    @Override
    public PagingVO<ScpDemandOrderReplyPageRespVO> page(ScpDemandOrderReplyPageParamVO paramVO) {
        return this.scpDemandOrderReplyDomainService.page(paramVO);
    }

    public ScpDemandOrderReplyServiceImpl(ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderReplyDomainService scpDemandOrderReplyDomainService) {
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderReplyDomainService = scpDemandOrderReplyDomainService;
    }
}

