/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.supalloc;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationExportRespVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationPageParamVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationPageVO;
import com.elitesland.scp.domain.convert.ScpSupplyAllocationConvert;
import com.elitesland.scp.domain.entity.supalloc.ScpSupplyAllocationDO;
import com.elitesland.scp.domain.service.supalloc.ScpSupplyAllocationDomainService;
import com.elitesland.scp.infr.dto.supalloc.ScpSupplyAllocationDTO;
import com.elitesland.scp.infr.repo.supalloc.ScpSupplyAllocationRepo;
import com.elitesland.scp.infr.repo.supalloc.ScpSupplyAllocationRepoProc;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpSupplyAllocationDomainServiceImpl
implements ScpSupplyAllocationDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpSupplyAllocationDomainServiceImpl.class);
    private final ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc;
    private final ScpSupplyAllocationRepo scpSupplyAllocationRepo;

    @Override
    @SysCodeProc
    public PagingVO<ScpSupplyAllocationPageVO> page(ScpSupplyAllocationPageParamVO param) {
        PagingVO<ScpSupplyAllocationPageVO> page = this.scpSupplyAllocationRepoProc.page(param);
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List<String> concatKey = page.getRecords().stream().map(d -> d.getStoreWhCode() + d.getItemCode()).collect(Collectors.toList());
            List<ScpSupplyAllocationDO> allocationDOS = this.scpSupplyAllocationRepo.findByConcatKey(concatKey);
            Map<String, List<ScpSupplyAllocationDO>> groupMap = allocationDOS.stream().collect(Collectors.groupingBy(d -> d.getStoreWhCode() + d.getItemCode()));
            page.getRecords().forEach(d -> {
                List supplyAllocationDOS = (List)groupMap.get(d.getStoreWhCode() + d.getItemCode());
                if (supplyAllocationDOS != null) {
                    BigDecimal sum = supplyAllocationDOS.stream().map(ScpSupplyAllocationDO::getAllocation).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    d.setAllocationTotal(sum);
                }
            });
        }
        return page;
    }

    @Override
    public List<ScpSupplyAllocationDO> findByConcatKeys(Set<String> concatKeys) {
        ArrayList<String> stringList = new ArrayList<String>(concatKeys);
        return this.scpSupplyAllocationRepo.findByConcatKey(stringList);
    }

    @Override
    public List<ScpSupplyAllocationDO> findAllByConcatKey(List<String> cocatKeys) {
        return this.scpSupplyAllocationRepo.findAllByConcatKey(cocatKeys);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByBusinessKey(Set<String> concatKeys) {
        this.scpSupplyAllocationRepo.deleteByBusinessKey(concatKeys);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<ScpSupplyAllocationDTO> createBatch) {
        this.scpSupplyAllocationRepo.saveAll(createBatch.stream().map(ScpSupplyAllocationConvert.INSTANCE::dtoToDo).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        this.scpSupplyAllocationRepo.deleteAllById(ids);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpSupplyAllocationExportRespVO> exportSearch(ScpSupplyAllocationPageParamVO queryParam) {
        log.info("ScpSupplyAllocation export start...");
        PagingVO<ScpSupplyAllocationExportRespVO> exportSearch = this.scpSupplyAllocationRepoProc.exportSearch(queryParam);
        log.info("ScpSupplyAllocation export end...");
        if (CollectionUtils.isNotEmpty((Collection)exportSearch.getRecords())) {
            List<String> concatKey = exportSearch.getRecords().stream().map(d -> d.getStoreWhCode() + d.getItemCode()).collect(Collectors.toList());
            List<ScpSupplyAllocationDO> allocationDOS = this.scpSupplyAllocationRepo.findByConcatKey(concatKey);
            Map<String, List<ScpSupplyAllocationDO>> groupMap = allocationDOS.stream().collect(Collectors.groupingBy(d -> d.getStoreWhCode() + d.getItemCode()));
            exportSearch.getRecords().forEach(d -> {
                List supplyAllocationDOS;
                d.setStatusName("\u542f\u7528");
                if (Boolean.FALSE.equals(d.getStatus())) {
                    d.setStatusName("\u7981\u7528");
                }
                if ((supplyAllocationDOS = (List)groupMap.get(d.getStoreWhCode() + d.getItemCode())) != null) {
                    BigDecimal sum = supplyAllocationDOS.stream().map(ScpSupplyAllocationDO::getAllocation).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    d.setAllocationTotal(sum);
                }
            });
        }
        return exportSearch;
    }

    @Override
    public List<ScpSupplyAllocationDO> findByIds(List<Long> ids) {
        return this.scpSupplyAllocationRepo.findByIdIn(ids);
    }

    public ScpSupplyAllocationDomainServiceImpl(ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc, ScpSupplyAllocationRepo scpSupplyAllocationRepo) {
        this.scpSupplyAllocationRepoProc = scpSupplyAllocationRepoProc;
        this.scpSupplyAllocationRepo = scpSupplyAllocationRepo;
    }
}

