package com.elitesland.scp.application.facade.vo.param.item;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "品类商品操作设置展示")
public class ScpCateItemOperationVO {

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime dateStart;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime dateEnd;

    @ApiModelProperty(value = "门店编码列表")
    private List<String> storeCodes;

    @ApiModelProperty(value = "门店信息列表")
    private List<StoreInfo> storeList;

    @Data
    public static class StoreInfo {

        @ApiModelProperty("门店编码")
        private String storeCode;

        @ApiModelProperty(value = "可见状态")
        private Boolean visibleStatus;

        @ApiModelProperty(value = "可见状态生效日期")
        private LocalDateTime visibleDateStart;

        @ApiModelProperty(value = "可见状态失效日期")
        private LocalDateTime visibleDateEnd;
    }

}
