package com.elitesland.scp.application.facade.vo.param.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(value = "订货单追加商品参数")
public class ScpDemandOrderAddItemParamVO implements Serializable {
    private static final long serialVersionUID = 8948813275681011094L;

    @ApiModelProperty(value = "商品id", required = true)
    @NotNull(message = "商品id不能为空")
    private Long itemId;

    @ApiModelProperty(value = "商品编码", required = true)
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty(value = "商品名称", required = true)
    @NotBlank(message = "商品名称不能为空")
    private String itemName;

    @ApiModelProperty(value = "订货数量", required = true)
    @NotNull(message = "订货数量不能为空")
    private BigDecimal demandQuantity;

    @ApiModelProperty(value = "SPU商品编码", required = true)
    @NotNull(message = "SPU商品编码不能为空")
    private String spuItemCode;

    @ApiModelProperty(value = "单位", required = true)
    @NotNull(message = "单位不能为空")
    private String uom;

    @ApiModelProperty(value = "单位名称", required = true)
    @NotNull(message = "单位名称不能为空")
    private String uomName;

    @ApiModelProperty("SPU商品名称")
    private String spuItemName;
}
