package com.elitesland.scp.application.facade.vo.param.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

@Data
@ApiModel(value = "订货订单明细参数")
public class ScpDemandOrderItemParamVO implements Serializable {
    private static final long serialVersionUID = 5231978221986074352L;

    @ApiModelProperty(value = "商品ID", required = true)
    @NotNull(message = "商品ID不能为空")
    private Long itemId;

    @ApiModelProperty(value = "商品编码", required = true)
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty(value = "商品名称", required = true)
    @NotBlank(message = "商品名称不能为空")
    private String itemName;

    @ApiModelProperty("商品分类")
    @NotBlank(message = "商品分类不能为空")
    private String itemType;

    @NotNull(message = "spuId不能为空")
    private Long spuId;

    @ApiModelProperty("SPU商品编码")
    @NotNull(message = "SPU商品编码不能为空")
    private String spuItemCode;
    private String spuItemName;

    @ApiModelProperty(value = "订货单位", required = true)
    @NotBlank(message = "订货单位不能为空")
    private String unit;
    private String unitName;

    @ApiModelProperty(value = "门店编码/仓库编码", required = true)
    @NotBlank(message = "门店编码/仓库编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "需求日期", required = true)
    @NotNull(message = "需求日期不能为空")
    private LocalDateTime demandDate;

    @ApiModelProperty(value = "类型", required = true)
    @NotBlank(message = "类型不能为空")
    private String type;

    @ApiModelProperty(value = "需求数量")
    private BigDecimal demandQuantity;

    @ApiModelProperty(value = "单据类型")
    private String docType;

    @ApiModelProperty(value = "业务类型")
    @NotBlank(message = "业务类型不能为空")
    private String businessType;

    @ApiModelProperty(name = "配送类型")
    private String deliveryType;

    @ApiModelProperty(name = "配送类型列表")
    private List<String> deliveryTypes;

    @ApiModelProperty(value = "基本单位", required = true)
    @NotBlank(message = "基本单位不能为空")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty(value = "单位转换系数", required = true)
    @NotNull(message = "单位转换系数不能为空")
    private BigDecimal uomRatio;

    @ApiModelProperty(value = "有效小数位数", required = true)
    @NotNull(message = "有效小数位数")
    private Integer decimalPlaces;

    public Long fetchImageId() {
        if (Objects.equals(itemCode, spuItemCode)) {
            return spuId;
        }
        return itemId;
    }
}

