package com.elitesland.scp.application.service.alloc;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.*;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingSaveVO;

import java.util.List;

public interface ScpAllocSettingService {

    /**
     * 订货强配活动查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpAllocSettingPageRespVO> page(ScpAllocSettingPageParamVO paramVO);

    /**
     * 订货强配活动详情查询
     *
     * @param id
     * @return
     */
    ScpAllocSettingRespVO findAllocSettingById(Long id);

    /**
     * 订货强配活动保存
     *
     * @param saveVO
     * @return
     */
    Long saveAllocSetting(ScpAllocSettingSaveVO saveVO);

    /**
     * 删除
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 变更状态
     *
     * @param paramVO
     * @return
     */
    void changeAllocSettingStatus(ScpAllocSettingStatusParamVO paramVO);


    void storeRefresh(ScpAllocSettingStoreRefreshParamVO paramVO);


    void storeChangeMaxNum(List<ScpAllocSettingStoreChangeParamVO>  paramVO);


    List<ScpAllocSettingStoreRespVO> importStoreData(List<ScpAllocSettingImportStoreParamVO> list);


}
